from IscsiTargetLunUpdateFile import IscsiTargetLunUpdate

def index(req, **kwargs):
    
    data = {}
    
    try:
        data['sid'] = kwargs['sid']
        data['ip'] = kwargs['ip']
        data['action'] = kwargs['action']
    except:
        return -1
    
    try:
        data['req_type'] = kwargs['req_type']
    except:
        data['req_type'] = 'desktop'
    
    if data['action'] == 'get_targets':
        return invoke_get_targets(data)
    
    elif data['action'] == 'get_lun_list':
        try:
            data['index'] = kwargs['index']
            data['ostype'] = kwargs['ostype']
        except:
            return -1
        return invoke_get_lun_list(data)
    
    elif data['action'] == 'save_order':
        try:
            data['index'] = kwargs['index']
            data['lunnamestr'] = kwargs['lunnamestr']
        except:
            return -1
        return invoke_set_lunlist_order(data)
    
    elif data['action'] == 'delete_lun':
        try:
            data['index'] = kwargs['index']
            data['lunnamestr'] = kwargs['lunnamestr']
        except:
            return -1
        return invoke_delete_lun(data)
    
    return -1
    
def invoke_get_targets(data):
    obj =  IscsiTargetLunUpdate(data['sid'], data['ip'])
    return obj.get_targets(data)

def invoke_get_lun_list(data):
    obj =  IscsiTargetLunUpdate(data['sid'], data['ip'])
    return obj.get_lun_list(data['index'], data['ostype'])

def invoke_set_lunlist_order(data):
    obj =  IscsiTargetLunUpdate(data['sid'], data['ip'])
    return obj.set_lunlist_order(data['index'], data['lunnamestr'])

def invoke_delete_lun(data):
    obj =  IscsiTargetLunUpdate(data['sid'], data['ip'])
    return obj.delete_lun(data['index'], data['lunnamestr'])