from IscsiTargetAclUpdateFile import IscsiTargetAclUpdate

def index(req, **kwargs):
    
    data = {}
    
    try:
        data['sid'] = kwargs['sid']
        data['ip'] = kwargs['ip']
        data['action'] = kwargs['action']
    except:
        return -1
    
    try:
        data['req_type'] = kwargs['req_type']
    except:
        data['req_type'] = 'desktop'
    
    if data['action'] == 'get_targets':
        return invoke_get_targets(data)
    
    elif data['action'] == 'get_acl_list':
        try:
            data['index'] = kwargs['index']
            data['ostype'] = kwargs['ostype']
        except:
            return -1
        return invoke_get_acl_list(data)
    
    elif data['action'] == 'delete_acl':
        try:
            data['index'] = kwargs['index']
            data['aclnamestr'] = kwargs['aclnamestr']
        except:
            return -1
        return invoke_delete_acl(data)
    
    return -1
    
def invoke_get_targets(data):
    obj =  IscsiTargetAclUpdate(data['sid'], data['ip'])
    return obj.get_targets(data)

def invoke_get_acl_list(data):
    obj =  IscsiTargetAclUpdate(data['sid'], data['ip'])
    return obj.get_acl_list(data['index'], data['ostype'], data['req_type'])

def invoke_delete_acl(data):
    obj =  IscsiTargetAclUpdate(data['sid'], data['ip'])
    return obj.delete_acl(data['index'], data['aclnamestr'])