from FoiscsiInitiatorInstanceFile import FoiscsiInitiatorInstance

import settings
logging = settings.get_logger()

def index(req, **kwargs):
    
    data = {}
    try:
        data['req_type'] = kwargs['req_type']
        data['sid'] = kwargs['sid']
        data['ip'] = kwargs['ip']
        data['action'] = kwargs['action']
    except:
        return '-1'
    
    if data['action'] == 'get':
        try:
            data['devno'] = kwargs['devno']
            data['nodeid'] = kwargs['nodeid']
        except:
            return '-1'
        return invoke_get_initial_data(data)
    
    elif data['action'] == 'clear':
        try:
            data['devno'] = kwargs['devno']
            data['nodeid'] = kwargs['nodeid']
        except:
            return '-1'
        return invoke_clear(data)
    
    elif data['action'] == 'save':
        try:
            data['devno'] = kwargs['devno']
            data['nodeid'] = kwargs['nodeid']
            data['node_name'] = kwargs['node_name']
            data['alias'] = kwargs['alias']
            data['i_uname'] = kwargs['i_uname']
            data['i_secret'] = kwargs['i_secret']
        except:
            return '-1'
        return invoke_save(data)
    
def invoke_get_initial_data(data):
    obj =  FoiscsiInitiatorInstance( sid = data['sid'], ip = data['ip'], req_type = data['req_type'])
    return obj.get_initial_data(data)

def invoke_clear(data):
    obj =  FoiscsiInitiatorInstance( sid = data['sid'], ip = data['ip'], req_type = data['req_type'])
    return obj.clear_data(data)

def invoke_save(data):
    obj =  FoiscsiInitiatorInstance( sid = data['sid'], ip = data['ip'], req_type = data['req_type'])
    return obj.save_data(data)