from FcoeFile import Fcoe
import simplejson

def index(req, **kwargs):
    
    data = {}
    try:
        data['sid'] = kwargs['sid']
        data['ip'] = kwargs['ip']
        data['action'] = kwargs['action']
        data['adapname'] = kwargs['adapname']
        data['flportindex'] = kwargs['flportindex']
        data['frport_index'] = kwargs['frport_index']
        data['ostype'] = kwargs['ostype']
        data['unique_inc'] = kwargs['unique_inc']
    except:
        return '-1'
    
    if data['action'] == 'get_initial_data':
        return invoke_get_initial_data(data)
    elif data['action'] == 'get_lun_details':
        try:
            data['lun_idx'] = kwargs['lun_idx']
        except:
            return '-1'
        return invoke_get_lun_details(data)
    else:
        return -1
    
def invoke_get_initial_data(data):
    
    fcoe_obj =  Fcoe(data['sid'], data['ip'])
    luns_obj = fcoe_obj.list_luns(data['adapname'], data['flportindex'], data['frport_index'], data['ostype'])
    
    if luns_obj == -2 or luns_obj == 1:
          return luns_obj    
    
    unique_parent_id = '#frport_content__%s__%s .fcoe_rlun_details_tab'%( data['unique_inc'], data['ip'].replace('.','_') )
    li_html = '<li onclick="frld_select_lun(\'%s\', $(this), \'%s\')">Lun %s<input type="hidden" value="%s" class="lun_idx" /></li>'
    html_list = [ li_html%( unique_parent_id, data['ip'].replace('.','_'), l, l ) for l in range(0,len(luns_obj)) ]
    return  '<ul class="ul_menu">%s</ul>'%( ''.join(html_list) )

def invoke_get_lun_details(data):
    
    fcoe_obj =  Fcoe(data['sid'], data['ip'])
    luns_obj = fcoe_obj.list_luns(data['adapname'], data['flportindex'], data['frport_index'], data['ostype'])
    
    return_data = {}
    if luns_obj == -2 or luns_obj == 1:
        return_data['status'] = luns_obj
        return simplejson.dumps(return_data)
      
    return_data['status'] = 0
    return_data['capacity'] = luns_obj[int(data['lun_idx'])].capacity
    return_data['scsi_address'] = luns_obj[int(data['lun_idx'])].btl
    return_data['lun_id'] = luns_obj[int(data['lun_idx'])].getLunId() 
    return simplejson.dumps(return_data)
    
