from BulkOptionRomFile import BulkOptionRom
from xml.dom.minidom import Document

import os, settings
logging = settings.get_logger()

def index(req, **kwargs):
    data = {}
    
    try:
        data['sid'] = kwargs['sid']
        action = kwargs['action']
        data['req_type'] = kwargs['req_type']
    except:
        return generate_status_xml('-1')
    
    if action == 'get_initial_data':
        return invoke_get_initial_data(data)
   
    elif action == 'upload':
        req.content_type = "application/xml"
        try:
            data['username'] = kwargs['user']
            data['name'] = kwargs['name']
            data['rom_file'] = req.form[data['name']]
            data['group_name'] = kwargs['group_name']
        except:
            return generate_status_xml('-1')
        
        if data['rom_file'].filename:
            # strip leading path from file name to avoid directory traversal attacks
            data['fname'] = os.path.basename(data['rom_file'].filename)
            data['drpath'] = upload_file(data)
            if not data['drpath']:
                req.content_type = "application/xml"
                return generate_status_xml('-1')
            else:
                return invoke_upload_rom(data)
        else:
            return generate_status_xml('-1')
    
    elif action == 'erase_option_rom':
        try:
            data['group_name'] = kwargs['group_name']
        except:
            return -1
        return invoke_erase_option_rom(data)
    
    elif action == 'set_default_settings':
        try:
            data['group_name'] = kwargs['group_name']
        except:
            return -1
        return invoke_set_default_settings(data)
    
    else:
        return generate_status_xml('-1')
    
    return '-1'


def upload_file(data):
    
    try:
        filename = data['rom_file'].filename
        dir_path = settings.get_user_folder_path(data['username'])
        open(os.path.join(dir_path, filename), 'wb').write(data['rom_file'].file.read())
        message = 'The file "%s" was uploaded successfully in the specified user path by python'%filename
        return dir_path+filename
    except:
        return 0
    
def invoke_upload_rom(data):
    obj = BulkOptionRom(data['sid'], data['req_type'])
    return obj.flash_rom(data)

def invoke_erase_option_rom(data):
    obj = BulkOptionRom(data['sid'], data['req_type'])
    return obj.erase_option_rom(data)

def invoke_set_default_settings(data):
    obj = BulkOptionRom(data['sid'], data['req_type'])
    return obj.set_default_settings(data)

def invoke_get_initial_data(data):
    obj = BulkOptionRom(data['sid'], data['req_type'])
    return obj.get_initial_data(data)

def generate_status_xml(status):
    doc = Document()
    driver_installation = doc.createElement("DriverInstallation")
    doc.appendChild(driver_installation)
    
    status_node = doc.createElement("status")
    driver_installation.appendChild(status_node)
    
    status_value = doc.createTextNode(str(status))
    status_node.appendChild(status_value)
    
    return doc.toprettyxml()