from BulkManageMachineGroupsFile import BulkManageMachineGroups

def index(req, **kwargs):
    data = {}
    try:
        data['sid'] = kwargs['sid']
        data['action'] = kwargs['action']
        data['req_type'] = kwargs['req_type']
    except:
        return '-1'
    
    if data['action'] == 'get_initial_data':
        return invoke_get_initial_data(data)
    
    elif data['action'] == 'create_gp':
        try:
            data['group_name'] = kwargs['group_name']
            data['grouptype'] = kwargs['grouptype']
            data['gpostype'] = kwargs['gpostype']
        except:
            return '-1'
        return invoke_create_group(data)
    
    elif data['action'] == 'get_sys':
        try:
            data['group_name'] = kwargs['group_name']
        except:
            return '-1'
        return invoke_get_sys(data)
    
    elif data['action'] == 'delete_gp':
        try:
            data['group_name'] = kwargs['group_name']
        except:
            return '-1'
        return invoke_delete_group(data)
    
    elif data['action'] == 'delete_sys':
        try:
            data['group_name'] = kwargs['group_name']
            data['index'] = kwargs['index']
        except:
            return '-1'
        return invoke_delete_sys(data)
    
    elif data['action'] == 'save_sys':
        try:
            data['group_name'] = kwargs['group_name']
            data['sys_ip'] = kwargs['sys_ip']
            data['username'] = kwargs['username']
            data['pwd'] = kwargs['pwd']
            data['adpater'] = kwargs['adpater']
            data['pciid'] = kwargs['pciid']
            data['ifname'] = kwargs['ifname']
            data['port_instance'] = kwargs['port_instance']
            data['fetch_data'] = kwargs['fetch_data']
            data['desc'] = kwargs['desc']
        except:
            return '-1'
        return invoke_save_sys(data)
    
    elif data['action'] == 'fetch_data':
        try:
            data['sys_ip'] = kwargs['sys_ip']
            data['username'] = kwargs['username']
            data['pwd'] = kwargs['pwd']
            data['group_type'] = kwargs['group_type'].lower()
        except:
            return '-1'
        return invoke_fetch_data(data)

def invoke_get_initial_data(data):
    obj =  BulkManageMachineGroups(data['sid'], data['req_type'])
    return obj.get_initial_data()

def invoke_create_group(data):
    obj =  BulkManageMachineGroups(data['sid'], data['req_type'])
    return obj.create_group(data)

def invoke_delete_group(data):
    obj =  BulkManageMachineGroups(data['sid'], data['req_type'])
    return obj.delete_group(data)

def invoke_save_sys(data):
    obj =  BulkManageMachineGroups(data['sid'], data['req_type'])
    return obj.save_sys(data)

def invoke_delete_sys(data):
    obj =  BulkManageMachineGroups(data['sid'], data['req_type'])
    return obj.delete_sys(data)

def invoke_get_sys(data):
    obj =  BulkManageMachineGroups(data['sid'], data['req_type'])
    return obj.get_sys(data)

def invoke_fetch_data(data):
    obj =  BulkManageMachineGroups(data['sid'], data['req_type'])
    return obj.fetch_data(data)