from BulkCardConfFile import BulkCardConf
import simplejson

def index(req, **kwargs):
    data = {}
    
    try:
        data['sid'] = kwargs['sid']
        action = kwargs['action']
        data['req_type'] = kwargs['req_type']
    except:
        return -1
    
    if action == 'get_initial_data':
        return invoke_get_initial_data(data)
   
    elif action == 'set_card_props':
        try:
            data['group_name'] = kwargs['group_name']
            data['prop_str'] = kwargs['prop_str'].replace(',,', ' ')
        except:
            return -1
        return invoke_set_card_props(data)
    
    elif action == 'get_props':
        
        return_data = {}
        
        try:
            data['ostype'] = kwargs['ostype'].lower()
            data['gptype'] = kwargs['gptype'].lower()
        except:
            return_data['status'] = '-1'
            return simplejson.dumps(return_data)
        
        return simplejson.dumps(invoke_get_props(data))
        
    return '-1'

def invoke_get_initial_data(data):
    obj = BulkCardConf(data['sid'], data['req_type'])
    return obj.get_initial_data(data)

def invoke_get_props(data):
    obj = BulkCardConf(data['sid'], data['req_type'])
    return obj.get_props(data)

def invoke_set_card_props(data):
    obj = BulkCardConf(data['sid'], data['req_type'])
    return obj.set_card_props(data)