from BulkBypassFile import BulkBypass
from xml.dom.minidom import Document

import os, settings
logging = settings.get_logger()

def index(req, **kwargs):
    data = {}
    
    try:
        data['sid'] = kwargs['sid']
        data['req_type'] = kwargs['req_type']
        action = kwargs['action']
    except:
        return generate_status_xml('-1')
    
    if action == 'get_initial_data':
        return invoke_get_initial_data(data)
    elif action == 'start_baserver':
        data['group_name'] = kwargs['group_name']
        return invoke_start_stop_ba(action, data)
    elif action == 'stop_baserver':
        data['group_name'] = kwargs['group_name']
        return invoke_start_stop_ba(action, data)
    elif action == 'configure':
        data['group_name'] = kwargs['group_name']
        data['propname'] =  kwargs['propname']
        data['value'] =  kwargs['value']
        return invoke_set_byp_conf(data)
    
    elif action == 'upload_rdt_dump':
        data['group_name'] = kwargs['group_name']
        data['username'] = kwargs['user']
        data['name'] = kwargs['name']
        data['dump_file'] = req.form[data['name']]
        req.content_type = "application/xml"
        
        if data['dump_file'].filename:
            # strip leading path from file name to avoid directory traversal attacks
            data['fname'] = os.path.basename(data['dump_file'].filename)
            data['drpath'] = upload_file(data)
            if not data['drpath']:
                return '-1' 
            else:
                return invoke_set_rdt_conf(data)

    return '-1'

def upload_file(data):
    
    try:
        filename = data['dump_file'].filename
        dir_path = settings.get_user_folder_path(data['username'])
        open(os.path.join(dir_path, filename), 'wb').write(data['dump_file'].file.read())
        message = 'The file "%s" was uploaded successfully in the specified user path by python'%filename
        return dir_path+filename
    except:
        return 0

def invoke_get_initial_data(data):
    obj = BulkBypass(data['sid'], data['req_type'])
    return obj.get_initial_data(data)

def invoke_start_stop_ba(action, data):
    obj = BulkBypass(data['sid'], data['req_type'])
    return obj.start_stop_server(action, data)

def invoke_set_byp_conf(data):
    obj = BulkBypass(data['sid'], data['req_type'])
    return obj.set_server_config(data)

def invoke_set_rdt_conf(data):
    obj = BulkBypass(data['sid'], data['req_type'])
    return obj.set_redirect_config(data)

def generate_status_xml(status):
    doc = Document()
    driver_installation = doc.createElement("bypass")
    doc.appendChild(driver_installation)
    
    status_node = doc.createElement("status")
    driver_installation.appendChild(status_node)
    
    status_value = doc.createTextNode(str(status))
    status_node.appendChild(status_value)
    
    return doc.toprettyxml()
