from HypervisorFile import Hypervisor

def index(req, **kwargs):
    data = {}
    try:
        data['sid'] = kwargs['sid']
        data['ip']  = kwargs['ip']
        data['action'] = kwargs['action']
    except:
        return '-1'
    
    if data['action'] == 'get_switch_name':
        return invoke_get_switch_names(data)
    elif data['action'] == 'get_pg_names':
        return invoke_get_pg_names(data)
    elif data['action'] == 'get_vswifname':
        return invoke_get_vswifname(data)
    elif data['action'] == 'create':
        try:
            data['action'] = kwargs['action_param']
            data['vmnic'] = kwargs['vmnic']
            data['reqType'] = kwargs['reqType']
            data['VSwitchName'] = kwargs['VSwitchName']
            data['PGName'] = kwargs['PGName']
        except:
            return '-1'
        
        return invoke_create_virtual_network(data)
    elif data['action'] == 'create_vwsif':
        try:
            data['ipType'] = kwargs['ipType']
            data['VSwifName'] = kwargs['VSwifName']
            data['PGName'] = kwargs['PGName']
            data['action_ip'] = kwargs['action_ip']
            data['mask'] = kwargs['mask']
        except:
            return '-1'
        
        return invoke_create_vwsif(data)
    else:
        return -1

def invoke_get_switch_names(data):
    vnt_obj =  Hypervisor(data['sid'], data['ip'])
    return vnt_obj.get_switch_names()

def invoke_get_pg_names(data):
    vnt_obj =  Hypervisor(data['sid'], data['ip'])
    return vnt_obj.get_pg_names()

def invoke_create_vwsif(data):
    vnt_obj =  Hypervisor(data['sid'], data['ip'])
    return vnt_obj.create_vwsif(data)

def invoke_get_vswifname(data):
    vnt_obj =  Hypervisor(data['sid'], data['ip'])
    return vnt_obj.get_vswifname()

def invoke_create_virtual_network(data):
    vnt_obj =  Hypervisor(data['sid'], data['ip'])
    return vnt_obj.create_virtual_network(data)