from UmBoostLib import VMList, XenVMsList, Xen_vmSummary, XenVFsList, VFPciList, Xen_VfSummary
import simplejson, settings
logging = settings.get_logger()


class XenVfProps(object):
    def __init__(self, sid, ip):
        self.sid = sid
        self.ip = ip

    def get_xen_props_data(self):
        
        self.unique_parent_id = '#system_content__incend__'+ self.ip.replace('.','_') +' .system_xen_vf_props_tab'
        data_dict = {}
        self.vm_pci = [] 
        data_dict['vm_html'] = self.getVMsData()
        data_dict['pci_html'] = self.getPCisData()
        data_dict['iommu'] = self.getIommuStatus()
        return simplejson.dumps(data_dict)
        
    def getVMsData(self):
        self.agmtVMListObj = VMList()
        self.mainXenVMsListObj = XenVMsList()
        
        logging.info('Xen VF Props: Get VMs waiting for response from UMboost sid : %s , IP : %s'%(self.sid, self.ip))
        status = self.mainXenVMsListObj.ListVMs(self.agmtVMListObj, self.sid, self.ip)
        logging.info('Xen VF Props: Get VMs status: %s, len : %s'%(status,len(self.agmtVMListObj)))
        
        if status == 0:
           return self.generateVmHtml()
        elif status == -2:
            return -2
        else:
            return -1
        
    def getPCisData(self):
        
        self.agmtVFPciListObj = VFPciList()
        self.mainXenVFsListObj = XenVFsList()
        logging.info('Xen VF Props: Get PCI-s waiting for response from UMboost sid : %s , IP : %s'%(self.sid, self.ip))
        status = self.mainXenVFsListObj.ListVFs(self.agmtVFPciListObj, self.sid, self.ip)
        logging.info('Xen VF Props: Get PCI-s status: %s, len : %s'%(status, len(self.agmtVFPciListObj)))
        
        if status == 0:
            return self.generatePciHtml()  
        elif status == -2:
            return -2
        else:
            return -1
        
    def getIommuStatus(self):
        
        self.mainXenVfSummaryObj = Xen_VfSummary()
        logging.info('Xen VF Props: Get IOMMU Status waiting for response from UMboost sid : %s , IP : %s'%(self.sid, self.ip))
        status = self.mainXenVfSummaryObj.getIOMMU(self.sid, self.ip)
        logging.info('Xen VF Props: Get IOMMU Status: %s, iommu_status :%s'%(status, self.mainXenVfSummaryObj.iommu))
        
        if status == 0 or status == 1:
            return self.mainXenVfSummaryObj.iommu
            #return status  
        elif status == -2:
            return -2
        else:
            return -1
        
    def generateVmHtml(self):

        #Generate VM Html
        vm_html = '<li class="vms" onclick="select_vm(\''+ self.unique_parent_id +'\', $(this))">%s\
                <input type = "hidden" value = "%s" class = "uuid" />\
                </li>'
        
        vm_html_list = [] 
        logging.info('loooop begins')
        for i in range(len(self.agmtVMListObj)):
            vm_html_list.append(vm_html%( self.mainXenVMsListObj.get(self.agmtVMListObj,i).name_label,\
                         self.mainXenVMsListObj.get(self.agmtVMListObj,i).uuid))
            #Append already mapped pci to vm_pci list, it should not be displayed on the front end
            vfpci = self.mainXenVMsListObj.get(self.agmtVMListObj,i).vfpci.strip()
            
            logging.info('vfpci : %s'%vfpci)
            #if vfpci != 'NONE' , then no pci has been assigned. hence can skip the step
            is_vfpci = True
            if vfpci == 'NONE' or vfpci == '':
                is_vfpci = False
                
            if is_vfpci:
                #Extraction multiple assigned pci's
                vfpci_list = vfpci.split(',')
                logging.info('vfpci_list : %s'%vfpci_list)
                #Extracing only the pci, by removing the common "0/0000:"
                #self.vm_pci.extend([ i.split('0000:')[1] for i in vfpci_list])
                for i in vfpci_list:
                    logging.info('-------------i :%s'%i)
                    if i.count('0000:'):
                        self.vm_pci.append(i.split('0000:')[1])
                    else:
                        self.vm_pci.append(i)
                        
        logging.info('vm_pci : %s'%self.vm_pci)
        logging.info('loooop ends')
        
        return '<ul class="vm_ul">'+''.join(vm_html_list)+'</ul>'
    
    def generatePciHtml(self):

        #Generate Pci Html
        pci_html = '<li class="pcis" onclick="select_vmpci(\''+ self.unique_parent_id +'\', $(this))">%s\
                <input type = "hidden" value = "%s" class = "vfpci" />\
                </li>'
        
        pci_html_list = []
        
        for i in range(len(self.agmtVFPciListObj)):
            #Save only the one which is not yet assigned by any VMs
            vf_pci_val = self.mainXenVFsListObj.get(self.agmtVFPciListObj,i).vf_pci
            logging.info('---------PCI  in loop : %s'%vf_pci_val)
            if vf_pci_val not in self.vm_pci:
                pci_html_list.append(pci_html%( vf_pci_val,\
                             vf_pci_val))
            
        return '<ul class="pci_ul">'+''.join(pci_html_list)+'</ul>'
    

    def set_operations(self, data):
        
        data_dict = {}
        data_dict['assign_status'] = self.assign_vfs_to_vm(data)
        return simplejson.dumps(data_dict)
        
        
    def assign_vfs_to_vm(self, data):
        
        self.mainAssignVfSumObj = Xen_VfSummary()
        
        vfpci = data['vfpci'][1:len(data['vfpci'])-1].replace(',,',',')
        logging.info('Xen VF Props: Assign Vfs to VMs waiting for response from UMboost sid : %s , IP : %s, vmuuid : %s, vfpci : %s\
                    '%(self.sid, self.ip, data['uuid'], vfpci))
        status = self.mainAssignVfSumObj.AssignVfsToVMs(self.sid, self.ip, data['uuid'], vfpci)
        logging.info('Xen VF Props: Assign Vfs status: %s'%status)
        
        if status == 0 or status == -2:
           return status
        else:
            return -1
        
    def setIommu(self, iommu_val):
        
        self.mainXenVfSummaryObj = Xen_VfSummary()
        
        logging.info('Xen VF Props: Set Iommu waiting for response from UMboost sid : %s , IP : %s, iommu : %s'%(self.sid, self.ip, iommu_val))
        status = self.mainXenVfSummaryObj.setIOMMU(self.sid, self.ip, int(iommu_val))
        logging.info('Xen VF Props: Set Iommu status: %s'%status)
        
        if status == 0 or status == -2 or status == 320:
           return status
        else:
            return -1
        