from UmBoostLib import XenBridgeList, BridgeList, VMList, XenVMsList, Xen_BridgeSummary, Xen_vifSummary
import simplejson
from utils import validate_mac, get_error_string

import logging
import settings
logging.basicConfig(filename=settings.log_path, level=settings.log_level)

class XenAddVirtualNwConf(object):
    
    def __init__(self, sid, ip, type):
        self.sid = sid
        self.ip = ip
        self.type = type
    
    def get_initial_data(self):
        
        data = {}
        data['bridge_html'] = self.list_bridge()
        data['vm_html'] = self.list_vms()
        return simplejson.dumps(data)
        
    def list_bridge(self):
        
        logging.info('Hypervisor - Xen Add virtual Network Configuration ListBridges : Sid : %s, Ip : %s'%( self.sid, self.ip ))
        self.mainXenBridgeListobj = XenBridgeList()
        self.agmtBridgeListobj = BridgeList()
        status = self.mainXenBridgeListobj.ListBridges( self.agmtBridgeListobj, self.sid, self.ip )
        logging.info('Hypervisor - Xen Add virtual Network Configuration ListBridges status : %s'%( status ))
        
        if status == 0:
            return  self.build_bridge_html()
        elif status == -2:
            return -2
        else:
            return -1
        
    def build_bridge_html(self):
        
        bridge_html = '<option value="%s">%s</option>'
        
        bridge_html_list = [ bridge_html %( self.mainXenBridgeListobj.get(self.agmtBridgeListobj,i).network_uuid,
                           self.mainXenBridgeListobj.get(self.agmtBridgeListobj,i).bridge_name  ) 
                           for i in range(len(self.agmtBridgeListobj)) ]
        
        return '<select class="bridge">%s</select>'%(''.join(bridge_html_list))
        
    
    def list_vms(self):
        
        self.agmtVMListObj = VMList()
        self.mainXenVMsListObj = XenVMsList()
        
        logging.info('Hypervisor - Xen Add virtual Network Configuration List VMs sid : %s , IP : %s'%(self.sid, self.ip))
        status = self.mainXenVMsListObj.ListVMs(self.agmtVMListObj, self.sid, self.ip)
        logging.info('Hypervisor - Xen Add virtual Network Configuration List VMs status: %s'%status)
        
        if status == 0:
            return  self.build_vm_html()
        elif status == -2:
            return -2
        else:
            return -1
        
    def build_vm_html(self):
        
        bridge_html = '<option value="%s">%s</option>'
        
        bridge_html_list = [ bridge_html %( self.mainXenVMsListObj.get(self.agmtVMListObj,i).uuid,
                           self.mainXenVMsListObj.get(self.agmtVMListObj,i).name_label  ) 
                           for i in range(len(self.agmtVMListObj)) ]
        
        return '<select class="vm">%s</select>'%(''.join(bridge_html_list))
    
    
    def create_bridge(self, data):
        
        logging.info('Hypervisor - Xen Add virtual Network Configuration create bridge : Sid : %s, Ip : %s, name_label : %s, name_description : %s, mtu : %s '%( self.sid, self.ip, data['bname'], data['bname_desc'], data['bmtu'] ))
        self.mainXenBridgeListobj = Xen_BridgeSummary()
        status = self.mainXenBridgeListobj.CreateBridge( self.sid, self.ip, data['bname'], data['bname_desc'], data['bmtu'] )
        logging.info('Hypervisor - Xen Add virtual Network Configuration create bridge status : %s'%( status ))
        
        if status == 0 or status == -2:
            return status
        else:
            return get_error_string(status)
        
    def create_vif(self, data):
        
        #Validate MAC
        if data['mac'].strip() != '':
            logging.info('Mac validate - Mac : %s'%data['mac'])
            status = validate_mac(data['mac'])
            logging.info('Mac validate status : %s'%status)
            if status != 0:
                if status == -2:
                    return status
                else:
                    return -5
        
        self.mainVIFSumobj = Xen_vifSummary()
        logging.info('Hypervisor - Xen Add virtual Network Configuration create VIF : Sid : %s, Ip : %s, device_id : %s, bridge_uuid : %s, vm_uuid : %s, mac : %s '%( self.sid, self.ip, data['device_id'], data['bridge_uuid'], data['vm_uuid'], data['mac'] ))
        status = self.mainVIFSumobj.CreateVif( self.sid, self.ip, data['device_id'], data['bridge_uuid'], data['vm_uuid'], data['mac'] )
        logging.info('Hypervisor - Xen Add virtual Network Configuration create VIF status : %s'%( status ))
        
        if status == 0 or status == -2:
            return status
        else:
            return get_error_string(status)