from UmBoostLib import ExtPortsList, ExtPortList, InterfaceList, IntfList, winSwitch_Summary
import simplejson

import settings
logging = settings.get_logger()

class WinAddVirtualNwConf(object):
    
    def __init__(self, sid, ip, type):
        self.sid = sid
        self.ip = ip
        self.type = type
    
    def get_initial_data(self):
        
        data = {}
        data['ext_ports_html'] = self.list_external_ports()
        #data['interface_html'] = self.list_interface()
        return simplejson.dumps(data)
    
    def list_external_ports(self):
        
        logging.info('Win Add virtual Network Configuration ListSwitchs : Sid : %s, Ip : %s'%( self.sid, self.ip ))
        self.mainExtPortsListobj = ExtPortsList()
        self.agmtExtPortsListobj = ExtPortList()
        status = self.mainExtPortsListobj.ListExternalPorts( self.agmtExtPortsListobj, self.sid, self.ip )
        logging.info('win Add virtual Network Configuration ListSwitchs status : %s, len : %s'%( status, len(self.agmtExtPortsListobj) ))
        
        if status == 0:
            return  self.build_extports_html()
        elif status == -2:
            return -2
        else:
            return -1
        
    def build_extports_html(self):
        
        extports_html = '<option value="%s">%s</option>'
        extports_html_list = [ extports_html %( self.mainExtPortsListobj.get(self.agmtExtPortsListobj,i).DeviceId,
                           self.mainExtPortsListobj.get(self.agmtExtPortsListobj,i).Description  ) 
                           for i in range(len(self.agmtExtPortsListobj)) ]
        return '<select class="extports">%s</select>'%(''.join(extports_html_list))
    
    
    '''def list_interface(self):
        
        self.boostInterfaceList = InterfaceList()
        self.boostNWInterfaceObj = IntfList()
        logging.info('Win Add virtual networks - Get Interface List: waiting for response from UMboost sid : %s , UmServerIP : %s'%(self.sid, self.ip))
        status = self.boostInterfaceList.getNetworkInformation(self.boostNWInterfaceObj, self.sid, self.ip)
        logging.info('Win Add virtual networks - Get Interface List: %s'%(status))
        
        if status == 0:
            return self.generate_interface_html()
        elif status == -2:
            return -2
        else:
            return -1
       
    def generate_interface_html(self):
        
        interface_html = '<option value="%s">%s</option>'
        interface_html_list = [ interface_html %( self.boostInterfaceList.get(self.boostNWInterfaceObj,i).FriendlyName,
                           self.mainExtPortsListobj.get(self.agmtExtPortsListobj,i).FriendlyName  ) 
                           for i in range(len(self.boostNWInterfaceObj)) ]
        return '<select class="interface">%s</select>'%(''.join(interface_html_list))'''
        
    
    def create_nw(self, data):
        
        logging.info('win Add virtual Network Configuration create network : Sid : %s, Ip : %s, nw_name : %s, portType : %s, portGuid : %s '%( self.sid, self.ip, data['nw_name'], data['portType'], data['portGuid'] ))
        self.mainwinSwitchListobj = winSwitch_Summary()
        status = self.mainwinSwitchListobj.CreateVswitch( self.sid, self.ip, data['nw_name'], int(data['portType']), data['portGuid'] )
        logging.info('win Add virtual Network Configuration create network status : %s'%( status ))
        
        if status == 0 or status == -2:
            return status
        else:
            return -1