from UmBoostLib import vsList, VswitchList, PortGroupList, epgList

import logging
import settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)

class VirtualNetworkTopology:
    
    def __init__(self, sid, ip):
        self.sid    =   sid
        self.ip     =   ip
    
    def get_switch_tree(self, data):
        logging.info('Hypervisor - Virtual Network Topology getVswitchList : Sid : %s, Ip : %s'%( self.sid, self.ip ))
        self.vsList_obj = vsList()
        self.VswitchList_obj = VswitchList()
        status = self.VswitchList_obj.getVswitchList( self.vsList_obj, self.sid, self.ip )
        #status = 0
        logging.info('Hypervisor - Virtual Network Topology getVswitchList status : %s'%( status ))
        
        if status == 0:
            return  self.build_switch_tree()
        elif status == -2:
            return -2
            
    def build_switch_tree(self):
        
        switch_html = []
        self.plus_img = '<img src="/images/black/tree_plus.png">'
        self.minus_img = '<img src="/images/black/tree_minus.png">'
        self.unique_parent_id = '#hypervisor_content__incend__%s .virtual_network_topology_tab'%self.ip.replace('.','_')
        for i in range(0,len(self.vsList_obj)):
            class_selected = ''
            if i == 0:
                class_selected = 'selected'
            switch_name = self.VswitchList_obj.get(self.vsList_obj,i).vSwitchName
            switch_html.append('<li class="vm_tree_li">')
            switch_html.append('<a href="javascript:void(0);" onclick="" class="tree_action">%s</a>'%self.plus_img)
            switch_html.append('<a href="javascript:void(0);" class="%s vnt_switch_m" onclick="vnt_toggle_detail(\'%s\', $(this))"><img class="icon" src="images/black/switch2.png" />%s'
                               %(class_selected, self.unique_parent_id, switch_name))
            switch_html.append('<input type="hidden" value="%s" class="switch_name" />'%switch_name)
            switch_html.append('<input type="hidden" value="%s" class="mtu" />'%self.VswitchList_obj.get(self.vsList_obj,i).Mtu)
            #switch_html.append('<input type="hidden" value="%s" class="all_uplinks" />'%)
            switch_html.append('</a>')
            switch_html.append(self.get_vmnic_html(self.VswitchList_obj.get(self.vsList_obj,i).UpLinks))
            #PG Group
            groups_html = self.get_portal_groups_html(switch_name)
            if groups_html == -1 or groups_html == -2:
                return groups_html
            switch_html.append(groups_html)
            switch_html.append('</li>')
        
        '''for i in range(0,3):
            class_selected = ''
            if i == 0:
                class_selected = 'selected'
            switch_name = 'vSwitch%s'%i
            switch_html.append('<li class="vm_tree_li">')
            switch_html.append('<a href="javascript:void(0);" onclick="" class="tree_action">%s</a>'%self.plus_img)
            switch_html.append('<a href="javascript:void(0);" class="%s vnt_switch_m" onclick="vnt_toggle_detail(\'%s\', $(this))"><img class="icon" src="images/black/switch2.png" />%s'
                               %(class_selected, self.unique_parent_id, switch_name))
            switch_html.append('<input type="hidden" value="%s" class="switch_name" />'%switch_name)
            switch_html.append('<input type="hidden" value="%s" class="mtu" />'%1500)
            #switch_html.append('<input type="hidden" value="%s" class="all_uplinks" />'%)
            switch_html.append('</a>')
            switch_html.append(self.get_vmnic_html('vmnic0,vmnic1,vmnic2'))
            #PG Group
            groups_html = self.get_portal_groups_html(switch_name)
            logging.debug(groups_html)
            if groups_html == -1 or groups_html == -2:
                return groups_html
            switch_html.append(groups_html)
            switch_html.append('</li>')'''
        
        return ''.join(switch_html)
            
    def get_portal_groups_html(self, switch_name):
        logging.info('Hypervisor - Virtual Network Topology getPortGroupList : Sid : %s, Ip : %s, switch : %s'%( self.sid, self.ip, switch_name ))
        self.PortGroupList_obj = PortGroupList()
        self.pList_obj = epgList()
        status = self.PortGroupList_obj.getPortGroupList( self.pList_obj, self.sid, self.ip, switch_name )
        #status = 0
        logging.info('Hypervisor - Virtual Network Topology getPortGroupList status : %s'%( status ))
        
        html = ''
        if status == 0:
            for i in range(0, len(self.pList_obj)):
                pgname = self.PortGroupList_obj.get(self.pList_obj,i).PGName
                uplinks = self.PortGroupList_obj.get(self.pList_obj,i).UpLinks
                html += '<ul class="as_hide"><li>'
                html += '<a href="javascript:void(0);" class="tree_action vnt_pg_m">%s</a>'%self.plus_img
                html += '<a class="vnt_pg_m" href="javascript:void(0);" onclick="vnt_toggle_detail(\'%s\', $(this))" >\
                         <img class="icon" src="images/black/v_network.png" />%s'%(self.unique_parent_id, pgname)
                html += '<input type="hidden" value="%s" class="pg_name" />'%pgname
                html += '<input type="hidden" value="%s" class="uplinks" />'%uplinks
                html += '<input type="hidden" value="%s" class="vlanid" />'%self.PortGroupList_obj.get(self.pList_obj,i).VlanId
                html += '</a>'
                #Start vmincs for this pg
                uplinks = uplinks.split(',')
                for i in uplinks:
                    html += '<ul class="as_hide"><li>'
                    html += '<a href="javascript:void(0);" class="vnt_vmnic_m" onclick="vnt_toggle_detail(\'%s\', $(this))" >\
                            <img class="icon" src="images/black/pg_col.png">%s</a>'%(self.unique_parent_id, i)
                    html += '</li></ul>'
                #End pg ul
                html += '</li></ul>'
            
            '''for i in range(0, 3):
                pgname = 'Service Console %s'%i
                html += '<ul class="as_hide"><li>'
                html += '<a href="javascript:void(0);" class="tree_action vnt_pg_m">%s</a>'%self.plus_img
                html += '<a class="vnt_pg_m" href="javascript:void(0);" onclick="vnt_toggle_detail(\'%s\', $(this))" >\
                         <img class="icon" src="images/black/v_network.png" />%s'%(self.unique_parent_id, pgname)
                html += '<input type="hidden" value="%s" class="pg_name" />'%pgname
                html += '<input type="hidden" value="20" class="vlanid" />'
                html += '<input type="hidden" value="vminc0,vmnic3" class="uplinks" />'
                html += '</a>'
                #Start vmincs for this pg
                uplinks = 'vminc0,vmnic3'.split(',')
                for i in uplinks:
                    html += '<ul class="as_hide"><li>'
                    html += '<a href="javascript:void(0);" class="vnt_vmnic_m" onclick="vnt_toggle_detail(\'%s\', $(this))" >\
                            <img class="icon" src="images/black/pg_col.png">%s</a>'%(self.unique_parent_id, i)
                    html += '</li></ul>'
                #End pg ul
                html += '</li></ul>'''
            
            return html
        elif status == -2:
            return status
        else:
            return -1
        
    def get_vmnic_html(self, vmnics):
        vmnics = vmnics.split(',')
        vmnics_html = ''
        for i in vmnics:
            vmnics_html += '<ul class="as_hide"><li><a onclick = "vnt_toggle_detail(\'%s\', $(this))" href="javascript:void(0);" class="vnt_vmnic_m" >\
                            <img src="images/black/pg_col.png" class="icon">%s</a></li></ul>'%(self.unique_parent_id, i)
        return vmnics_html
            
            
            