from UmBoostLib import ConnectToUmServer as Connects
from xml.dom.minidom import Document

import settings, utils, Constants
logging = settings.get_logger()

## The instance of the class UmConnects.
class UmServerConnect:
	## Constructor for the class UmConnects
	def __init__(self,
		     sessionId,
		     hostName,
		     hostIP,
		     port,
		     UserId,
		     passwd,
		     bookmark,
		     savePasswd,
		     input_type):
		self.sessionId = sessionId
		self.hostName = hostName
		self.hostIP = hostIP
		self.UserId = UserId
		self.port = port
		self.passwd = passwd
		self.bookmark = bookmark
		self.savePasswd = savePasswd
		self.input_type = input_type
 		self.UmConnect = Connects()
		
	## Connects to the UM server based on the credentials
	def doLogin(self):
		
		if self.input_type.strip() == 'ip':
			ip_validate = utils.validate_ip(self.hostIP, 1)
			logging.info('IP Validate status %s'%ip_validate)
			if ip_validate == -1:
				return -6
		
		pwd = self.passwd
		if pwd.count('____'):
			pwd = pwd.replace('____', '/>')
		
		logging.info('system connect sid : %s , Hostname :%s , IP : %s , UserId : %s , Pwd : %s , Port : %s , Bookmark : %s , SavePwd : %s\
					'%(self.sessionId, self.hostName, self.hostIP, self.UserId, pwd, int(self.port), int(self.bookmark), int(self.savePasswd)))
		status =self.UmConnect.UmServerLogin(self.sessionId,
				self.hostName,
				self.hostIP,
				self.UserId,
				pwd,
				int(self.port),
				int(self.bookmark),
				int(self.savePasswd))
		logging.info('system connect status : %d' %status)
		
		if status == 0:
			return self.generateXML(status)
		elif status == Constants.AGT_SERVER_BUSY or status == Constants.AGT_DEAD or status == Constants.SESSION_TIMEOUT or \
			 status == Constants.AGT_INVALID_AUTH or status == Constants.AGT_VERSION_MISMATCH:
			return status
		else:
		    return -1
			
	## Disconnects from the UM server.
	def doLogout(self):
		xmlContent = ""
		logging.info('Disconnect system waiting for response from UMboost..')
		status = self.UmConnect.UmServerLogout(self.sessionId,
				 self.hostName,
				 self.hostIP)
		logging.info('Disconnect system status: %s'%status)
		
		if status == 0:
			return status
		elif status == -2 or status == 65534:
		    return -2
		else:
		    return -1

	# Returns the XML data-set
	def generateXML(self, status):
		# Create the minidom document
	    doc = Document()
	    
	    # Create the <umconnect> base element
	    umconnect = doc.createElement("umconnect")
	    doc.appendChild(umconnect)
	    
	    # Create an attribute "sid" for <umconnect>
	    umconnect.setAttribute("sid", self.sessionId)
	    
	    # Create the <umconnect> base element
	    status_el = doc.createElement("status")
	    umconnect.appendChild(status_el)
	    
	    status_value = doc.createTextNode( str(status) )
	    status_el.appendChild(status_value)
	    return doc.toprettyxml()
