from UmBoostLib import FilterT4Summary, FilT4List, FilterListT4, KList, UMKey
import simplejson, settings

logging = settings.get_logger()

class T4Filtering:
    def __init__(self, sid, ip, req_type) :
         self.sid = sid
         self.ip = ip
         self.req_type = req_type

    def get_initial_data(self, pci_str):
        filterT4Summary_obj = FilterT4Summary()
        logging.info('T4 Filtering - GetActiveCombination :waiting for response from UMboost sid : %s , IP : %s'%(self.sid, self.ip))
        status = filterT4Summary_obj.GetActiveCombination(self.sid, self.ip)
        logging.info('T4 Filtering - GetActiveCombination: result %s'%(status))
        
        filterT4Summary_obj1 = FilterT4Summary()
        status1 = filterT4Summary_obj1.GetCurrentCombinations(self.sid, self.ip, pci_str)
        
        data = {}
        if status == -2 or status1 == -2:
            data['status'] = -2
            data['status1'] = -2
            return simplejson.dumps(data)
        else:
            if status == 0:
               data['active_comb'] =  filterT4Summary_obj.comb
               data['status'] = 0
            else:
               data['status'] = -1
               data['active_comb'] = -1 
               
            if status1 == 0:
               data['current_comb'] =  filterT4Summary_obj1.CurrComb
               data['status1'] = 0
            elif status1 == 264:
               data['current_comb'] = '264'
               data['status1'] = 0
            else:
               data['current_comb'] = -1
               data['status1'] = -1
               
            return simplejson.dumps(data) 
        
    def set_comb(self, comb_str, pci_str):
        filterT4Summary_obj = FilterT4Summary()
	#FIXME Take PCI from User
        logging.info('T4 Filtering - Set Active Combination :waiting for response from UMboost sid : %s , IP : %s, pci_str = %s , comb_str : %s'%(self.sid, self.ip, pci_str, comb_str))
        status = filterT4Summary_obj.SetActiveCombination(self.sid, self.ip, pci_str.strip(), comb_str.strip())
        logging.info('T4 Filtering - Set Active Combination: result %s'%(status))
        
        if status == -2 or status == 0:
            return status
        else:
            return -1
        
    def get_comb_filters(self, getdata):
        comb_str = getdata['comb_str']
        is_active = getdata['is_active']
        pci_str = getdata['pci_str']
        self.t4cards = getdata['t4_card']
        
        self.FilT4ListObj = FilT4List()
        self.FilterListT4Obj = FilterListT4()
        status = self.FilterListT4Obj.ListFiltersT4(self.FilT4ListObj, self.sid, self.ip, pci_str.strip(),comb_str.strip(), int(is_active))
        logging.info('T4 Filtering - Get filters: result %s , len : %s'%(status, len(self.FilT4ListObj)))
        
        self.data = {}
        
        if status == -2:
            self.data['status'] = '-2'
            return simplejson.dumps(self.data)
        elif status == 0:
            self.data['status'] = '0'
            self.data['len'] = len(self.FilT4ListObj)
            return self.generateFilterHtml(comb_str)
        elif status == 264:
            self.data['status'] = '264'
            return simplejson.dumps(self.data)
        else:
            self.data['status'] = '-1'
            return simplejson.dumps(self.data)
        
    def generateFilterHtml(self, comb_str):
        
        comb_str_list = comb_str.replace(' ','').split(',')
        
        html_list = []
        width = 0
        height = 0
        total_column = 18
        head_flag = False
        cloned = False
        card_html = ''
        
        for i in range(0,len(self.FilT4ListObj)):
            
            html = ''
            height += 40
            
            if not head_flag:
                head_flag = True
                #Head html
                html += ' <ul class="horizontal head_ul"><li class="fid"><h2>FilterID</h2></li><li><h2>T4 Card</h2></li>'
                #for card
                width += 125
                
                j = 0
                total_len = len(comb_str_list)
                for k in comb_str_list:
                    width += 125
                    if j == total_len:
                        html += '<li><h2 class="bg_none">%s</h2></li>'%k
                    else:
                        if k.strip() == 'vnic_id':
                            total_column = 19
                            html += '<li><h2>pf</h2></li>\
                                     <li><h2>vf</h2></li>'
                        else:
                            html += '<li><h2>%s</h2></li>'%k
                    j += 1
                    
                html += '<li><h2>lport</h2></li>\
                        <li><h2>fport</h2></li>\
                        <li><h2>lip</h2></li>\
                        <li><h2>fip</h2></li>\
                        <li><h2>action</h2></li>\
                        <li><h2>t4vlan</h2></li>\
                        <li><h2>vlanval</h2></li>\
                        <li><h2>hitcnts</h2></li>\
                        <li><h2>prio</h2></li>\
                        <li><h2>t4queue</h2></li>\
                        <li><h2>tcbhash</h2></li>\
                        <li><h2>eport</h2></li>\
                        <li><h2>type</h2></li>\
                        <li><h2>smac</h2></li>\
                        <li><h2>dmac</h2></li>\
                        <li><h2>rpttid</h2></li>\
                        <li class="action_cmd"><h2 class="bg_none">Action Command</h2></li>'
                html += '</ul>'
            
            unique_id = 'filtering_content__incend__%s_filtering_conf_tab_%s'%( self.ip.replace('.','_'), i )
            html += '<ul class="horizontal content_tbl clear_left rules_ul fl_mod" id="%s">'%unique_id
            unique_parent_id = '#filtering_content__incend__%s .t4_filtering_conf_tab'%( self.ip.replace('.','_') )
            
            html += '<li class="label fid fid_%s">\
                        <input type="checkbox" name="fid" class="fid_chk" value="%s" onclick="t4_fl_filterid_chk(\'%s\')" />\
                        <span class="value">%s</span>\
                      </li>'%(self.FilterListT4Obj.get(self.FilT4ListObj,i).filterId, self.FilterListT4Obj.get(self.FilT4ListObj,i).filterId,\
			 unique_parent_id, self.FilterListT4Obj.get(self.FilT4ListObj,i).filterId)
            
            #Making the card selected
            rule_pci = self.FilterListT4Obj.get(self.FilT4ListObj,i).PCIBusLocation.strip()
            #Setting the class as "value_pci" so that it always sends pci as a property name while saving the rule
            card_html = '<select title="pci" class="value_pci" disabled="disabled" onchange="$(this).removeClass(\'error\')" ><option value="null" >Choose</option>'
            if type(self.t4cards) == list:
                for k in self.t4cards:
                    curr_pci = "%s"%k.split('__')[1]
                    if curr_pci == rule_pci:
                        card_html += '<option value="%s" selected="selected" >%s</option>'%(curr_pci, k.split('__')[0])
                    else:
			card_html += '<option value="%s" >%s</option>'%(curr_pci, k.split('__')[0])
            else:
                curr_pci = "%s"%self.t4cards.split('__')[1]
                if curr_pci == rule_pci:
                    card_html += '<option value="%s" selected="selected">%s</option>'%(self.t4cards.split('__')[1], self.t4cards.split('__')[0])
                else:
                    card_html += '<option value="%s">%s</option>'%(self.t4cards.split('__')[1], self.t4cards.split('__')[0])
	    
            card_html += '</select>'

            html += '<li>%s</li>'%card_html

            for k in comb_str_list:
                if k.lower().strip() == 'fcoe':
                    html += self.get_choice_editor(self.FilterListT4Obj.get(self.FilT4ListObj,i).fcoe.split('/')[0], '0#1', 'fcoe')
                elif k.lower().strip() == 'port':
                    port = self.FilterListT4Obj.get(self.FilT4ListObj,i).port.split('/')[0].strip()
                    logging.info('Port ashin:%s'%port)
                    if port == '00':
                        port = '0'
                    html += self.get_choice_editor(port, '0#1#2#3#4#5#6#7', 'port')
                elif k.lower().strip() == 'tos':
                    html += self.get_number_editor(self.FilterListT4Obj.get(self.FilT4ListObj,i).tos.split('/')[0], 'tos', '0#255', 1)
                elif k.lower().strip() == 'vnic_id':
                    #html += self.get_number_editor(self.FilterListT4Obj.get(self.FilT4ListObj,i).vnic_id.split('/')[0], 'vnic_id', '0#65355', 1)
                    #html += self.get_number_editor(self.FilterListT4Obj.get(self.FilT4ListObj,i).ovlan.split('/')[0], 'ovlan', '0#65355', 1)
                    html += self.get_number_editor(self.FilterListT4Obj.get(self.FilT4ListObj,i).pf.split('/')[0], 'pf', '0#255', 1)
                    html += self.get_number_editor(self.FilterListT4Obj.get(self.FilT4ListObj,i).vf.split('/')[0], 'vf', '0#255', 1)
                elif k.lower().strip() == 'protocol':
                    html += self.get_number_editor(self.FilterListT4Obj.get(self.FilT4ListObj,i).protocol.split('/')[0], 'protocol', '0#255', 1)
                elif k.lower().strip() == 'ethertype':
                    html += self.get_number_editor(self.FilterListT4Obj.get(self.FilT4ListObj,i).ethertype.split('/')[0], 'ethertype', '0#65355', 1)
                elif k.lower().strip() == 'macmatch':
                    html += self.get_number_editor(self.FilterListT4Obj.get(self.FilT4ListObj,i).macmatch.split('/')[0], 'macmatch', '0#511', 1)
                elif k.lower().strip() == 'mpshittype':
                    html += self.get_choice_editor(self.FilterListT4Obj.get(self.FilT4ListObj,i).mpshittype.split('/')[0], '0#1#2#3#4#5#6#7', 'mpshittype')
		    
                elif k.lower().strip() == 'fragmentation':
                    html += self.get_choice_editor(self.FilterListT4Obj.get(self.FilT4ListObj,i).fragmentation.split('/')[0], '0#1', 'fragmentation')
                elif k.lower().strip() == 'vlan':
                    html += self.get_number_editor(self.FilterListT4Obj.get(self.FilT4ListObj,i).vlan.split('/')[0], 'vlan', '0#65355', 1)
                    
            html += self.get_text_editor(self.FilterListT4Obj.get(self.FilT4ListObj,i).lport.split('/')[0], 'lport')                      
            html += self.get_text_editor(self.FilterListT4Obj.get(self.FilT4ListObj,i).fport.split('/')[0], 'fport')
            html += self.get_text_editor(self.FilterListT4Obj.get(self.FilT4ListObj,i).lip.split('/')[0], 'lip')
            html += self.get_text_editor(self.FilterListT4Obj.get(self.FilT4ListObj,i).fip.split('/')[0], 'fip')
            html += self.get_choice_editor(self.FilterListT4Obj.get(self.FilT4ListObj,i).t4action, 'drop#pass#switch', 't4action')
            #No need to display t4vlan, vlanval, prio, t4queue, tcbhash, eport, smac, dmac, rpttid
            html += self.get_choice_editor('', 'none#insert#rewrite', 't4vlan')      
            html += self.get_text_editor('', 't4vlanval')
            html += self.get_choice_editor(self.FilterListT4Obj.get(self.FilT4ListObj,i).hitCnts, '0#1', 'hitcnts')
            html += self.get_choice_editor('', '0#1', 't4prio')
            html += self.get_number_editor('', 't4queue', '0#1023', 1)
            html += self.get_choice_editor('', '0#1', 'tcbhash')
            html += self.get_choice_editor('', '0#1#2#3#4#5#6#7', 'eport')
            html += self.get_choice_editor(self.FilterListT4Obj.get(self.FilT4ListObj,i).type, 'ipv4#ipv6', 'type')
            html += self.get_text_editor('', 'smac')
            html += self.get_text_editor('', 'dmac')
            html += self.get_choice_editor('', '0#1', 'rpttid')
            html += self.get_readonly_editor(self.FilterListT4Obj.get(self.FilT4ListObj,i).actionCmd, 'action_cmd')
            
            html += '</ul>'
            html_list.append(html)
        
        self.data['width'] = width+( total_column * 125 ) + 400
        self.data['height'] = height + 32 + 18 + 400
        self.data['html'] = ''.join(html_list)
        return simplejson.dumps(self.data)
                      
    def get_choice_editor(self, curr_value, choices, propname):
        
        choices = choices.split('#')
        curr_value = str(curr_value).lower().strip()
        if curr_value == '' or curr_value not in choices:
            html = '<li><select class="value_null" title="%s"><option value="null">Choose</option>'%( propname )
        else:
            html = '<li><select class="value_%s" title="%s"><option value="null">Choose</option>'%( curr_value, propname )
        
        for i in choices:
            i = i.lower().strip()
            if curr_value == i:
                html += '<option value="%s" selected = "selected">%s</option>'%( curr_value, curr_value  )
            else:
                html += '<option value="%s" >%s</option>'%( i, i )
        
        html += '</select></li>'
        return html
    
    def get_readonly_editor(self, value, propname):
        if propname == 'action_cmd':
            style = "style='width:500px!important;overflow-y:scroll;'"
        else:
            style = ''
        return "<li class='%s' %s>%s</li>"%( propname, style, value )

    def get_number_editor(self, curr_value, propname, range, stepby):
        
        range_list = range.split('#')
        min = range_list[0]
        max = range_list[1]
        curr_value = str(curr_value).lower().strip()
        html = '<li>\
                    <div class="number_editor">\
                        <div class="fl_left input_wr">\
                            <input type="text" onkeyup="number_editor($(this),%s,%s,%s,\'validate\')" onblur="number_editor($(this),%s,%s,%s,\'blur\')" class="text " value="%s" title="%s" name="value_%s">\
                        </div>\
                        <div class="controls">\
                            <div class="up_arrow_wr">\
                                <img onclick="number_editor($(this),%s,%s,%s,\'inc\')" src="/images/black/up_arrow_hover.png">\
                            </div>\
                            <div class="down_arrow_wr">\
                                <img onclick="number_editor($(this),%s,%s,%s,\'dec\')" src="/images/black/down_arrow_hover.png">\
                            </div>\
                        </div>\
                    </div>\
                </li>'%( max, min, stepby, max, min, stepby, curr_value, propname, curr_value, max, min, stepby, max, min, stepby )
        return html

    def get_text_editor(self, curr_value, propname):
        return '<li><input type="text" value="%s" title="%s" name="value_%s" class="text" /></li>'%( curr_value, propname, curr_value )

    def save_filters(self, data):
        
        if data['action_type'] == 'add':
            mode = 9
        elif data['action_type'] == 'modify':
            mode = 10
        
        success = True
        
        #Defining here, to prevent error in the first loop
        temp_propname_tup = ()
        temp_value_tup = ()
        
        #Changing to tuple to prevent the order of the values.
        if type(data['propname']) == list:
            data['propname'] = tuple(data['propname']) 
            data['value'] = tuple(data['value'])
        if int(data['filter_count']) > 1:
            for i in range(int(data['filter_count'])):
                boostSetPropertyObj = KList()
                fid = UMKey('id', data['fid'][i])
                boostSetPropertyObj.append(fid)
                
                pci = UMKey('pci', data['pci'][i])
                boostSetPropertyObj.append(pci)
                
                comb_str = UMKey('comb', data['comb_str'].strip())
                boostSetPropertyObj.append(comb_str)
                
                #Need to remove the appended propname and values from the propname and value tuple
                #Since the values cant be removed from tuple directly, this method is followed
                #The type check is required, since single propname and value wont be tuple it will be a string
                #All this is required if multiple values are being passed by the user
                if type(data['propname']) == tuple:
                    temp_p_tup = ()
                    temp_list = list(data['propname'])
                    for k in temp_propname_tup:
                        if k in list(data['propname']):
                            #Pop is used to remove the values in the correct order, since if multiple same values are present then the remove() method may remove the values wrongly
                            #Hence index is extracted
                            idx = temp_list.index(k)
                            temp_list.pop(idx)
                    temp_p_tup = tuple(temp_list)
                        
                    temp_v_tup = ()
                    temp_list = list(data['value'])
                    for k in temp_value_tup:
                        if k in list(data['value']):
                            idx = temp_list.index(k)
                            temp_list.pop(idx)
                    temp_v_tup = tuple(temp_list)
                        
                    #If not checked, then will produce error during the initial loop, since the temp_p_tup and temp_v_tup will be empty
                    if len(temp_p_tup):         
                        data['propname'] = temp_p_tup
                        data['value'] = temp_v_tup
                    
                #Clearing all the values in temp_propname_tup and temp_value_tup
                temp_propname_tup = ()
                temp_value_tup = ()
                if int(data['properties_count_%s'%data['fid'][i]]) > 1:
                    for j in range(int(data['properties_count_%s'%data['fid'][i]])):
                        logging.info('Umkey Property T4 Filter: %s , Value : %s'%( data['propname'][j].strip(), data['value'][j].strip()))
                        tempkey = UMKey(data['propname'][j].strip(), data['value'][j].strip())
                        boostSetPropertyObj.append(tempkey)
                        #Appending values to the tuple
                        temp_propname_tup = temp_propname_tup + (data['propname'][j],)
                        temp_value_tup = temp_value_tup + (data['value'][j],)
                else:
                    #Only one value in the propname
                    if type(data['propname']) == str:
                        logging.info('Umkey Add Property T4 Filter: %s , Value : %s'%( data['propname'].strip(), data['value'].strip()))
                        tempkey = UMKey(data['propname'].strip(), data['value'].strip())
                        boostSetPropertyObj.append(tempkey)
                        temp_propname_tup = temp_propname_tup + (data['propname'],)
                        temp_value_tup = temp_value_tup + (data['value'],)
                    #There are multiple values in the propname, since this fid has only one property, ie  data['propname'][0]
                    elif type(data['propname']) == tuple:
                        logging.info('Umkey Add Property T4 Filter: %s , Value : %s'%( data['propname'][0].strip(), data['value'][0].strip()))
                        tempkey = UMKey(data['propname'][0].strip(), data['value'][0].strip())
                        boostSetPropertyObj.append(tempkey)
                        temp_propname_tup = temp_propname_tup + (data['propname'][0],)
                        temp_value_tup = temp_value_tup + (data['value'][0],)
                    
                logging.info('Modify/Add  Filter Set Properties Mode %s:  - Waiting for Boost - sid :%s , ip: %s, ostype : %s \
                     '%(mode, self.sid,self.ip, data['ostype']))
                status = boostSetPropertyObj.setProperty(self.sid, self.ip, mode, int(data['ostype']))
                logging.info('----------------Double1')
                #status = 0
                logging.info('Modify/Add Filter Set Properties Status : %s'%status)
                if status == -2:
                    return -2
                elif status != 0:
                    success = False
        else:
            boostSetPropertyObj = KList()
            logging.info('Umkey Add S T4 Filter id :%s :'%( data['fid'] ))
            fid = UMKey('id', data['fid'].strip())
            boostSetPropertyObj.append(fid)
            
            logging.info('Umkey T4 Filter for pci :%s :'%( data['pci'] ))
            pci = UMKey('pci', data['pci'].strip())
            boostSetPropertyObj.append(pci)
        
            logging.info('Umkey  T4 Filter , comb : %s'%( data['comb_str'].strip() ))
            comb_str = UMKey('comb', data['comb_str'].strip())
            boostSetPropertyObj.append(comb_str)
            
            if int(data['properties_count_%s'%data['fid']]) > 1:
                for i in range(int(data['properties_count_%s'%data['fid']])):
                    logging.info('Umkey  Property T4 Filter : %s , Value : %s'%( data['propname'][i], data['value'][i]))
                    tempkey = UMKey(data['propname'][i].strip(), data['value'][i].strip())
                    boostSetPropertyObj.append(tempkey)
            elif int(data['properties_count_%s'%data['fid']]) == 1:
                logging.info('Umkey Add Property T4 Filter: %s , Value : %s'%( data['propname'], data['value']))
                tempkey = UMKey(data['propname'].strip(), data['value'].strip())
                boostSetPropertyObj.append(tempkey)
                
            logging.info('Modify/Add Filter Set Properties Mode : %s - Waiting for Boost - sid :%s , ip: %s, ostype : %s \
                 '%(mode, self.sid, self.ip, data['ostype']))
            status = boostSetPropertyObj.setProperty(self.sid, self.ip, mode, int(data['ostype']))
            #status = 0
            logging.info('Modify/Add Filter Set Properties Status : %s'%status)
            if status == -2:
                return -2
            elif status != 0:
                success = False
            
            if status != 0:
                success = False
        
        if success:
            return 0
        else:
            return -1
        
    def get_filter_row(self, getdata):
        
        comb_str_list = getdata['comb_str'].replace(' ','').split(',')
        t4cards = getdata['t4_card']
        data = {}
        html_list = []
        width = 0
        total_column = 18
        html = ''
        
        #Head html
        html += ' <ul class="horizontal head_ul"><li class="fid"><h2>FilterID</h2></li>'
        
        #Generate card html
        html += '<li><h2>T4 Card</h2></li>'
        card_html = '<select title="pci" class="value_null" onchange="$(this).removeClass(\'error\')" ><option value="null">Choose</option>'
        if type(t4cards) == list:
            for i in t4cards:
                card_html += '<option value="%s">%s</option>'%(i.split('__')[1], i.split('__')[0])
        else:
            card_html += '<option value="%s">%s</option>'%(t4cards.split('__')[1], t4cards.split('__')[0])
        card_html += '</select>'
        width += 125
        
        j = 0
        total_len = len(comb_str_list)
        for k in comb_str_list:
            width += 125
            if j == total_len:
                html += '<li><h2 class="bg_none">%s</h2></li>'%k
            else:
                if k.strip() == 'vnic_id':
                    total_column = 19
                    html += '<li><h2>pf</h2></li>\
                             <li><h2>vf</h2></li>'
                else:
                    html += '<li><h2>%s</h2></li>'%k
            j += 1

        
        html += '<li><h2>lport</h2></li>\
                <li><h2>fport</h2></li>\
                <li><h2>lip</h2></li>\
                <li><h2>fip</h2></li>\
                <li><h2>action</h2></li>\
                <li><h2>t4vlan</h2></li>\
                <li><h2>vlanval</h2></li>\
                <li><h2>hitcnts</h2></li>\
                <li><h2>prio</h2></li>\
                <li><h2>t4queue</h2></li>\
                <li><h2>tcbhash</h2></li>\
                <li><h2>eport</h2></li>\
                <li><h2>type</h2></li>\
                <li><h2>smac</h2></li>\
                <li><h2>dmac</h2></li>\
                <li><h2>rpttid</h2></li>\
                <li class="action_cmd"><h2 class="bg_none">Action Command</h2></li>'
        
        html += '</ul>'
        
        unique_id = 'filtering_content__incend__%s_filtering_conf_tab_0'%( self.ip.replace('.','_') )
        html += '<ul class="horizontal content_tbl clear_left rules_ul fl_add" id="%s">'%unique_id
        
        html += '<li class="label fid">\
                    <input type="text" onkeyup="$(this).removeClass(\'error\');digit_validate($(this))" class="xsml text fid_input" value="">\
                  </li>'
                  
        html += '<li>%s</li>'%card_html
        
        for k in comb_str_list:
            
            if k.lower().strip() == 'fcoe':
                html += self.get_choice_editor('', '0#1', 'fcoe')
            elif k.lower().strip() == 'port':
                html += self.get_choice_editor('', '0#1#2#3#4#5#6#7', 'port')
            elif k.lower().strip() == 'vlan':
                html += self.get_number_editor('', 'vlan', '0#65355', 1)
            elif k.lower().strip() == 'ovlan':
                html += self.get_number_editor('', 'ovlan', '0#65355', 1)
            elif k.lower().strip() == 'vnic_id':
                html += self.get_number_editor('', 'pf', '0#255', 1)
                html += self.get_number_editor('', 'vf', '0#255', 1)
            elif k.lower().strip() == 'tos':
                html += self.get_number_editor('', 'tos', '0#255', 1)
            elif k.lower().strip() == 'protocol':
                html += self.get_number_editor('', 'protocol', '0#255', 1)
            elif k.lower().strip() == 'ethertype':
                html += self.get_number_editor('', 'ethertype', '0#65355', 1)
            elif k.lower().strip() == 'macmatch':
                html += self.get_number_editor('', 'macmatch', '0#511', 1)
            elif k.lower().strip() == 'mpshittype':
                html += self.get_choice_editor('', '0#1#2#3#4#5#6#7', 'mpshittype')
            elif k.lower().strip() == 'fragmentation':
                html += self.get_choice_editor('', '0#1', 'fragmentation')
                
        html += self.get_text_editor('', 'lport')
        html += self.get_text_editor('', 'fport')
        html += self.get_text_editor('', 'lip')
        html += self.get_text_editor('', 'fip')
        html += self.get_choice_editor('', 'drop#pass#switch', 't4action')
        html += self.get_choice_editor('', 'none#insert#rewrite', 't4vlan')      
        html += self.get_text_editor('', 't4vlanval')
        html += self.get_choice_editor('', '0#1', 'hitcnts')
        html += self.get_choice_editor('', '0#1', 't4prio')
        html += self.get_number_editor('', 't4queue', '0#1023', 1)
        html += self.get_choice_editor('', '0#1', 'tcbhash')
        html += self.get_choice_editor('', '0#1#2#3#4#5#6#7', 'eport')
        html += self.get_choice_editor('', 'ipv4#ipv6', 'type')
        html += self.get_text_editor('', 'smac')
        html += self.get_text_editor('', 'dmac')
        html += self.get_choice_editor('', '0#1', 'rpttid')
        html += self.get_readonly_editor('', 'action_cmd')
        html += '</ul>'
        html_list.append(html)
        
        data['width'] = width+( total_column * 125 )+ 400
        data['html'] = ''.join(html_list)
        return simplejson.dumps(data)
    
    def delete_filter(self, comb_str, fid):
        
        fid = fid[1:len(fid)-1]
        fid_list = fid.split(',,')
        
        for fid_str in fid_list:
            id = fid_str.split('__')[0]
            pci = fid_str.split('__')[1]
            filterT4Summary_obj = FilterT4Summary()
            logging.info('T4 Filtering - DeleteFilterT4 :waiting for response from UMboost sid : %s , IP : %s, comb_str : %s, fid : %s, pci : %s'%(self.sid, self.ip, comb_str, id, pci))
            status = filterT4Summary_obj.DeleteFilterT4(self.sid, self.ip, pci, id, comb_str)
            #status = 0
            logging.info('T4 Filtering - DeleteFilterT4: result %s'%(status))
        
            if status == -2:
                return status
        
        return 0
