from UmBoostLib import SysSummary, DrvInstallResList, DriverResult

import logging, time
import settings
logging = settings.get_logger()

class DriverInstall:
    
    def __init__(self, session_id ,ip ):
        self.session_id = session_id
        self.ip = ip
        self.boostDriverInstallObj = SysSummary()

    def install_driver(self,data):
        
        if data['drType'].strip() == 'um':
            data['cardtype'] = '2'
        
        logging.info('Driver Install:  waiting for response from UMboost sid : %s , IP : %s , cardType : %s, drType : %s, drpath : %s, iscsipath : %s, ofedpath : %s, ofedpkg : %s, ostype : %s, conftype : %s\
                '%(self.session_id, self.ip, data['cardtype'], data['drType'], data['drpath'], data['iscsipath'], data['ofedpath'], data['ofedpkg'], data['ostype'], data['conftype'] ))
        status = self.boostDriverInstallObj.DriverInstallation(self.session_id, self.ip, int(data['cardtype']), data['drType'], data['drpath'], data['iscsipath'], data['ofedpath'], data['ofedpkg'], data['conftype'], int(data['ostype']))
        #status = self.boostDriverInstallObj.DriverInstallation(self.session_id, self.ip, int(data['cardtype']), "all", data['drpath'], data['iscsipath'], data['ofedpath'], data['ofedpkg'], data['conftype'], int(data['ostype']))
        
        if status == 0:
            
            '''if data['ostype'] == '4':  
                return 0'''
                
            if data['drType'].strip() == 'um':
                return 0
            
            do_poll = True
            while do_poll:
                
                if data['ostype'] == '1':    
                    time.sleep(15)
                else:
                    time.sleep(8)
                
                logging.info('Driver Poll:  waiting for response from UMboost sid : %s , IP : %s , drType : %s\
                '%(self.session_id, self.ip, data['drType'] ))
                resultAgmtobj = DrvInstallResList()
                resultMainObj = DriverResult()
                status = self.boostDriverInstallObj.pollDriverInstallResult(self.session_id, self.ip, data['drType'], resultAgmtobj)
                #Poll
                if status == 100 or status == 101:
                    do_poll = True
                #Failed
                elif status == 4:
                    status = 4
                    do_poll = False
                elif status > 0:
                    status = 50
                    do_poll = False
                elif status == 0:
                    #Check
                    logging.info('------------len(resultAgmtobj: %s'%len(resultAgmtobj))
                    if(len(resultAgmtobj) > 0):
                        success_flag = True
                        loop_flag = False
                        for i in range(0, len(resultAgmtobj)):
                           temp_obj = resultMainObj.get(resultAgmtobj, i)
                           result = temp_obj.result
                           if result == 7 or result == 80:
                               result = 0
                           
                           logging.info('------------Result %s : %s'%(i, result))
                           logging.info('------------name %s : %s'%(i, temp_obj.name))
                           logging.info('------------version %s : %s'%(i, temp_obj.version))
                           logging.info('------------ostype %s : %s'%(i, temp_obj.osType))
                           #driver is already installed (XEN) 
                           if result == 4:
				return result
                           #Driver installation still in progress
				
                           elif result == 100 or result == 101:
                               do_poll = True
                               loop_flag = True
                               break 
                           #One of the driver has failed
                           elif result > 0:
                               success_flag = False
                        
                        #When all the drivers has finished
                        if not loop_flag:
                            do_poll = False
                            #when all the drivers has returned success
                            if success_flag:
                                status = 0
                            #If either one among them failed
                            else:
                                status = 1
                    #Failed
                    else:
                        status = 50
                        do_poll = False
            
        if status == -2 or status == 50 or status == 0 or status == 4:
            return status
        else:
            return -1
