from UmBoostLib import SysSummary as localSummary
from xml.dom.minidom import Document
#import simplejson

import settings
logging = settings.get_logger()


## Instance of the stationLogin
class SysSummary:
	def __init__(self,sessionId,sysIP):
		self.sessionId = sessionId 
		self.sysIP = sysIP
		self.login = localSummary()

	def getsyssummary(self, ret_type):
		
		logging.info('system summary , Waiting to get response from umboost; Ags Passed: sid: %s ; Ip : %s'%(self.sessionId, self.sysIP))
		status = self.login.GetSystemSummary(self.sessionId, self.sysIP)
		logging.info('system summary status: " %s "' %status)
		
		if status == -2:
		    return -2
		elif status != 0:
			return -1
		
		if (ret_type == "dict"):
			logging.info('Fetching system summary data from umboost..')
			sys_summ = {}
			sys_summ['cards_count'] = self.login.noOfCards
			sys_summ['hostname'] = self.login.hostName
			sys_summ['is_licensed'] = self.login.IsLicensed
			sys_summ['OsName'] = self.login.OsName
			logging.info('system summary result: " %s "' %sys_summ)
			return sys_summ
		else:
			logging.info('Waiting for system summary xml using boost method generating xml..')
			ret_val = self.generateXML(self.login)
			logging.info('system summary result: " %s "' %ret_val)
		return ret_val
	
	
	def get_card_info_file(self,index,username):
		logging.info('system card info file , Waiting to get response from umboost; Ags Passed: sid: %s ; Ip : %s , Index : %s , username : %s'%(self.sessionId, self.sysIP,index,username))
		status = self.login.GetSystemInfoFile( self.sessionId, self.sysIP, int(index), username)
		logging.info('system card info file Result : %s'%(status))
		
		if status == 0:
			return status
		elif status == -2:
		    return -2
		else:
		    return -1
		
	def upload_licensekey(self,username,filename):
		
		logging.info('Upload license Key, Waiting to get response from umboost; Ags Passed: sid: %s ; Ip : %s , username : %s , Filename : %s '%(self.sessionId, self.sysIP,username,filename))
		status = self.login.UploadLicenseKeyFile( self.sessionId, self.sysIP,  filename , username )
		logging.info('Upload license Key file Result : %s'%(status))
		
		if status == 0:
			self.login = localSummary()
			status = self.login.GetSystemSummary(self.sessionId, self.sysIP)
			if status == 0:
				logging.info('System IsLicensed : %s'%(self.login.IsLicensed))
				if self.login.IsLicensed == 1:
					status = 0
				else:
					status = -1
			elif status == -2:
				status = -2
			else:
				status = -1
		elif status == -2:
			status = -2
		else:
			status = -1
			
		# Create the minidom document
		doc = Document()
		
		uploadlickey = doc.createElement("uploadlickey")
		doc.appendChild(uploadlickey)
		
		status_node = doc.createElement("status")
		uploadlickey.appendChild(status_node)
		
		status_val = doc.createTextNode('%s'%status)
		status_node.appendChild(status_val)
		
		return doc.toprettyxml()
		
	'''def generateJson(self):
		data = {}
		data['hostname'] = sysinfo.hostName
		data['ip_port'] = '%s:%s'%(sysinfo.Ip,sysinfo.Port)
		data['cards_count'] = sysinfo.noOfCards
		data['license'] = sysinfo.IsLicensed
		data['os'] = sysinfo.OsName
		data['platform'] = sysinfo.platForm
		return simplejson.dumps(data)'''
		
	
	def generateXML(self,sysinfo):
		
		# Create the minidom document
		doc = Document()
		
		# Create the <syssummary> base element
		sys_summary = doc.createElement("syssummary")
		doc.appendChild(sys_summary)
		
		# Create the main <hostname> element
		hostname = doc.createElement("hostname")
		sys_summary.appendChild(hostname)
		
		# Assign <hostname> element with hostname
		hostName_val = doc.createTextNode(sysinfo.hostName)
		hostname.appendChild(hostName_val)
		
		ip_port = doc.createElement("ipport")
		sys_summary.appendChild(ip_port)
		
		# Assign <ipport> element with Ip address & port
		ip_port_val = doc.createTextNode('%s:%s'%(sysinfo.Ip,sysinfo.Port))
		ip_port.appendChild(ip_port_val)
		
		# Create the main <cardscount> element
		cardscount = doc.createElement("cardscount")
		sys_summary.appendChild(cardscount)
		
		# Assign <cardscount> element with no. of cards
		cardscount_val = doc.createTextNode("%s"%sysinfo.noOfCards)
		cardscount.appendChild(cardscount_val)
        
        # Create the main <islicensed> element
		islicensed = doc.createElement("islicensed")
		sys_summary.appendChild(islicensed)
		
		# Assign <islicensed> element with value
		islicensed_val = doc.createTextNode("%s"%sysinfo.IsLicensed)
		islicensed.appendChild(islicensed_val)
		
        # Create the main <islicensed> element
		os = doc.createElement("os")
		sys_summary.appendChild(os)
		
		# Assign <islicensed> element with value
		os_value = doc.createTextNode("%s"%sysinfo.OsName)
		os.appendChild(os_value)
		
		# Create the main <platform> element
		platform = doc.createElement("platform")
		sys_summary.appendChild(platform)
		
		# Assign <platForm> element with value
		platform_value = doc.createTextNode("%s"%sysinfo.platForm)
		platform.appendChild(platform_value)
        
		return doc.toprettyxml()    
