from UmBoostLib import FavouriteList, UMFavouriteList, EmailAlert
from UmBoostLib import FavouriteList, UMFavouriteList
import logging

import simplejson
import settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)

class subscribe:
    
    def __init__(self, sid):
        self.sid = sid
       
    def get_bookmarks(self, type):
        self.type = type
        self.bookmark = FavouriteList()
        self.bookmarks = UMFavouriteList()
        logging.info('Subrcibe - BookmarkList - Waiting for Boost - sid :%s'%self.sid)
        status = self.bookmarks.getFavouriteUmServers(self.bookmark,self.sid)
        logging.info('Subrcibe - BookmarkList Result, Status : %s'%status)
        
        if status == -2:
            return -2
        elif not len(self.bookmark):
            return 1 
        elif status == 0:
            return self.generate_bookmarks_html()
        else:
            return -1
        
    def getItems(self):
        for i in range(0,len(self.bookmark)):
            yield self.bookmarks.getitem(self.bookmark,i)

    def generate_bookmarks_html(self):
        
        if self.type == 'desktop':
            html = '<li class="%s umserver_li %s" onclick = "sb_select_bk($(this))" ><span class="ip">%s </span>\
                    &nbsp;&nbsp;-&nbsp;&nbsp;<span class="hostname">%s</span>\
                    </li>'
        
            html_list = [ html%( i.OsName.lower() , i.hostip.replace('.','_'), i.hostip , i.hostName ) for i in self.getItems()]
        else:
            head = '<select multiple="multiple" onchange="server_change($(this))" placeholder="Bookmarks" data-native-menu="false">%s</select>'
            html = '<option value="%s">%s</option>'
            html_list = [ html%( i.hostip , i.hostName ) for i in self.getItems()]
    
        html = ''.join(html_list)
        if self.type == 'mobile':
            return head%(html)
        else:
            return html
    
    def set_alert(self, data):
        alert_boost_obj = EmailAlert()
        logging.info('Subrcibe - Set Waiting for Boost - sid :%s, username : %s, recipients : %s, ServerList : %s, from : %s, mailserver : %s,\
                                                alertstatus : %s, smtpport : %s, netDevAlert : 1'
                                                %(self.sid, data['username'], data['recipients'], data['umserverlist'],
                                                  data['from'], data['mailserver'], data['alertstatus'], data['smtpport']))
        status = alert_boost_obj.SetEmailAlert(self.sid, '', data['username'], data['recipients'], data['umserverlist'], data['from'], data['mailserver'], int(data['alertstatus']),
                                              int(data['smtpport']), 1)
        #status = 0
        logging.info('Subrcibe - Set Status : %s'%status)
        
        if status == 0 or status == -2:
            return status
        else :
            return -1
    
    def get_alert(self, username):
        self.alert_boost_obj = EmailAlert()
        logging.info('Subrcibe - GET Waiting for Boost - sid :%s, username : %s'%(self.sid, username))
        status = self.alert_boost_obj.GetEmailAlert(self.sid, username)
        logging.info('Subrcibe - GET Status : %s'%status)
        
        if status == -2 or status == 1:
            return status
        elif status == 0:
            return self.get_alert_data()
        else:
            return -1
    
    def get_alert_data(self):
        data = {}
        data['alertstatus'] = self.alert_boost_obj.alertStatus
        data['system_list'] = self.alert_boost_obj.UMServerList
        data['recipients'] = self.alert_boost_obj.recipients
        data['from'] =  self.alert_boost_obj.mailfrom
        data['mailServer'] =  self.alert_boost_obj.mailServer
        data['port'] =  self.alert_boost_obj.SMTPPort
        
        '''data['alertstatus'] =  1
        data['system_list'] =  '10.193.184.72,10.193.184.73'
        data['recipients'] =  'as@a.com,b@v.com'
        data['from'] =  'ashin@a.com'
        data['port'] =  35'''
        return simplejson.dumps(data)
        