## Handles the session related details.
class Session:
    ## Constructor for the class session
    ##@param req
    # The request object.
    def __init__(self,req):
        self.req = req

    ## Gets the generated session Identifier.
    ##@return
    # Returns the session identifier.
    def getSessionId(self):
        ip = self.req.connection.remote_addr[0]
        port = str(self.req.connection.remote_addr[1])
        return self.generateSessionId(ip,port)

    ## Generates the session Identifier.
    ##@param ip
    # The IP of the client.
    ##@param port
    # The port on the client.
    ##@return
    # Returns the session identifier.
    def generateSessionId(self,ip,port):
        import time
        timed = time.strftime("%d%m%y%H%M%S")
        temp = ip+port+timed
        from sha import sha as hasher
        hashMe = hasher()
        hashMe.update(temp)
        return str(hashMe.hexdigest())
