from UmBoostLib import ServCapabilites as Capabalities
from xml.dom.minidom import Document as XML
import string, settings
logging = settings.get_logger()

## The instance of the class UmConnects.
class UmServCapabilities:
	## Constructor for the class ServCapabilities 
	def __init__(self, sessionId, hostIP):
		self.sessionId = sessionId
		self.hostIP = hostIP
 		self.ServCap = Capabalities()

	# ret_type can be text or xml	
	def getCapabilities(self, ret_type):
		
		logging.info('Waiting for capapbility connect.. sid : %s , ip : %s',(self.sessionId, self.hostIP))
		status = self.ServCap.GetServCapability(self.sessionId, self.hostIP)
		logging.info('Waiting for capapbility connect result:%s'%status)
		
		if status == -2:
		    return -2
		elif status != 0:
			return -1
		
		if (ret_type == "text"):
			logging.info('Waiting for capapbilities from umboost..')
			ret_val = self.ServCap.capabilities.lower()
			logging.info('Final result of capabilities : " %s "' %ret_val)
		else:
			ret_val = self.generateXML(status, self.ServCap)
		return ret_val
	
	def generateXML(self, status, ServCapabalities):
		list = string.split(ServCapabalities.capabilities, ',')
		strn = '<?xml version="1.0" encoding="UTF-8"?>'
		strn += "<capabilities sID=\""
		strn += self.sessionId
		strn += "\"><status>"
		strn += str(status)
		strn += "</status>"
		## parse caps and generate XML
		for i in (list):
			strn += "<"
			strn += string.lower(list[i])
			strn += ">1"
			strn += "</"
			strn += string.lower(list[i])
			strn += ">"
		strn += "</capabilities>"
		return strn
