from UmBoostLib import PortInfo, IntfList, InterfaceList
import settings
logging = settings.get_logger()

class PortsSummary:
  
    def __init__(self,sessionId,hostIP,PciBusLoc,index, type ,ostype):
    	self.sessionId = sessionId
    	self.hostIP = hostIP
        self.PciBusLoc = PciBusLoc
        self.index = index
        self.type = type
        self.ostype = ostype
    	self.boostPortObj = PortInfo()

    def getPortsSummary(self):
    	
        logging.info('Port Summary:  waiting for response from UMboost sid : %s , IP : %s , PCILOC : %s , Index : %s, ostype : %s'%(self.sessionId,self.hostIP,self.PciBusLoc,self.index,self.ostype))
        status = self.boostPortObj.GetPortInfo(self.sessionId, self.hostIP, self.PciBusLoc, self.index, int(self.ostype))
        logging.info('Port Summary Status : %s '%status )
    	
        if status == 0:
            return self.generateHTML()
        elif status == -2:
            return -2
        else:
            return -1
        
    def generateHTML(self):
        
        html_list = []
        
        if self.type == 'desktop':
        
            html_list.append('<ul class="horizontal content_tbl clear from_server">\
                        <li class="label">Port Name</li><li class="bg_none port_ifname" >%s&nbsp;</li></ul>'%self.boostPortObj.ifaceName)
                        
            link_state = self.getLinkState(self.boostPortObj.ifaceName)
            s_class = ''
            if link_state == "Link up":
                s_class = 'green_f'
            elif  link_state == "Link down":
                s_class = 'red_f'
            
            html_list.append('<ul class="horizontal content_tbl clear from_server">\
                        <li class="label">Link</li><li class="bg_none %s" >%s&nbsp;</li></ul>'%(s_class, link_state))
                        
            html_list.append('<ul class="horizontal content_tbl clear from_server solaris os_4">\
                        <li class="label">Port Supported</li><li class="bg_none" >%s&nbsp;</li></ul>'%self.boostPortObj.portSupported)
                        
            html_list.append('<ul class="horizontal content_tbl clear from_server solaris os_4">\
                        <li class="label">Port Type</li><li class="bg_none" >%s&nbsp;</li></ul>'%self.boostPortObj.portType)
                        
            '''html_list.append('<ul class="horizontal content_tbl clear from_server solaris">\
                        <li class="label">wakeonLAN</li><li class="bg_none" >%s&nbsp;</li></ul>'%self.boostPortObj.wakeonLAN)
                        
            html_list.append('<ul class="horizontal content_tbl clear from_server solaris">\
                        <li class="label">wakeonLANSupport</li><li class="bg_none" >%s&nbsp;</li></ul>'%self.boostPortObj.wakeonLANSupport)'''
                        
            html_list.append('<ul class="horizontal content_tbl clear from_server solaris os_4">\
                        <li class="label">Supported link modes</li><li class="bg_none" >%s&nbsp;</li></ul>'%self.boostPortObj.linkMode)
                        
            html_list.append('<ul class="horizontal content_tbl clear from_server solaris os_4">\
                        <li class="label">Advertised link modes</li><li class="bg_none" >%s&nbsp;</li></ul>'%self.boostPortObj.advtLinkMode)
                        
            html_list.append('<ul class="horizontal content_tbl clear from_server solaris os_4">\
                        <li class="label">PauseautoNeg</li><li class="bg_none" >%s&nbsp;</li></ul>'%self.boostPortObj.PauseautoNeg)
                        
            html_list.append('<ul class="horizontal content_tbl clear from_server solaris os_4">\
                        <li class="label">Transceiver</li><li class="bg_none" >%s&nbsp;</li></ul>'%self.boostPortObj.transceiver)
            
            html_list.append('<ul class="horizontal content_tbl clear from_server as_hide show_os_2 show_os_5">\
                        <li class="label">Advertised Auto-negotiation</li><li class="bg_none" >%s&nbsp;</li></ul>'%self.boostPortObj.autoneg_advertise)
            
            html_list.append('<ul class="horizontal content_tbl clear from_server as_hide show_os_2 show_os_5">\
                        <li class="label">Ring_max_rx</li><li class="bg_none" >%s&nbsp;</li></ul>'%self.boostPortObj.ring_max_rx)
            
            html_list.append('<ul class="horizontal content_tbl clear from_server as_hide show_os_2 show_os_5">\
                        <li class="label">Ring_max_rx_mini</li><li class="bg_none" >%s&nbsp;</li></ul>'%self.boostPortObj.ring_max_rx_mini)
            
            html_list.append('<ul class="horizontal content_tbl clear from_server as_hide show_os_2 show_os_5">\
                        <li class="label">Ring_max_rx_jumbo</li><li class="bg_none" >%s&nbsp;</li></ul>'%self.boostPortObj.ring_max_rx_jumbo)
            
            html_list.append('<ul class="horizontal content_tbl clear from_server as_hide show_os_2 show_os_5">\
                        <li class="label">Ring_max_tx</li><li class="bg_none" >%s&nbsp;</li></ul>'%self.boostPortObj.ring_max_tx)
            
            html_list.append('<ul class="horizontal content_tbl clear from_server as_hide show_os_2 show_os_5 show_os_8 os_4">\
                        <li class="label">Supports auto-negotiation</li><li class="bg_none" >%s&nbsp;</li></ul>'%self.boostPortObj.autoneg_support)
            
            html_list.append('<ul class="horizontal content_tbl clear from_server as_hide show_os_2 show_os_5 show_os_8 os_4">\
                        <li class="label">Auto-negotiation</li><li class="bg_none" >%s&nbsp;</li></ul>'%self.boostPortObj.link_autoneg)
            
            html_list.append('<ul class="horizontal content_tbl clear from_server as_hide show_os_2 show_os_5 show_os_8 os_4" >\
                        <li class="label">Advertised auto-negotiation</li><li class="bg_none" >%s&nbsp;</li></ul>'%self.boostPortObj.autoneg_advertise)
            
        else:
            
            html_list.append('<div class="ui-grid-a heading" data-theme="b" >\
                                <div class="ui-block-a ui-bar-b center">Property</div>\
                                <div class="ui-block-b ui-bar-b center">Value</div>\
                            </div>')
          
            html_list.append('<div class=" ui-grid-a grid">\
                        <div class="ui-block-a">Device Name</div> <div class="ui-block-b  port_ifname" >%s&nbsp;</div></div>'%self.boostPortObj.ifaceName)
                        
            html_list.append('<div class=" ui-grid-a grid">\
                        <div class="ui-block-a">Link</div> <div class="ui-block-b  port_ifname" >%s&nbsp;</div></div>'%self.boostPortObj.link)
            
            html_list.append('<div class=" ui-grid-a grid solaris os_4">\
                        <div class="ui-block-a">Port Supported</div> <div class="ui-block-b  port_ifname" >%s&nbsp;</div></div>'%self.boostPortObj.portSupported)
            
            html_list.append('<div class=" ui-grid-a grid solaris os_4">\
                        <div class="ui-block-a">PortType</div> <div class="ui-block-b  port_ifname" >%s&nbsp;</div></div>'%self.boostPortObj.portType)
            
            html_list.append('<div class=" ui-grid-a grid solaris os_4">\
                        <div class="ui-block-a">wakeonLAN</div> <div class="ui-block-b  port_ifname" >%s&nbsp;</div></div>'%self.boostPortObj.wakeonLAN)
                        
            html_list.append('<div class=" ui-grid-a grid solaris os_4">\
                        <div class="ui-block-a">wakeonLANSupport</div> <div class="ui-block-b  port_ifname" >%s&nbsp;</div></div>'%self.boostPortObj.wakeonLANSupport)
                        
            html_list.append('<div class=" ui-grid-a grid solaris os_4">\
                        <div class="ui-block-a">advtLinkMode</div> <div class="ui-block-b  port_ifname" >%s&nbsp;</div></div>'%self.boostPortObj.advtLinkMode)             
            
            html_list.append('<div class=" ui-grid-a grid solaris os_4">\
                        <div class="ui-block-a">PauseautoNeg</div> <div class="ui-block-b  port_ifname" >%s&nbsp;</div></div>'%self.boostPortObj.PauseautoNeg)  
            
            html_list.append('<div class=" ui-grid-a grid solaris os_4">\
                        <div class="ui-block-a">Transceiver</div> <div class="ui-block-b  port_ifname" >%s&nbsp;</div></div>'%self.boostPortObj.transceiver)  
            
            html_list.append('<div class=" ui-grid-a grid as_hide show_os_2 show_os_4">\
                         <div class="ui-block-a">Advertised Auto-negotiation</div> <div class="ui-block-b  port_ifname" >%s&nbsp;</div></div>'%self.boostPortObj.autoneg_advertise)
            
            html_list.append('<div class=" ui-grid-a grid as_hide show_os_2 show_os_4">\
                        <div class="ui-block-a">Ring_max_rx</div> <div class="ui-block-b  port_ifname" >%s&nbsp;</div></div>'%self.boostPortObj.ring_max_rx)
            
            html_list.append('<div class="ui-grid-a grid as_hide show_os_2 show_os_4">\
                        <div class="ui-block-a">Ring_max_rx_mini</div> <div class="ui-block-b  port_ifname" >%s&nbsp;</div></div>'%self.boostPortObj.ring_max_rx_mini)
            
            html_list.append('<div class=" ui-grid-a grid as_hide show_os_2 show_os_4">\
                        <div class="ui-block-a">Ring_max_rx_jumbo</div> <div class="ui-block-b  port_ifname" >%s&nbsp;</div></div>'%self.boostPortObj.ring_max_rx_jumbo)
            
            html_list.append('<div class=" ui-grid-a grid as_hide show_os_2 show_os_4">\
                        <div class="ui-block-a">Ring_max_tx</div> <div class="ui-block-b  port_ifname" >%s&nbsp;</div></div>'%self.boostPortObj.ring_max_tx)
            
        whole_html = ''.join(html_list)
    
        return whole_html


    def get_port_ifname(self):
        
        logging.info('Port Ifname:  waiting for response from UMboost sid : %s , IP : %s , PCILOC : %s , Index : %s, ostype : %s'%(self.sessionId,self.hostIP,self.PciBusLoc,self.index, self.ostype))
        status = self.boostPortObj.GetPortInfo(self.sessionId,self.hostIP,self.PciBusLoc,self.index, int(self.ostype))
        logging.info('Port Ifname Status : %s '%status )
        
        if status == 0:
            return self.boostPortObj.ifaceName
        elif status == -2:
            return -2
        else:
            return -1
        
        
    def getLinkState(self, ifname):

        logging.info('Port Summary : Get link state , Call : getNetworkInformation , Agms :  sid : %s , IP : %s'%(self.sessionId, self.hostIP))
        self.boostIntfListObj = IntfList()
        self.boostInterfaceList = InterfaceList()
        inf_status = self.boostInterfaceList.getNetworkInformation(self.boostIntfListObj, self.sessionId, self.hostIP)
        logging.info('Port Summary : Get link state , Call : getNetworkInformation  status: %s'%inf_status)
        
        for i in range(0,len(self.boostIntfListObj)):
            if ifname.strip() == self.boostInterfaceList.get(self.boostIntfListObj, i).FriendlyName: 
                linkstate = self.boostInterfaceList.get(self.boostIntfListObj, i).LinkState
                if linkstate:
                    return "Link up"
                else:
                    return "Link down"
        
        return "Unknown"
        
        