from UmBoostLib import UmProperties, PList, PropsList 
from UmBoostLib import KList
import UmBoostLib 
import simplejson
import settings
import string
logging = settings.get_logger()

class PortSettings:
    
    def __init__( self, sid, ip, type ):
        self.sid = sid
        self.ip = ip
        self.type = type

    def get_port_settings_details(self,kwargs):
        
        logging.info('Port Settings - Get Port Properties:  waiting for response from UMboost SID : %s , IP : %s , PCILOC : %s, pInstance: %s, cardType : %s, phy_idx : %s, connector : %s, portCount : %s, ostype : %s\
                     '%(self.sid, self.ip, kwargs['pciloc'], kwargs['port_index'], kwargs['cardtype'], kwargs['phy_idx'], kwargs['connector'], kwargs['portcount'], kwargs['ostype']))
        self.boostPlistObj = PList()
        self.boostPropslistObj = PropsList()
        status = self.boostPropslistObj.getPortProperties(self.boostPlistObj, self.sid, self.ip, kwargs['pciloc'], int(kwargs['port_index']), kwargs['cardtype'], int(kwargs['phy_idx']), kwargs['connector'], int(kwargs['portcount']), int(kwargs['ostype']))
        logging.info('Port Settings : Get Port Properties status: %s'%status)
        
        if status == 0:
            return simplejson.dumps(self.generate_html())
        elif status == -2:
            return -2
        else:
            return -1

    def get_obj(self):
        for i in range(0,len(self.boostPlistObj)):
            yield self.boostPropslistObj.get(self.boostPlistObj,i)

    '''
    CELL TYPES
    NONE = 0,
    TEXT_EDITOR=1,
    BOOL_EDITOR=2,
    NUMBER_EDITOR=3,
    CHOICE_EDITOR=4,
    RANGE_EDITOR=5
    '''
    def generate_html(self):
        
        if self.type == 'desktop':
            head_html = '<ul class="horizontal head_ul">\
                         <li class="desc"><h2>Description</h2></li>\
                         <li class="value"><h2 class="bg_none" >Value</h2></li>\
                         </ul>'
        else:
            head_html = '<div class="ui-grid-a heading" data-theme="b" >\
                        <div class="ui-block-a ui-bar-b center desc">Description</div>\
                        <div class="ui-block-b ui-bar-b center value">Value</div>\
                        </div>'
        html_list = []
        height = 0
        for i in self.get_obj():
            
            if self.type == 'desktop':
                html_list.append('<ul class="horizontal content_tbl clear from_server">\
                            <li class="desc">%s</li>'%i.propDesc)
            else:
                html_list.append('<div class=" ui-grid-a grid from_server">\
                    <div class="ui-block-a iter desc">%s</div>'%i.propDesc)
            if not i.isEditable:
                value = i.value
                if int(i.cellType) == 2:
                    if i.value == 1 or i.value.strip() == 'Yes' or i.value.strip() == '1':
                        value = 'Yes'
                    else:
                        value = 'No'

		if int(i.cellType) == 4:
                    choices = i.range.split('#')
                    index = 0
                    for j in choices:
                        if int(i.value) == index:
				value = j
                        index += 1
                
                if self.type == 'desktop':    
                    html_list.append('<li class="bg_none value" >%s</li></ul>'%value)
                else:
                    html_list.append('<div class="ui-block-b value iter" >%s</div></div>'%value)
                
                height += 33

		
            else:
                height += 33
                if self.type == 'desktop': 
                    html_list.append('<li class="bg_none value" >')
                else:
                    html_list.append('<div class="ui-block-b value iter" >')

                if int(i.cellType) == 1:
                    html_list.append('<input autocomplete="off" type = "text" class="text text_editor" name="value_%s" title="%s" value="%s" >'%(i.value,i.propName,i.value))
                elif int(i.cellType) == 2:
                    html_list.append('<select autocomplete="off" class="value_%s" title="%s" >'%(i.value,i.propName))
                    if i.value == 1 or i.value.strip() == 'Yes' or i.value.strip() == '1':
                        html_list.append('<option value="1" selected="selected">Yes</option>\
                                     <option value="0">No</option></select>')
                    else:
                        html_list.append('<option value="1" >Yes</option>\
                                     <option value="0" selected="selected">No</option></select>')
                elif int(i.cellType) == 3:
                    
                    if self.type == 'desktop': 
                        html_list.append('<div class="number_editor">\
                                            <div class="fl_left input_wr">')
                        
                        min = i.range.split('#')[0]
                        max = i.range.split('#')[1]
                        inc = i.stepby
    
                        html_list.append('<input type = "text" name="value_%s" title="%s" value="%s" class="text xsml" onblur="number_editor($(this),%s,%s,%s,\'blur\')" onkeyup="number_editor($(this),%s,%s,%s,\'validate\')"  />\
                                        </div>'%(i.value,i.propName,i.value,max,min,inc,max,min,inc))
                        html_list.append('<div class="controls"><div class="up_arrow_wr">\
                                        <img src="/images/black/up_arrow_hover.png" onclick = "number_editor($(this),%s,%s,%s,\'inc\')"  />\
                                        </div><div class= "down_arrow_wr">\
                                        <img src="/images/black/down_arrow_hover.png" onclick = "number_editor($(this),%s,%s,%s,\'dec\')" />\
                                        </div></div></div>'%(max,min,inc,max,min,inc))
                    else:
                        min = i.range.split('#')[0]
                        max = i.range.split('#')[1]
                        html_list.append('<input autocomplete="off" type = "text" class="text text_editor" name="value_%s" title="%s" value="%s"\
                                         onchange="number_editor($(this), %s, %s)" >'%(i.value,i.propName,i.value, min, max))
                    
                elif int(i.cellType) == 4:
                    html_list.append('<select autocomplete="off" class="value_%s" title="%s" >'%(i.value,i.propName))
                    choices = i.range.split('#')
                    
                    index = 0
                    for j in choices:
                        if int(i.value) == index:
                            html_list.append('<option value="%s" selected="selected">%s</option>'%(index, j))
                        else:
                            html_list.append('<option value="%s" >%s</option>'%(index, j))
                        index += 1
                    html_list.append('</select>')
                else:
                    html_list.append(i.value)
                
                if self.type == 'desktop': 
                    html_list.append('</li></ul>')
                else:
                    html_list.append('</div></div>')
    
        html = ''.join(html_list)
        data = {}
        data['html'] = head_html + html
        data['height'] = height 
        return data


    def set_port_settings(self,kwargs):
        
        boostSetPropertyObj = KList()
        success = True
        
        logging.info('Port Settings Umkey - pciloc :%s '%( kwargs['pciloc'] ))
        pcikey = UmBoostLib.UMKey('pci', kwargs['pciloc'])
        boostSetPropertyObj.append(pcikey)
        logging.info('Port Settings Umkey - port :%s '%( kwargs['pinstance'] ))
        portkey = UmBoostLib.UMKey('port', kwargs['pinstance'])
        boostSetPropertyObj.append(portkey)
        
        if int(kwargs['properties_count']) > 1:
            for i in range(int(kwargs['properties_count'])):
                logging.info('Port Settings Umkey - propname :%s , value : %s :'%( kwargs['propname'][i], kwargs['value'][i] ))
                prop_key = UmBoostLib.UMKey(kwargs['propname'][i],kwargs['value'][i])
                boostSetPropertyObj.append(prop_key)
        else:
            logging.info('Port Settings umkey - propname :%s , value : %s :'%( kwargs['propname'], kwargs['value']))
            prop_key = UmBoostLib.UMKey(kwargs['propname'],kwargs['value'])
            boostSetPropertyObj.append(prop_key)
        
        logging.info('Port Settings Set Port Properties - Waiting for Boost - sid :%s , ip: %s, ostype : %s \
                     '%(self.sid,self.ip, kwargs['ostype']))
        status = boostSetPropertyObj.setProperty(self.sid, self.ip, 1, int(kwargs['ostype']))
        logging.info('Port Settings Set Port Properties Status : %s'%status)
        
        if status == 0:
            return 0
        elif status == -2:
            return -2
        else:
            return -1
