from UmBoostLib import IntfList, TeamInfo, TmList, TeamList, InterfaceList
import utils, simplejson, settings
logging = settings.get_logger()

class NetworkTeaming:
    
    def __init__(self, sid, ip):
        self.sid = sid
        self.ip = ip

    def get_interface_list(self, ostype, req_type):
        data = {}
        self.req_type = req_type
        logging.info('Network Teaming Interface List:  waiting for response from UMboost sid : %s , IP : %s'%(self.sid, self.ip))
        self.boostIntfListObj = IntfList()
        self.boostInterfaceList = InterfaceList()
        inf_status = self.boostInterfaceList.getNetworkInformation(self.boostIntfListObj,self.sid, self.ip)
        logging.info('Network Teaming Interface List status: %s'%inf_status)
        
        if inf_status == -2:
            data['status'] = '-2'
            return simplejson.dumps(data)
        elif inf_status != 0:
            data['status'] = '-1'
            return simplejson.dumps(data)
        
        logging.info('Network Teaming Team List:  waiting for response from UMboost sid : %s , IP : %s, ostype : %s'%(self.sid, self.ip, ostype))
        self.boostTmListObj = TmList()
        self.boostTeamListObj = TeamList()
        tm_status = self.boostTeamListObj.getTeamInformation(self.boostTmListObj, self.sid, self.ip, int(ostype))
        logging.info('Network Teaming Team List status: %s'%tm_status)
        
        team_exists_flag = False
        
        #Freebsd teamname auto generate, by default make the name as lagg0
        data['next_team_name'] = 'lagg0'
        data['next_team_key'] = 0
        
        if len(self.boostTmListObj) and tm_status == 0:
            team_exists_flag = True
            team_eth_list = []
            teamname_list = []
            for i in range(0,len(self.boostTmListObj)):
                temp_eth_list = self.boostTeamListObj.get(self.boostTmListObj, i).NicGUIDs.replace(' ','_')
                temp_teamname = self.boostTeamListObj.get(self.boostTmListObj, i).NicNames.replace(' ','_')
                team_eth_list = team_eth_list + temp_eth_list.split(',')
                team_eth_list = team_eth_list + temp_teamname.split(',')
                teamname_list += temp_teamname.split(',')
                
            #To generate the next team name for freebsd
            if ostype == '4':
                next_team_key = len(teamname_list) 
                data['next_team_name'] = 'lagg%s'%next_team_key
                data['next_team_key'] = next_team_key
         
        if team_exists_flag:
            self.eth_list = []
            for i in range(0,len(self.boostIntfListObj)):
                friendly_name = self.boostInterfaceList.get(self.boostIntfListObj, i).FriendlyName.replace(' ','_')
                if friendly_name not in team_eth_list:
                    temp_eth_dict = {}
                    temp_eth_dict['status'] = self.boostInterfaceList.get(self.boostIntfListObj, i).Status
                    temp_eth_dict['LinkState'] = self.boostInterfaceList.get(self.boostIntfListObj, i).LinkState
                    temp_eth_dict['friendly_name'] = friendly_name.replace('_',' ')
                    temp_eth_dict['MacString'] = self.boostInterfaceList.get(self.boostIntfListObj, i).MacString
                    self.eth_list.append(temp_eth_dict)
            data['html'] = self.generate_interface_html('list')
            data['status'] = '0'
            return simplejson.dumps(data)
        else:
            data['html'] = self.generate_interface_html('direct')
            data['status'] = '0'
            return simplejson.dumps(data)
        
    def get_network_info_Obj(self):
        for i in range(0,len(self.boostIntfListObj)):
            yield self.boostInterfaceList.get(self.boostIntfListObj, i)         
    
    def generate_interface_html(self,call_type):
        if self.req_type == 'desktop':
            unique_parentid = '#network_content__incend__'+self.ip.replace('.','_')
        else:
            unique_parentid = '#nw_cntb__%s__incend'%self.ip.replace('.','_')

        click_html = 'onclick="cntb_eth_prioritise(\''+ unique_parentid +'\',\'%s\',$(this))"'
        eth_html = '<li class="%s" '+ click_html +'>%s [ %s ]</li>'
        
        whole_html = '%s'
        html_list = []
        if call_type == 'direct':
            for i in self.get_network_info_Obj():
                class_name = 'eth'
                if not i.Status:
                    class_name = 'eth_bk'
                
                if not i.LinkState:
                    class_name = 'eth_bk'
                    
                eth_class = i.FriendlyName.replace(' ','_').replace('.','_')
                html_list.append( whole_html%( eth_html%( class_name, i.FriendlyName, i.FriendlyName, i.MacString ) ) )
            return ''.join(html_list)
        elif call_type == 'list':

            for i in self.eth_list:
                class_name = 'eth'
                if not i['status']:
                   class_name = 'eth_bk'
                if not i['LinkState']:
                   class_name = 'eth_bk'
                
                html_list.append( whole_html%( eth_html%( class_name, i['friendly_name'], i['friendly_name'], i['MacString']) ) )
            return ''.join(html_list)
        return -1
    
    def create_team(self,data):
        if not int(data['iptype']):
            logging.info('Validate Team IP : %s, Validate : 1 '%data['teamip'])
            ip_validate = utils.validate_ip(data['teamip'], 1)
            logging.info('Validate Team IP status %s'%ip_validate)
            if ip_validate == -1:
                return  'Invalid IP'
            
            logging.info('Validate Team mask : %s, Validate : 2 '%data['mask'])
            ip_validate = utils.validate_ip(data['mask'], 2)
            logging.info('Validate Team mask status %s'%ip_validate)
            if ip_validate == -1:
                return  'Invalid Mask'

        logging.info('Create Team: waiting for response from UMboost sid : %s , IP : %s , ifname : %s, mode : %s, teamname : %s, Team Ip : %s,\
                      Mask : %s, TeamPolicy : %s, DhcEnabled : %s, ostype : %s\
                     '%(self.sid,self.ip,data['ifname'],data['mode'],data['teamname'],data['teamip'],data['mask'],data['teampolicy'],int(data['iptype']), data['ostype']))
        self.boostTeamObj = TeamInfo()
        status = self.boostTeamObj.CreateTeam(self.sid,self.ip,data['ifname'],data['mode'],data['teamname'],data['teamip'],data['mask'],data['teampolicy'],int(data['iptype']), int(data['ostype']))
        logging.info('Network Teaming Create Team status: %s'%status)
        
        if status == 0:
            return status
        elif status == -2:
            return -2
        else:
            return -1
