from UmBoostLib import IntfList, InterfaceList, NicInterfaceStats
from xml.dom.minidom import Document

import logging
import settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)


class NetworkStatistics:
    
    def __init__(self, sid, ip) :
         self.sid = sid
         self.ip = ip
    
    def get_interface_list(self, ostype):
        self.ostype = ostype
        self.boostInterfaceList = InterfaceList()
        self.boostNWInterfaceObj = IntfList()
        logging.info('Network Statistics - Get Interface List: waiting for response from UMboost sid : %s , UmServerIP : %s'%(self.sid, self.ip))
        status = self.boostInterfaceList.getNetworkInformation(self.boostNWInterfaceObj, self.sid, self.ip)
        logging.info('Network Statistics - Get Interface List: %s'%(status))
        
        if status == 0:
            return self.generate_interface_html()
        elif status == -2:
            return -2
        else:
            return -1
       
    def get_interface_obj(self):
        for i in range(0,len(self.boostNWInterfaceObj)):
            obj = self.boostInterfaceList.get(self.boostNWInterfaceObj,i)
            if self.ostype == '5':
                if obj.FriendlyName.find('vswif') == -1:
                    yield obj
            else:
                yield obj

    def generate_interface_html(self):
        ip_id = self.ip.replace('.','_')
        unique_parent_id = '#network_content__incend__'+ ip_id+' .network_sns_tab';
        li_html = '<li class="%s" onclick="sns_eth_select(\'%s\',$(this))" >%s [ %s ]\
                  <input type="hidden" value="%s" class="ifname" /></li>'
        whole_html = '%s'

        li_html_list = []
        for i in self.get_interface_obj():
            class_name = 'eth'
    
            if not i.Status:
                class_name = 'eth_bk'
            
            if not i.LinkState:
                class_name = 'eth_bk'
            
#            if i.Status and i.LinkState:
            li_html_list.append( whole_html%( li_html%( class_name, unique_parent_id, i.FriendlyName, i.MacString, i.FriendlyName )) )
        
        html = ''.join(li_html_list)
        return html
    
    def get_table_poll_values(self, kwargs):
        
        #Create initial Stats node
        doc = Document()
        networkstatistics = doc.createElement("networkstatistics")
        doc.appendChild(networkstatistics)
        if int(kwargs['ethcount']) > 1:
            
            for i in range(int(kwargs['ethcount'])):
                self.boostPollObj = NicInterfaceStats()
                logging.info('Network Statistics Table Polling - Waiting for Boost - sid :%s , ip: %s, ifName : %s'%(self.sid, self.ip, kwargs['ifname'][i]))
                status = self.boostPollObj.getInterFaceStats( self.sid, self.ip, kwargs['ifname'][i] )
                logging.info('Network Statistics Table Polling Status for %s : %s'%(kwargs['ifname'][i],status))
                
                if status == -2:
                    return -2
                
                #Create each eth parent node
                eth = doc.createElement("eth")
                networkstatistics.appendChild(eth)
                
                eth.setAttribute('ifname',kwargs['ifname'][i])
                
                if int(kwargs['propertiescount']) > 1:
                    for i in range(int(kwargs['propertiescount'])):
                        property_node = doc.createElement(kwargs['properties'][i])
                        eth.appendChild(property_node)
                        
                        property_value = doc.createTextNode(str(eval('self.boostPollObj.'+kwargs['properties'][i])))
                        property_node.appendChild(property_value)
                else:
                    property_node = doc.createElement(kwargs['properties'])
                    eth.appendChild(property_node)
                    
                    property_value = doc.createTextNode(str(eval('self.boostPollObj.'+kwargs['properties'])))
                    property_node.appendChild(property_value)
        else:
            self.boostPollObj = NicInterfaceStats()
            logging.info('Network Statistics Table Polling - Waiting for Boost - sid :%s , ip: %s, ifName : %s'%(self.sid, self.ip, kwargs['ifname']))
            status = self.boostPollObj.getInterFaceStats( self.sid, self.ip, kwargs['ifname'] )
            logging.info('Network Statistics Table Polling Status for %s : %s'%(kwargs['ifname'],status))
            
            if status == -2:
                return -2
            
            #Create each eth parent node
            eth = doc.createElement("eth")
            networkstatistics.appendChild(eth)
            
            eth.setAttribute('ifname',kwargs['ifname'])
            
            if int(kwargs['propertiescount']) > 1:
                for i in range(int(kwargs['propertiescount'])):
                    property_node = doc.createElement(kwargs['properties'][i])
                    eth.appendChild(property_node)
                    
                    property_value = doc.createTextNode(str(eval('self.boostPollObj.'+kwargs['properties'][i])))
                    property_node.appendChild(property_value)
            else:
                property_node = doc.createElement(kwargs['properties'])
                eth.appendChild(property_node)
                
                property_value = doc.createTextNode(str(eval('self.boostPollObj.'+kwargs['properties'])))
                property_node.appendChild(property_value)
        
        return doc.toprettyxml()
    
    def get_graph_poll_values(self, kwargs):
        
        #Create initial Stats node
        doc = Document()
        networkstatistics = doc.createElement("networkstatistics")
        doc.appendChild(networkstatistics)
        
        if int(kwargs['ethcount']) > 1:
            for i in range(int(kwargs['ethcount'])):
                self.boostPollObj = NicInterfaceStats()
                logging.info('Network Statistics graph Polling - Waiting for Boost - sid :%s , ip: %s, ifName : %s'%(self.sid, self.ip, kwargs['ifname'][i]))
                status = self.boostPollObj.getInterFaceStats( self.sid, self.ip, kwargs['ifname'][i] )
                logging.info('Network Statistics graph Polling Status for %s : %s'%(kwargs['ifname'][i],status))
                
                if status == -2:
                    return -2
                
                #Create each eth parent node
                eth = doc.createElement("eth")
                networkstatistics.appendChild(eth)
                eth.setAttribute('ifname',kwargs['ifname'][i])
                
                if kwargs['type'] == 'tps':
                    
                    if self.boostPollObj.ifInUcastPkts == 'Unsupported' or self.boostPollObj.ifInUcastPkts == '' :
                        ifInUcastPkts = 0
                    else:
                        ifInUcastPkts = int(self.boostPollObj.ifInUcastPkts)
                    if self.boostPollObj.ifInMulticastPkts == 'Unsupported' or self.boostPollObj.ifInMulticastPkts == '': 
                        ifInMulticastPkts = 0
                    else:
                        ifInMulticastPkts = int(self.boostPollObj.ifInMulticastPkts)
                    if self.boostPollObj.ifInBroadcastPkts == 'Unsupported' or self.boostPollObj.ifInBroadcastPkts == '':
                        ifInBroadcastPkts = 0
                    else:
                        ifInBroadcastPkts = int(self.boostPollObj.ifInBroadcastPkts)
                    if self.boostPollObj.ifOutUcastPkts == 'Unsupported' or self.boostPollObj.ifOutUcastPkts == '':
                        ifOutUcastPkts = 0
                    else:
                        ifOutUcastPkts = int(self.boostPollObj.ifOutUcastPkts)
                    if self.boostPollObj.ifOutMulticastPkts == 'Unsupported' or self.boostPollObj.ifOutMulticastPkts == '':
                        ifOutMulticastPkts = 0
                    else:
                        ifOutMulticastPkts = int(self.boostPollObj.ifOutMulticastPkts)
                    if self.boostPollObj.ifOutBroadcastPkts == 'Unsupported' or self.boostPollObj.ifOutBroadcastPkts == '':
                        ifOutBroadcastPkts = 0
                    else:
                        ifOutBroadcastPkts = int(self.boostPollObj.ifOutBroadcastPkts)
                    
                    tps_rps = ifInUcastPkts + ifInMulticastPkts + ifInBroadcastPkts
                    tps_tps = ifOutUcastPkts + ifOutMulticastPkts + ifOutBroadcastPkts  
                    tps_bdps = tps_rps + tps_tps
                    
                    plot_tps_rps = self.boostPollObj.calculateCoordinates(0, tps_rps, int(kwargs['tps_rps_prev_val'][i]), int(kwargs['poll_time']))
                    logging.info('tps_rps : %s'%plot_tps_rps)
                        
                    plot_tps_tps = self.boostPollObj.calculateCoordinates(0, tps_tps, int(kwargs['tps_tps_prev_val'][i]), int(kwargs['poll_time']))
                    logging.info('tps_tps : %s'%plot_tps_tps)
                    
                    plot_tps_bdps = self.boostPollObj.calculateCoordinates(0, tps_bdps, int(kwargs['tps_bdps_prev_val'][i]), int(kwargs['poll_time']))
                    logging.info('tps_bdps : %s'%plot_tps_bdps)
                    
                    tps_rps_node = doc.createElement('tps_rps')
                    eth.appendChild(tps_rps_node)
                    tps_rps_node_value = doc.createTextNode(str(tps_rps))
                    tps_rps_node.appendChild(tps_rps_node_value)
                    
                    plot_tps_rps_node = doc.createElement('plot_tps_rps')
                    eth.appendChild(plot_tps_rps_node)
                    plot_tps_rps_node_value = doc.createTextNode(str(plot_tps_rps))
                    plot_tps_rps_node.appendChild(plot_tps_rps_node_value)
                    
                    tps_tps_node = doc.createElement('tps_tps')
                    eth.appendChild(tps_tps_node)
                    tps_tps_value = doc.createTextNode(str(tps_tps))
                    tps_tps_node.appendChild(tps_tps_value)
                    
                    plot_tps_tps_node = doc.createElement('plot_tps_tps')
                    eth.appendChild(plot_tps_tps_node)
                    plot_tps_tps_value = doc.createTextNode(str(plot_tps_tps))
                    plot_tps_tps_node.appendChild(plot_tps_tps_value)
                    
                    tps_bdps_node = doc.createElement('tps_bdps')
                    eth.appendChild(tps_bdps_node)
                    tps_bdps_value = doc.createTextNode(str(tps_bdps))
                    tps_bdps_node.appendChild(tps_bdps_value)
                    
                    plot_tps_bdps_node = doc.createElement('plot_tps_bdps')
                    eth.appendChild(plot_tps_bdps_node)
                    plot_tps_bdps_value = doc.createTextNode(str(plot_tps_bdps))
                    plot_tps_bdps_node.appendChild(plot_tps_bdps_value)
               
                elif kwargs['type'] == 'tm':
                    
                    if self.boostPollObj.ifInOctets == 'Unsupported' or self.boostPollObj.ifInOctets == '' :
                        tm_rm = 0
                    else:
                        tm_rm = int(self.boostPollObj.ifInOctets)
                    if self.boostPollObj.ifOutOctets == 'Unsupported' or self.boostPollObj.ifOutOctets == '' :
                        tm_tm = 0
                    else:
                        tm_tm = int(self.boostPollObj.ifOutOctets)
                    tm_bdm = tm_rm + tm_tm
                    
                    plot_tm_rm = self.boostPollObj.calculateCoordinates(1, tm_rm, int(kwargs['tm_rm_prev_val'][i]), int(kwargs['poll_time']))
                    logging.info('plot_tm_rm : %s'%plot_tm_rm)
                    plot_tm_tm = self.boostPollObj.calculateCoordinates(1, tm_tm, int(kwargs['tm_tm_prev_val'][i]), int(kwargs['poll_time']))
                    logging.info('plot_tm_tm : %s'%plot_tm_tm)
                    plot_tm_bdm = self.boostPollObj.calculateCoordinates(1, tm_bdm, int(kwargs['tm_bdm_prev_val'][i]), int(kwargs['poll_time']))
                    logging.info('plot_tm_bdm : %s'%plot_tm_bdm)
                    
                    tm_rm_node = doc.createElement('tm_rm')
                    eth.appendChild(tm_rm_node)
                    tm_rm_node_value = doc.createTextNode(str(tm_rm))
                    tm_rm_node.appendChild(tm_rm_node_value)
                    
                    plot_tm_rm_node = doc.createElement('plot_tm_rm')
                    eth.appendChild(plot_tm_rm_node)
                    plot_tm_rm_node_value = doc.createTextNode(str(plot_tm_rm))
                    plot_tm_rm_node.appendChild(plot_tm_rm_node_value)
                    
                    tm_tm_node = doc.createElement('tm_tm')
                    eth.appendChild(tm_tm_node)
                    tm_tm_value = doc.createTextNode(str(tm_tm))
                    tm_tm_node.appendChild(tm_tm_value)
                    
                    plot_tm_tm_node = doc.createElement('plot_tm_tm')
                    eth.appendChild(plot_tm_tm_node)
                    plot_tm_tm_value = doc.createTextNode(str(plot_tm_tm))
                    plot_tm_tm_node.appendChild(plot_tm_tm_value)
                    
                    tm_bdm_node = doc.createElement('tm_bdm')
                    eth.appendChild(tm_bdm_node)
                    tm_bdm_value = doc.createTextNode(str(tm_bdm))
                    tm_bdm_node.appendChild(tm_bdm_value)
                    
                    plot_tm_bdm_node = doc.createElement('plot_tm_bdm')
                    eth.appendChild(plot_tm_bdm_node)
                    plot_tm_bdm_value = doc.createTextNode(str(plot_tm_bdm))
                    plot_tm_bdm_node.appendChild(plot_tm_bdm_value)
        else:
            self.boostPollObj = NicInterfaceStats()
            logging.info('Network Statistics graph Polling - Waiting for Boost - sid :%s , ip: %s, ifName : %s'%(self.sid, self.ip, kwargs['ifname']))
            status = self.boostPollObj.getInterFaceStats( self.sid, self.ip, kwargs['ifname'] )
            logging.info('Network Statistics graph Polling Status for %s : %s'%(kwargs['ifname'],status))
            
            if status == -2:
                return -2
            
            #Create each eth parent node
            eth = doc.createElement("eth")
            networkstatistics.appendChild(eth)
            eth.setAttribute('ifname',kwargs['ifname'])
            
            if kwargs['type'] == 'tps':
                if self.boostPollObj.ifInUcastPkts == 'Unsupported' or self.boostPollObj.ifInUcastPkts == '':
                    ifInUcastPkts = 0
                else:
                    ifInUcastPkts = int(self.boostPollObj.ifInUcastPkts)
                if self.boostPollObj.ifInMulticastPkts == 'Unsupported' or self.boostPollObj.ifInMulticastPkts == '':
                    ifInMulticastPkts = 0
                else:
                    ifInMulticastPkts = int(self.boostPollObj.ifInMulticastPkts)
                if self.boostPollObj.ifInBroadcastPkts == 'Unsupported' or self.boostPollObj.ifInBroadcastPkts == '':
                    ifInBroadcastPkts = 0
                else:
                    ifInBroadcastPkts = int(self.boostPollObj.ifInBroadcastPkts)
                if self.boostPollObj.ifOutUcastPkts == 'Unsupported' or self.boostPollObj.ifOutUcastPkts == '':
                    ifOutUcastPkts = 0
                else:
                    ifOutUcastPkts = int(self.boostPollObj.ifOutUcastPkts)
                if self.boostPollObj.ifOutMulticastPkts == 'Unsupported' or self.boostPollObj.ifOutMulticastPkts == '':
                    ifOutMulticastPkts = 0
                else:
                    ifOutMulticastPkts = int(self.boostPollObj.ifOutMulticastPkts)
                if self.boostPollObj.ifOutBroadcastPkts == 'Unsupported' or self.boostPollObj.ifOutBroadcastPkts == '':
                    ifOutBroadcastPkts = 0
                else:
                    ifOutBroadcastPkts = int(self.boostPollObj.ifOutBroadcastPkts)
                
                tps_rps = ifInUcastPkts + ifInMulticastPkts + ifInBroadcastPkts
                tps_tps = ifOutUcastPkts + ifOutMulticastPkts + ifOutBroadcastPkts  
                tps_bdps = tps_rps + tps_tps
                
                plot_tps_rps = self.boostPollObj.calculateCoordinates(0, tps_rps, int(kwargs['tps_rps_prev_val']), int(kwargs['poll_time']))
                logging.info('tps_rps : %s'%tps_rps)
                
                
                plot_tps_tps = self.boostPollObj.calculateCoordinates(0, tps_tps, int(kwargs['tps_tps_prev_val']), int(kwargs['poll_time']))
                logging.info('tps_tps : %s'%tps_tps)
                
                plot_tps_bdps = self.boostPollObj.calculateCoordinates(0, tps_bdps, int(kwargs['tps_bdps_prev_val']), int(kwargs['poll_time']))
                logging.info('tps_bdps : %s'%tps_bdps)
                
                tps_rps_node = doc.createElement('tps_rps')
                eth.appendChild(tps_rps_node)
                tps_rps_node_value = doc.createTextNode(str(tps_rps))
                tps_rps_node.appendChild(tps_rps_node_value)
                
                plot_tps_rps_node = doc.createElement('plot_tps_rps')
                eth.appendChild(plot_tps_rps_node)
                plot_tps_rps_node_value = doc.createTextNode(str(plot_tps_rps))
                plot_tps_rps_node.appendChild(plot_tps_rps_node_value)
                
                tps_tps_node = doc.createElement('tps_tps')
                eth.appendChild(tps_tps_node)
                tps_tps_value = doc.createTextNode(str(tps_tps))
                tps_tps_node.appendChild(tps_tps_value)
                
                plot_tps_tps_node = doc.createElement('plot_tps_tps')
                eth.appendChild(plot_tps_tps_node)
                plot_tps_tps_value = doc.createTextNode(str(plot_tps_tps))
                plot_tps_tps_node.appendChild(plot_tps_tps_value)
                
                tps_bdps_node = doc.createElement('tps_bdps')
                eth.appendChild(tps_bdps_node)
                tps_bdps_value = doc.createTextNode(str(tps_bdps))
                tps_bdps_node.appendChild(tps_bdps_value)
                
                plot_tps_bdps_node = doc.createElement('plot_tps_bdps')
                eth.appendChild(plot_tps_bdps_node)
                plot_tps_bdps_value = doc.createTextNode(str(plot_tps_bdps))
                plot_tps_bdps_node.appendChild(plot_tps_bdps_value)
            
            elif kwargs['type'] == 'tm':
                    
                    ifInOctets = int(self.boostPollObj.ifInOctets)
                    ifOutOctets = int(self.boostPollObj.ifOutOctets)

                    tm_rm = ifInOctets
                    tm_tm = ifOutOctets  
                    tm_bdm = tm_rm + tm_tm
                    
                    plot_tm_rm = self.boostPollObj.calculateCoordinates(1, tm_rm, int(kwargs['tm_rm_prev_val']), int(kwargs['poll_time']))
                    logging.info('plot_tm_rm : %s'%plot_tm_rm)
                    plot_tm_tm = self.boostPollObj.calculateCoordinates(1, tm_tm, int(kwargs['tm_tm_prev_val']), int(kwargs['poll_time']))
                    logging.info('plot_tm_tm : %s'%plot_tm_tm)
                    plot_tm_bdm = self.boostPollObj.calculateCoordinates(1, tm_bdm, int(kwargs['tm_bdm_prev_val']), int(kwargs['poll_time']))
                    logging.info('plot_tm_bdm : %s'%plot_tm_bdm)
                    
                    tm_rm_node = doc.createElement('tm_rm')
                    eth.appendChild(tm_rm_node)
                    tm_rm_node_value = doc.createTextNode(str(tm_rm))
                    tm_rm_node.appendChild(tm_rm_node_value)
                    
                    plot_tm_rm_node = doc.createElement('plot_tm_rm')
                    eth.appendChild(plot_tm_rm_node)
                    plot_tm_rm_node_value = doc.createTextNode(str(plot_tm_rm))
                    plot_tm_rm_node.appendChild(plot_tm_rm_node_value)
                    
                    tm_tm_node = doc.createElement('tm_tm')
                    eth.appendChild(tm_tm_node)
                    tm_tm_value = doc.createTextNode(str(tm_tm))
                    tm_tm_node.appendChild(tm_tm_value)
                    
                    plot_tm_tm_node = doc.createElement('plot_tm_tm')
                    eth.appendChild(plot_tm_tm_node)
                    plot_tm_tm_value = doc.createTextNode(str(plot_tm_tm))
                    plot_tm_tm_node.appendChild(plot_tm_tm_value)
                    
                    tm_bdm_node = doc.createElement('tm_bdm')
                    eth.appendChild(tm_bdm_node)
                    tm_bdm_value = doc.createTextNode(str(tm_bdm))
                    tm_bdm_node.appendChild(tm_bdm_value)
                    
                    plot_tm_bdm_node = doc.createElement('plot_tm_bdm')
                    eth.appendChild(plot_tm_bdm_node)
                    plot_tm_bdm_value = doc.createTextNode(str(plot_tm_bdm))
                    plot_tm_bdm_node.appendChild(plot_tm_bdm_value)
        
        return doc.toprettyxml()