from UmBoostLib import IntfList , IPList , NetworkInfo , TeamInfo, TmList, InterfaceList , IntfIPList, TeamList
import simplejson
import utils
import settings
logging = settings.get_logger()

class WebNetworkInfo:
    
    def __init__(self,sessionId,hostIP):
        self.sessionId = sessionId
        self.hostIP = hostIP
        
    #This function is being shared by "generate_interface_html()" and "get_interface_count"   
    def getNetworkInfoObj(self):
        for i in range(0,len(self.boostIntfListObj)):
            yield self.boostInterfaceList.get(self.boostIntfListObj,i) 
            
    def eth_list_html(self,obj, is_team):
        
        status_class = 'green_f'
        class_name = 'eth'

        if obj.Status:
            status = 'Enabled '
            name = 'enabled'
        else:
            status = 'Disabled '
            status_class = 'red_f'
            class_name = 'eth_bk'
            name = 'disabled'
        
        if obj.LinkState:
            link = 'Link Present'
        else:
            link = 'No Link'
            status_class = 'red_f'
            class_name = 'eth_bk'
            
        desc_title =  obj.Description
        
        if len(obj.Description) > 35:
            desc = "%s..."%obj.Description[:35]
        else:
            desc = obj.Description
            
        if obj.DHCPEnabled:
            ip_type = 'dhcp'
        else:
            ip_type = 'static'
        
        ipid = self.hostIP.replace('.','_')
        
        team_class = 'is_not_team'
        if is_team:
            team_class = 'is_team'
        
        if self.req_type == 'desktop':
            html = '<li class="%s %s" name="%s" onclick = "fill_interface_details($(this))" >%s [ %s ]\
                    <input type="hidden" class="ipid" value="%s" />\
                    <input type="hidden" class="sa" value="%s [ %s ]" />\
                    <input type="hidden" class="desc" value="%s" />\
                    <input type="hidden" class="desc_title" value="%s" />\
                    <input type="hidden" class="status" value="%s__%s**%s" />\
                    <input type="hidden" class="ip_type" value="%s" />\
                    <input type="hidden" class="mtu" value="%s" />\
                    <input type="hidden" class="vlan" value="%s" />%s\
                    </li>'%(class_name,team_class,name,obj.FriendlyName,obj.MacString,ipid,obj.FriendlyName,obj.MacString,desc,desc_title,status_class,\
                            status,link,ip_type,obj.mtu,obj.vlanId,self.generateIpList(obj.FriendlyName))
        else:
            #Get the Ip and mask
            ip_mask = self.generateIpList(obj.FriendlyName)
            html = '<option value="%s__%s__%s__%s [ %s ]__%s__%s__%s*%s**%s__%s__%s__%s__%s" >%s [ %s ]\
                    </option>'%(class_name,team_class,name,obj.FriendlyName,obj.MacString,desc,desc_title,status_class,\
                            status,link,ip_type,obj.mtu,obj.vlanId,ip_mask,obj.FriendlyName,obj.MacString)
        return html

    def generate_interface_html(self, obj, type, interface_string):
        
        #mobile
        ipid = self.hostIP.replace('.','_')
        
        if type == 'direct':
            html = []
            
            head_html = '<select onchange="fill_interface_details($(this), \'%s\')">\
                         <option value="">select one..</option>\
                         %s</select>'
            
            for i in self.getNetworkInfoObj():
                if self.ostype.strip() == '5':
                    if i.FriendlyName.find('vmnic') == -1:
                        html.append(self.eth_list_html(i, False))
                else:
                    html.append(self.eth_list_html(i, False))
            whole_html = ''.join(html)
            if self.req_type == 'mobile':
                return head_html%(ipid, whole_html)
            else:
                return whole_html
                
        elif type == 'single':
            return self.eth_list_html(obj, False)
            
        elif type == 'team':
            if self.req_type == 'desktop':
                team_html = self.eth_list_html(obj, True)
                team_eth_members = interface_string.split(',')
                team_eth_members_html = '<li class="team_eth">%s</li>'
                eth_html_list = [ team_eth_members_html%( eth_name.replace('_',' ') ) for eth_name in team_eth_members ]
                whole_eth_html = ''.join(eth_html_list)
                return team_html + whole_eth_html
            else:
                select_data = {}
                team_html = self.eth_list_html(obj, True)
                select_data['eth_html'] = team_html
                team_class = obj.FriendlyName.replace(' ','_').replace('.','_')
                team_eth_members_head = '<select class = "%s as_hide" >%s</select>'
                team_eth_members_html = '<option value="team_eth">%s</option>'
                eth_html_list = [ team_eth_members_html%( eth_name.replace('_',' ') ) for eth_name in team_eth_members ]
                whole_eth_html = ''.join(eth_html_list)
                select_data['team_eth_html'] = team_eth_members_head%(ipid, team_class, whole_eth_html)
                return select_data
        
        return -1

    def getInterfaceList(self, ostype, req_type):
        
        self.ostype = ostype
        self.req_type = req_type
        logging.info('Network Information Interface List:  waiting for response from UMboost sid : %s , IP : %s'%(self.sessionId,self.hostIP))
        self.boostIntfListObj = IntfList()
        self.boostInterfaceList = InterfaceList()
        inf_status = self.boostInterfaceList.getNetworkInformation(self.boostIntfListObj, self.sessionId, self.hostIP)
        logging.info('Network Information Interface List status: %s'%inf_status)
        
        if inf_status == -2:
            return -2 
        elif inf_status != 0:
            return -1 
        
        logging.info('Network Information Team List:  waiting for response from UMboost sid : %s , IP : %s, ostype : %s'%(self.sessionId, self.hostIP, ostype))
        self.boostTmListObj = TmList()
        self.boostTeamListObj = TeamList()
        tm_status = self.boostTeamListObj.getTeamInformation(self.boostTmListObj, self.sessionId, self.hostIP, int(ostype))
        logging.info('Network Information Team List status: %s'%tm_status)
        
        if inf_status == -2:
            return -2 
        
        team_exists_flag = False
        
        if len(self.boostTmListObj) and tm_status == 0:
            team_exists_flag = True
            eth_of_team = {}
            team_names = []
            eth_exists_inteams = []
            for i in range(0,len(self.boostTmListObj)):
                team_name = self.boostTeamListObj.get(self.boostTmListObj,i).NicNames.replace(' ','_')
                
                #Holds Eth list of the current team | Key = Team Name | Value = Eth List
                eth_of_team[team_name] = self.boostTeamListObj.get(self.boostTmListObj, i).NicGUIDs.replace(' ','_')
                
                #Holds the name of the teams
                team_names.append(team_name)
                
                temp_eth_list = self.boostTeamListObj.get(self.boostTmListObj,i).NicGUIDs.replace(' ','_')
                #Holds all the eth exists in the teams
                eth_exists_inteams = eth_exists_inteams + temp_eth_list.split(',')
                
        if team_exists_flag:
            #Desktop
            team_eth_html = []
            
            #mobile
            return_data = {}
            team_eth_list = []
            ipid = self.hostIP.replace('.','_')
            head_html = '<select onchange="fill_interface_details($(this), \'%s\')">\
                        <option value="">select one..</option>\
                        %s</select>'
            
            #Loop Through the eth List
            for i in range(0,len(self.boostIntfListObj)):
                inf_obj = self.boostInterfaceList.get(self.boostIntfListObj,i)
                friendly_name = inf_obj.FriendlyName.replace(' ','_')
                #If the current eth is not present in the list of eth's of all teams and if its not team name then its a normal interface
                #Hence generate normal html of this eth
                if friendly_name not in eth_exists_inteams and friendly_name not in team_names:
                   team_eth_html.append(self.generate_interface_html(inf_obj, 'single', False))
                #If elif condition satisfies that means the current eth name is a team name
                #Hence get the current team regular details even build the html with its child eth list
                elif friendly_name in team_names:
                   if self.req_type == 'desktop':
                       team_eth_html.append(self.generate_interface_html(inf_obj, 'team', eth_of_team[friendly_name]))
                   else:
                       select_data = self.generate_interface_html(inf_obj, 'team', eth_of_team[friendly_name])
                       team_eth_html.append(select_data['eth_html'])
                       team_eth_list.append(select_data['team_eth_html'])
            whole_html = ''.join(team_eth_html)
            if self.req_type == 'mobile':
                return_data['eth_html'] = head_html%(ipid, whole_html)
                return_data['team_eth_html'] = ''.join(team_eth_list)
                return simplejson.dumps(return_data)
            else:
                return whole_html
        else:
            if self.req_type == 'mobile':
                return_data = {}
                return_data['eth_html'] = self.generate_interface_html(False, 'direct', False)
                return_data['team_eth_html'] = ''
                return simplejson.dumps(return_data)
            else:
                return self.generate_interface_html(False, 'direct', False)
        
    def UpdateAdapter(self,action,intfname):
        
        self.boostNetworkInfoObj = NetworkInfo()
        if action == 'enable':
            logging.info('%s Adapter:  waiting for response from UMboost sid : %s , IP : %s , InterFace Name : %s '%(action,self.sessionId,self.hostIP,intfname))
            status = self.boostNetworkInfoObj.EnableAdapter(self.sessionId,self.hostIP,intfname)
            logging.info('Enable Adapter status: %s'%status)
            if status == -2:
                return -2 
        elif action == 'disable':
            logging.info('%s Adapter:  waiting for response from UMboost sid : %s , IP : %s , InterFace Name : %s '%(action,self.sessionId,self.hostIP,intfname))
            status = self.boostNetworkInfoObj.DisableAdapter(self.sessionId,self.hostIP,intfname)
            logging.info('Disable Adapter status: %s'%status)
            if status == -2:
                return -2 
        
        if status == 0:
            return status
        else:
            return -1

    def SetIpAddr(self,data):
        
        if data['action'] == 'ModifyIp':
            validate_ip = data['newip']
            validate_mask = data['mask']
        else:
            validate_ip = data['ip']
            validate_mask = data['mask']
        
        if data['action'] != 'dhcp':
            logging.info('Validate IP : %s, Validate : 1 '%validate_ip)
            ip_validate = utils.validate_ip(validate_ip, 1)
            logging.info('IP Validate status %s'%ip_validate)
            if ip_validate == -1:
                return  'Invalid IP'
        
        if data['action'] != 'DeleteIp' and data['action'] != 'dhcp':
            logging.info('Validate mask : %s, Validate : 2'%validate_mask)
            mask_validate = utils.validate_ip(validate_mask, 2)
            logging.info('mask Validate status %s'%mask_validate)
            if mask_validate == -1:
                return  'Invalid Mask'
        
        self.boostSetIpObj = NetworkInfo()
        logging.info('Set %s:  waiting for response from UMboost sid : %s , UmServerIP : %s , InterFace Name : %s , reqType : %s\
                    , ipType : %s, ipversion : %s, Ip : %s , mask : %s , NewIp : %s\
                    '%(data['action'],self.sessionId,self.hostIP,data['ifName'],data['reqType'],data['ipType'],\
                       data['ipversion'],data['ip'],data['mask'],data['newip']))
        status = self.boostSetIpObj.SetIpAddress(self.sessionId,self.hostIP,data['ifName'].strip(),data['reqType'],data['ipType'],data['ipversion'],data['ip'],data['mask'],data['newip'])
        logging.info('Set %s status: %s'%(data['action'],status))
        
        if status == 0:
            return  status
        elif status == -2:
            return -2
        else:
            return -1
        
    def set_mtu(self,data):
        
        self.boostSetMTUObj = NetworkInfo()
        logging.info('Set MTU:  waiting for response from UMboost sid : %s , UmServerIP : %s , InterFace Name : %s , MTU : %s\
                         '%(self.sessionId,self.hostIP,data['ifName'],data['mtu']))
        status = self.boostSetMTUObj.SetMTU(self.sessionId,self.hostIP,data['ifName'],data['mtu'])
        logging.info('Set MTU status: %s'%(status))
        
        if status == 0:
            return  status
        elif status == -2:
            return -2
        else:
            return -1
        
    def set_vlan(self,data):
        
        self.boostSetVlanObj = NetworkInfo()
        logging.info('Set VLAN:  waiting for response from UMboost sid : %s , UmServerIP : %s , InterFace Name : %s , VLAN : %s\
                         ',(self.sessionId,self.hostIP,data['ifName'],data['vlan']))
        status = self.boostSetVlanObj.SetVLAN(self.sessionId,self.hostIP,data['ifName'],data['vlan'])
        logging.info('Set VLAN status: %s'%(status))
        
        if status == 0:
            return  status
        elif status == -2:
            return -2
        else:
            return -1
        
    def delete_vlan(self,data):
        
        self.boostSetVlanObj = NetworkInfo()
        param = ''
        if data['ostype'].strip() != '1':
            #Rhel eth5.2@eth5 - pass eth5
            if data['ifName'].count('@'):
                param = data['ifName'].split('@')[1]
            #Freebsd eth5.2 - pass eth5
            elif data['ifName'].count('.'):
                param = data['ifName'].split('.')[0]
        else:
            param = data['ifName'].strip()
            
        logging.info('Delete VLAN:  waiting for response from UMboost sid : %s , UmServerIP : %s , param : %s , vlan_id : %s'%(self.sessionId, self.hostIP, param , data['vlan_id']))
        status = self.boostSetVlanObj.DelVLAN(self.sessionId,self.hostIP, param , data['vlan_id'])
        logging.info('Delete VLAN status: %s'%(status))
        
        if status == 0:
            return  status
        elif status == -2:
            return -2
        else:
            return -1
        
    def delete_team(self,data):
        
        boostDeleteTeamObj = TeamInfo()
        logging.info('Delete Team:  waiting for response from UMboost sid : %s , UmServerIP : %s , InterFace Name : %s\
                         ',(self.sessionId,self.hostIP,data['ifName']))
        status = boostDeleteTeamObj.DeleteTeam(self.sessionId,self.hostIP,data['ifName'])
        logging.info('Delete Team status: %s'%(status))
        
        if status == 0:
            return  status
        elif status == -2:
            return -2
        else:
            return -1
        
    def getIpListObj(self):
        for i in range(0,len(self.boostIpListObj)):
            yield self.boostIntfIpListobj.get(self.boostIpListObj, i)   
    
    def generateIpList(self,ifaceName):
        
        logging.info('Network Information IP List:  waiting for response from UMboost sid : %s , IP : %s , ifaceName : %s'%(self.sessionId,self.hostIP,ifaceName))
        self.boostIpListObj = IPList()
        self.boostIntfIpListobj = IntfIPList()
        status = self.boostIntfIpListobj.getIntfIPInformation(self.boostIpListObj, self.sessionId, self.hostIP, ifaceName, 0) 
        logging.info('Network Information IP List status: %s'%status)
        
        Iplist = '%s'
        
        if self.req_type == 'desktop':
            ip_html = '<input type="hidden" class="ip_mask" value="%s__%s" />'
        else:
            ip_html = '%s*%s'
        
        IplistHtml = [ Iplist%( ip_html %(i.Address , i.Mask )) for i in self.getIpListObj()]
    
        IplistHtml = ''.join(IplistHtml)
        
        return IplistHtml
    
    def get_interface_count(self, ostype):
       self.boostInterfaceList = InterfaceList()
       self.boostIntfListObj = IntfList()
       logging.info('Network Summary - Get Interface count: waiting for response from UMboost sid : %s , UmServerIP : %s'%(self.sessionId,self.hostIP))
       status = self.boostInterfaceList.getNetworkInformation(self.boostIntfListObj, self.sessionId, self.hostIP)
       logging.info('Network Summary - Get Interface count: %s'%(status))
       
       if status == 0:
           if ostype == '5':
               interface_count = 0
               for i in self.getNetworkInfoObj():
                   if i.FriendlyName.find('vswif') == -1:
                       interface_count += 1
           else:
               interface_count = len(self.boostIntfListObj)
           return interface_count
       elif status == -2:
           return -2
       else:
           return -1
