from kvmutils import KVMUtils, VMInfoLst

import settings
logging = settings.get_logger()

class LinKvmConf(object):
    def __init__(self, sid, ip, type):
        self.sid = sid
        self.ip = ip
        self.type = type
        self.kvmUtils = KVMUtils(ip, sid)  

    def lin_kvm_operation(self, data):
        
        if data['action'] == 'enable':
            logging.info('Linux KVM Configuration Enable KVM waiting for response from UMboost sid : %s , IP : %s, vf_str : %s'%(self.sid, self.ip, data['vf_str']))
            status = self.kvmUtils.enableKVM( data['vf_str'] )
            logging.info('Linux KVM Configuration Enable KVM status: %s'%status)
        elif data['action'] == 'disable':
            logging.info('Linux KVM Configuration disable KVM waiting for response from UMboost sid : %s , IP : %s'%(self.sid, self.ip))
            status = self.kvmUtils.disableKVM()
            logging.info('Linux KVM Configuration disable KVM status: %s'%status)
        else:
            return -1
        
        if status == 0 or status == -2 or status == 64:
            return status
        else:
            return -1