from kvmutils import BridgeLst, KVMUtils, IfNameLst, VMInfoLst, InterfaceLst

import settings, utils
logging = settings.get_logger()

class LinBridgeConf(object):
    
    def __init__(self, sid, ip, type):
        self.sid = sid
        self.ip = ip
        self.type = type
        self.kvmUtils = KVMUtils( ip, sid)
    
    def get_lin_tree(self):      
        
        logging.info('Hypervisor - Lin Bridge Configuration List Vms sid : %s , IP : %s'%(self.sid, self.ip))
        agmtVMInfoLstObj = VMInfoLst()
        status = self.kvmUtils.listVMs( agmtVMInfoLstObj )
        logging.info('Hypervisor - Lin Bridge Configuration List Vms status: %s'%status)
        
        if status == -2:
            return -2
        elif status != 0:
            return -1 
        
        vm_info_dict = {}
        vm_if_dict = {}
        for i in range(len(agmtVMInfoLstObj)):
            vmid = agmtVMInfoLstObj[i].id

            #Skipt vm wiht id 0 or less than 0
            if vmid < 0:
                continue
            
            current_vm_info = {}
            current_vm_info['uuid'] = agmtVMInfoLstObj[i].uuid
            current_vm_info['id'] = agmtVMInfoLstObj[i].id
            current_vm_info['name'] = agmtVMInfoLstObj[i].name
            current_vm_info['osType'] = agmtVMInfoLstObj[i].osType
            current_vm_info['domainState'] = agmtVMInfoLstObj[i].domainState
            #Store all the properties of the VM, which can be accessed with its id
            vm_info_dict[vmid] = current_vm_info
            
            #Get all the interfaces in the VM
            logging.info('Hypervisor - Lin Bridge Configuration listVMInterface sid : %s , IP : %s, vmid : %s'%(self.sid, self.ip, vmid))
            agmtListVmIinterface = InterfaceLst()
            status = self.kvmUtils.listVMInterface(vmid, agmtListVmIinterface)  
            logging.info('Hypervisor - Lin Bridge Configuration listVMInterface status: %s'%status)
            
            if status == -2:
                 return -2
            elif status != 0 or len(agmtListVmIinterface) == 0:
                continue
            
            #Make a dict whose key is the interface and value is the vm
            #Which will give the VM , when the interface key has been passed during listBridgeInterfaces
            # vm_if_dict has been defined before for loop, to prevent reference errors 
            for i in range(len(agmtListVmIinterface)):
                ifname = agmtListVmIinterface[i].targetDev
                vm_if_dict[ifname] = vmid
                
        logging.info('----------listVMInterface : inter - vmid : %s'%vm_if_dict)
        logging.info('Hypervisor - Lin Bridge Configuration listBridges: Sid : %s, Ip : %s'%( self.sid, self.ip ))
        agmtBridgeLstObj = BridgeLst()  
        status = self.kvmUtils.listBridges(agmtBridgeLstObj)
        logging.info('Hypervisor - Lin Bridge Configuration listBridges status : %s'%( status ))
        
        plus = '<a class="tree_action" href="javascript:void(0);"><img src="/images/black/tree_plus.png" /></a>'
        minus = '<a class="tree_action" href="javascript:void(0);"><img src="/images/black/tree_minus.png" /></a>'
        ip_id = self.ip.replace('.','_')
        unique_parent_id = '#hypervisor_linux_content__incend__'+ip_id+' .lin_bridge_conf_tab'
        
        main_html = ''
        for i in range(len(agmtBridgeLstObj)):
            
            bridge_html = '<ul class="tree_ul">\
                        <li class="vm_tree_li">'
             
            bridge_name = agmtBridgeLstObj[i].name
            # Plus or minus image has been removed
            bridge_desc_html =   '<a href="javascript:void(0);" alt="bridge" onclick="lin_conf_select(\'%s\', $(this), \'bridge\')">\
                                <img class="icon" src="images/black/b.png" />%s\
                                <input class="name" type="hidden" value="%s" />\
                                <input class="pathCost" type="hidden" value="%s" />\
                                <input class="maxAge" type="hidden" value="%s" />\
                                <input class="helloTime" type="hidden" value="%s" />\
                                <input class="ageingTime" type="hidden" value="%s" />\
                                <input class="forwardDelay" type="hidden" value="%s" />\
                                <input class="tcnTimer" type="hidden" value="%s" />\
                                <input class="helloTimer" type="hidden" value="%s" />\
                                <input class="topologyChangeTimer" type="hidden" value="%s" />\
                                <input class="gcTimer" type="hidden" value="%s" />\
                                <input class="id" type="hidden" value="%s" />\
                                <input class="designatedRoot" type="hidden" value="%s" />\
                            </a>'%( unique_parent_id, bridge_name, bridge_name, agmtBridgeLstObj[i].pathCost, agmtBridgeLstObj[i].maxAge, agmtBridgeLstObj[i].helloTime\
                                     , agmtBridgeLstObj[i].ageingTime\
                                     , agmtBridgeLstObj[i].forwardDelay, agmtBridgeLstObj[i].tcnTimer, agmtBridgeLstObj[i].helloTimer\
                                     , agmtBridgeLstObj[i].topologyChangeTimer, agmtBridgeLstObj[i].gcTimer, agmtBridgeLstObj[i].id, agmtBridgeLstObj[i].designatedRoot\
                                     )
            
            #listBridgeInterfaces will return all the interfaces under it , even those attached to VM, Then we should find which interfaces are present in a VM
            #And should display that VM under the inerface
            logging.info('Hypervisor - Lin Bridge Configuration listBridgeInterfaces: Sid : %s, Ip : %s, bridge_name : %s'%( self.sid, self.ip, bridge_name ))
            agmtBridgeInterfacesObj = IfNameLst()
            status = self.kvmUtils.listBridgeInterfaces(bridge_name, agmtBridgeInterfacesObj)
            logging.info('Hypervisor - Lin Bridge Configuration listBridgeInterfaces status : %s'%( status ))
            
            if status != 0 or len(agmtBridgeInterfacesObj) == 0:
                #No plus or minus img
                main_html += bridge_html+bridge_desc_html+'</li></ul>'
                continue
            
            #Add plus, add all the interfaces to the bridge
            bridge_desc_html = minus+bridge_desc_html
            
            for i in range(len(agmtBridgeInterfacesObj)):
                ifname = agmtBridgeInterfacesObj[i]
                logging.info('------------bridge ifname :%s'%ifname)
                #Is this interface part of a VM
                if vm_if_dict.has_key(ifname):
                    current_vmid = vm_if_dict[ifname]
                    #As represented in the tree - This is VIF & VM
                    #vif_html = '<ul class="as_hide">\
                    vif_html = '<ul>\
                                    <li>%s\
                                        <a class="" href="javascript:void(0);" onclick="lin_conf_select(\'%s\', $(this), \'vif\')">\
                                            <img class="icon" src="images/black/v_network.png" />%s\
                                            <input class="ifname" type="hidden" value="%s" />\
                                            <input class="brname" type="hidden" value="%s" />\
                                            <input class="vmid" type="hidden" value="%s" />\
                                        </a>\
                                        <ul class="as_hide">\
                                            <li>\
                                                <a href="javascript:void(0);" onclick="lin_conf_select(\'%s\', $(this), \'vm\')">\
                                                    <img class="icon" src="images/black/pg_col.png" />%s\
                                                    <input class="name" type="hidden" value="%s" />\
                                                    <input class="osType" type="hidden" value="%s" />\
                                                    <input class="uuid" type="hidden" value="%s" />\
                                                    <input class="domainState" type="hidden" value="%s" />\
                                                </a>\
                                            </li>\
                                        </ul>\
                                    </li>\
                                </ul>'%(plus, unique_parent_id, ifname, ifname, bridge_name, vm_info_dict[current_vmid]['id'], unique_parent_id, vm_info_dict[current_vmid]['name'], vm_info_dict[current_vmid]['name'],\
                                        vm_info_dict[current_vmid]['osType'], vm_info_dict[current_vmid]['uuid'], vm_info_dict[current_vmid]['domainState'] )
                    
                else:
                    #As represented in the tree - This is PIF
                    vif_html = '<ul class="as_hide">\
                                    <li>\
                                        <a href="javascript:void(0);" onclick="lin_conf_select(\'%s\', $(this), \'pif\')">\
                                            <img class="icon" src="images/black/pg_col.png" />%s\
                                            <input class="vendor_id" type="hidden" value="%s" />\
                                            <input class="ifname" type="hidden" value="%s" />\
                                            <input class="brname" type="hidden" value="%s" />\
                                        </a>\
                                    </li>\
                                </ul>'%( unique_parent_id, ifname, ifname, ifname, bridge_name)
                
                bridge_desc_html += vif_html
            main_html += bridge_html+bridge_desc_html+'</li></ul>'
        return main_html

    
    def delete_vif(self, data):      
        
        logging.info('Hypervisor - Lin Bridge Configuration delete Vif - sid : %s , IP : %s, brname : %s, ifname : %s, vmid : %s'%(self.sid, self.ip\
                    , data['brname'], data['ifname'], data['vmid']))
        status = self.kvmUtils.removeVnetFromVM( data['brname'], data['ifname'], int(data['vmid'].strip()) )
        logging.info('Hypervisor - Lin Bridge Configuration delete Vif status: %s'%status)
        
        if status == -2 or status == 0:
            return status
        else:
            return -1
    
    def delete_pif(self, data):      
        
        logging.info('Hypervisor - Lin Bridge Configuration delete Pif - sid : %s , IP : %s, brname : %s, ifname : %s'%(self.sid, self.ip\
                    , data['brname'], data['ifname']))
        status = self.kvmUtils.removeInterfaceFromBridge( data['brname'], data['ifname'])
        logging.info('Hypervisor - Lin Bridge Configuration delete Pif status: %s'%status)
        
        if status == -2 or status == 0:
            return status
        else:
            return -1
        
    def delete_bridge(self, brname):      
        
        logging.info('Hypervisor - Lin Bridge Configuration delete Bridge - sid : %s , IP : %s, brname : %s'%(self.sid, self.ip, brname))
        status = self.kvmUtils.deleteBridge( brname )
        logging.info('Hypervisor - Lin Bridge Configuration delete Bridge status: %s'%status)
        
        if status == -2 or status == 0:
            return status
        else:
            return -1

    def save_bridge_val(self, data):
        
        #Generate Input xml string
        bridge_props = '<Bridge Name = "%s" \
                            AgingTime = "%s" \
                             ForwardDelay = "%s" \
                             HelloTime = "%s" \
                             MaxAge = "%s" \
                             Priority = "%s" \
                             STP = "%s"> \
                        </Bridge>'%( data['brname'], data['ageingTime'], data['forwardDelay'], data['helloTime'], data['maxAge'], data['priority'], data['stp']  )
        
        logging.info('Hypervisor - Lin Bridge Configuration Set Bridge Props: Sid : %s, Ip : %s, XMl : %s'%( self.sid, self.ip, bridge_props ))
        status = self.kvmUtils.setBridgeProperty( bridge_props )
        logging.info('Hypervisor - Lin Bridge Configuration Set Bridge Props status : %s'%( status ))
        
        if status == -2 or status == 0:
            return status
        else:
            return -1