from DriverInfoFile import DriverDetails
import UmBoostLib 
from UmBoostLib import UmProperties, PList, PropsList, KList

import settings, simplejson
logging = settings.get_logger()

class Iwarp:
    
    def __init__(self, sid ,ip, type ):
        self.sid = sid
        self.ip = ip
        self.type = type

    def get_iwarp_settings(self,data):
        
        logging.info('iWarp Settings : Get Properties: waiting for response from UMboost SID : %s , IP : %s , Driver name : %s, pciloc : %s, pindex : %s, ostype : %s\
                     '%(self.sid, self.ip, data['driver_name'], data['pciloc'], data['pindex'], data['ostype']))
        
        self.boostPlistObj = PList()
        self.boostPropslistObj = PropsList()
        status = self.boostPropslistObj.getiWARPProperties(self.boostPlistObj, self.sid, self.ip, data['driver_name'], data['pciloc'], int(data['pindex']), int(data['ostype']) )
        logging.info('iWarp Settings : Get Properties status: %s'%status)
        
        if status == -2:
            return -2
        elif not len(self.boostPlistObj):
            return -80
        elif status == 0:
            return self.generate_html()
        else:
            return -1

    def get_obj(self):
        for i in range(0,len(self.boostPlistObj)):
            yield self.boostPropslistObj.get(self.boostPlistObj,i)

    '''
    CELL TYPES
    NONE = 0,
    TEXT_EDITOR=1,
    BOOL_EDITOR=2,
    NUMBER_EDITOR=3,
    CHOICE_EDITOR=4,
    RANGE_EDITOR=5
    '''
    def generate_html(self):
        if self.type == 'desktop':
            head_html = '<ul class="horizontal head_ul">\
                         <li class="desc"><h2>Description</h2></li>\
                         <li class="value"><h2 class="bg_none" >Value</h2></li>\
                         </ul>'
        else:
            head_html = '<div class="ui-grid-a heading" data-theme="b" >\
                        <div class="ui-block-a ui-bar-b center desc">Description</div>\
                        <div class="ui-block-b ui-bar-b center value">Value</div>\
                        </div>'
        html_list = []
        height = 40
        
        k = 0
        for i in self.get_obj():
            k += 1
            height += 33
            if self.type == 'desktop':
                html_list.append('<ul class="horizontal content_tbl clear from_server">\
                            <li class="desc">%s</li>'%i.propDesc)
            else:
                html_list.append('<div class=" ui-grid-a grid from_server">\
                    <div class="ui-block-a iter desc">%s</div>'%i.propDesc)
                        
            if not i.isEditable:
                if self.type == 'desktop':    
                    html_list.append('<li class="bg_none value" >%s</li></ul>'%value)
                else:
                    html_list.append('<div class="ui-block-b value iter" >%s</div></div>'%value)
            else:
                if self.type == 'desktop': 
                    html_list.append('<li class="bg_none value" >')
                else:
                    html_list.append('<div class="ui-block-b value iter" >')

                if int(i.cellType) == 1:
                    html_list.append('<input autocomplete="off" type = "text" class="text text_editor" name="value_%s" title="%s" value="%s" >'%(i.value,i.propName,i.value))
                elif int(i.cellType) == 2:
                    html_list.append('<select autocomplete="off" class="value_%s" title="%s" >'%(i.value,i.propName))
                    if i.value == 1 or i.value.strip() == 'Yes' or i.value.strip() == '1':
                        html_list.append('<option value="1" selected="selected">Yes</option>\
                                     <option value="0">No</option></select>')
                    else:
                        html_list.append('<option value="1" >Yes</option>\
                                     <option value="0" selected="selected">No</option></select>')
                elif int(i.cellType) == 3:
                    
                    if self.type == 'desktop': 
                        html_list.append('<div class="number_editor">\
                                            <div class="fl_left input_wr">')
                        
                        min = i.range.split('#')[0]
                        max = i.range.split('#')[1]
                        inc = i.stepby
    
                        html_list.append('<input type = "text" name="value_%s" title="%s" value="%s" class="text xsml" onblur="number_editor($(this),%s,%s,%s,\'blur\')" onkeyup="number_editor($(this),%s,%s,%s,\'validate\')"  />\
                                        </div>'%(i.value,i.propName,i.value,max,min,inc,max,min,inc))
                        html_list.append('<div class="controls"><div class="up_arrow_wr">\
                                        <img src="/images/black/up_arrow_hover.png" onclick = "number_editor($(this),%s,%s,%s,\'inc\')"  />\
                                        </div><div class= "down_arrow_wr">\
                                        <img src="/images/black/down_arrow_hover.png" onclick = "number_editor($(this),%s,%s,%s,\'dec\')" />\
                                        </div></div></div>'%(max,min,inc,max,min,inc))
                    else:
                        min = i.range.split('#')[0]
                        max = i.range.split('#')[1]
                        html_list.append('<input autocomplete="off" type = "text" class="text text_editor" name="value_%s" title="%s" value="%s"\
                                         onchange="number_editor($(this), %s, %s)" >'%(i.value,i.propName,i.value, min, max))
                    
                elif int(i.cellType) == 4:
                    html_list.append('<select autocomplete="off" class="value_%s" title="%s" >'%(i.value,i.propName))
                    choices = i.range.split('#')
                    m = 0
                    for j in choices:
                        if str(i.value) == str(m):
                            html_list.append('<option value="%s" selected="selected">%s</option>'%(m, j))
                        else:
                            html_list.append('<option value="%s" >%s</option>'%(m, j))
                        m += 1
                    html_list.append('</select>')
                else:
                    html_list.append(i.value)
                
                if self.type == 'desktop': 
                    html_list.append('</li></ul>')
                else:
                    html_list.append('</div></div>')
    
        html = ''.join(html_list)
        data = {}
        data['html'] = head_html+html
        data['height'] = height
        return simplejson.dumps(data)


    def set_iwarp_settings(self,kwargs):
        boostSetPropertyObj = KList()
        success = True
        
        if kwargs['ostype'] == '1':
            logging.info('iWarp Settings: Adding Pci : %s'%kwargs['pciloc'])
            pciloc_key = UmBoostLib.UMKey('pci',kwargs['pciloc'])
            boostSetPropertyObj.append(pciloc_key)
         
            logging.debug('iWarp Settings Umkey - port instance :%s '%( kwargs['pinstance'] ))
            portkey = UmBoostLib.UMKey('port', kwargs['pinstance'])
            boostSetPropertyObj.append(portkey)
        elif kwargs['ostype'] == '2' or kwargs['ostype'] == '4':
            logging.info('iWarp Settings: Adding driver name : %s'%kwargs['driver_name'])
            driver_key = UmBoostLib.UMKey('drvname',kwargs['driver_name'])
            boostSetPropertyObj.append(driver_key)       
        
        if int(kwargs['properties_count']) > 1:
            for i in range(int(kwargs['properties_count'])):
                logging.info('iWarp M Property : %s, Value : %s'%(kwargs['propname'][i],kwargs['value'][i]))
                temp_key = UmBoostLib.UMKey(kwargs['propname'][i],kwargs['value'][i])
                boostSetPropertyObj.append(temp_key)
        else:
            logging.info('iWarp S Property : %s, Value : %s'%(kwargs['propname'],kwargs['value']))
            temp_key = UmBoostLib.UMKey(kwargs['propname'],kwargs['value'])
            boostSetPropertyObj.append(temp_key)
        
        logging.info('iWarp Settings Set Properties - Waiting for Boost - sid :%s , ip: %s, ostype: %s \
                     '%(self.sid,self.ip, kwargs['ostype']))
        status = boostSetPropertyObj.setProperty(self.sid, self.ip, 8, int(kwargs['ostype']))
        #status = 0
        logging.info('iWarp Settings Set Properties Status : %s'%status)
        
        if status == 0:
            return 0
        elif status == -2:
            return -2
        else:
            return -1
        
    def get_iwarp_driver_details(self,data):
        obj = DriverDetails(data['sid'], data['ip'],  data['type'])
        driver_data = obj.is_iwarp_driver_loaded(int(data['ostype']))
        
        if driver_data == -2 or driver_data == -1:
            return driver_data
        else:
            return simplejson.dumps(driver_data)