from UmBoostLib import PList, PropsList, KList
import UmBoostLib

import settings
logging = settings.get_logger()

class IscsiTargetStackGlobals:
    
    def __init__(self, sid, ip):
         self.sid = sid
         self.ip = ip

    def get_iscsi_tsg(self, ostype, type):
        self.type = type
        logging.info('iSCSI Target Stack Globals Get Properties : Sid : %s, Ip : %s, ostype : %s'%( self.sid, self.ip, ostype ))
        self.boostplistobj = PList()
        self.boostpropslistobj = PropsList()
        status = self.boostpropslistobj.getiSCSITargetGlobals( self.boostplistobj, self.sid, self.ip, int(ostype) )
        logging.info('iSCSI Target Stack Globals Get Properties status: %s'%status)

        if status == 0:
            return self.generate_html()
        elif status == -2 or status == 67 or status == 318:
            return status
        else:
            return -1
        
    def get_obj(self):
        for i in range(0,len(self.boostplistobj)):
            yield self.boostpropslistobj.get(self.boostplistobj,i)

    '''
    CELL TYPES
    NONE = 0,
    TEXT_EDITOR=1,
    BOOL_EDITOR=2,
    NUMBER_EDITOR=3,
    CHOICE_EDITOR=4,
    RANGE_EDITOR=5
    '''
    
    def generate_html(self):
        
        if self.type == 'desktop':
            head_html = '<ul class="horizontal head_ul">\
                         <li class="desc"><h2>Description</h2></li>\
                         <li class="value"><h2 class="bg_none" >Value</h2></li>\
                         </ul>'
        else:
            head_html = '<div class="ui-grid-a heading" data-theme="b" >\
                        <div class="ui-block-a ui-bar-b center desc">Description</div>\
                        <div class="ui-block-b ui-bar-b center value">Value</div>\
                        </div>'        
       
        html_list = []
        
        for i in self.get_obj():
            if self.type == 'desktop':
                html_list.append('<ul class="horizontal content_tbl clear from_server">\
                            <li class="desc">%s</li>'%i.propDesc)
            else:
                html_list.append('<div class=" ui-grid-a grid from_server">\
                    <div class="ui-block-a iter desc">%s</div>'%i.propDesc)
                        
            if not i.isEditable:
                if self.type == 'desktop':    
                    html_list.append('<li class="bg_none value" >%s</li></ul>'%i.value)
                else:
                    html_list.append('<div class="ui-block-b value iter" >%s</div></div>'%i.value)
            else:
                if self.type == 'desktop': 
                    html_list.append('<li class="bg_none value" >')
                else:
                    html_list.append('<div class="ui-block-b value iter" >')
                if int(i.cellType) == 4:
                    html_list.append('<select autocomplete="off" class="value_%s" title="%s" >'%(i.value,i.propName))
                    choices = i.range.split('#')
                    for j in choices:
                        if i.value.upper().strip() == j.upper().strip():
                            html_list.append('<option value="%s" selected="selected">%s</option>'%(j, j))
                        else:
                            html_list.append('<option value="%s" >%s</option>'%(j, j))
                    html_list.append('</select>')
                elif int(i.cellType) == 2:
                    html_list.append('<select autocomplete="off" class="value_%s" title="%s" >'\
                                    %(i.value,i.propName))
                    if (i.value).strip() == 'Yes':
                        html_list.append('<option value="Yes" selected="selected">Yes</option>\
                                     <option value="No">No</option></select>')
                    else:
                        html_list.append('<option value="Yes" >Yes</option>\
                                     <option value="No" selected="selected">No</option></select>')
                else:
                    html_list.append(i.value)
                
                if self.type == 'desktop': 
                    html_list.append('</li></ul>')
                else:
                    html_list.append('</div></div>')
    
        html = ''.join(html_list)
        return head_html + html
    
    def set_iscsi_tsg(self, kwargs):
        
        boostSetPropertyObj = KList()
        success = True
        
        logging.debug('iSCSI Initiator TP Umkey - stack :25 ')
        stack = UmBoostLib.UMKey('stack', '25')
        boostSetPropertyObj.append(stack)
        
        logging.debug('iSCSI Initiator TP Umkey - Node Index :0 ')
        index = UmBoostLib.UMKey('nodeindex', '0')
        boostSetPropertyObj.append(index)
        
        if int(kwargs['properties_count']) > 1:
            for i in range(int(kwargs['properties_count'])):
                logging.debug('iSCSI TSG Umkey - propname :%s , value : %s :'%( kwargs['propname'][i], kwargs['value'][i] ))
                prop_key = UmBoostLib.UMKey(kwargs['propname'][i],kwargs['value'][i])
                boostSetPropertyObj.append(prop_key)
        else:
            logging.debug('iSCSI TSG Umkey - propname :%s , value : %s :'%( kwargs['propname'], kwargs['value'] ))
            prop_key = UmBoostLib.UMKey(kwargs['propname'],kwargs['value'])
            boostSetPropertyObj.append(prop_key)
        
        logging.info('iSCSI TSG Set Property - Waiting for Boost - sid :%s , ip: %s, ostype : %s \
                     '%(self.sid,self.ip, kwargs['ostype']))
        status = boostSetPropertyObj.setProperty(self.sid, self.ip, 4, int(kwargs['ostype']))
        logging.info('iSCSI TSG Set Property Status : %s'%status)
        
        if status == 0:
            return 0
        elif status == -2:
            return -2
        else:
            return -1
        
