from UmBoostLib import targetList, tarList, PList, PropsList, iscsiTarInfo, KList
import simplejson, UmBoostLib, settings
logging = settings.get_logger()

class IscsiTargetProperties:
    
    def __init__(self, sid, ip):
         self.sid = sid
         self.ip = ip

    def get_targets(self, data):
        self.type = data['type']
        logging.info('iSCSI Target Properties Get Targets List: Sid : %s, Ip : %s'%( self.sid, self.ip ))
        self.boosttarlistobj = tarList()
        self.boosttargetlistobj = targetList()
        status = self.boosttargetlistobj.getiSCSITargetInformation( self.boosttarlistobj, self.sid, self.ip )
        logging.info('iSCSI Target Properties Get Targets List status: %s'%status)

        if status == 0:
            return self.generate_tagetlist_html()
        elif status == -2 or status == 67:
            return status
        else:
            return -1
        
    def generate_tagetlist_html(self):
        
        ip_id = self.ip.replace('.','_')
        
        if self.type == 'desktop':
            unique_parent_id = '#iscsi_target_content__incend__%s .iscsi_target_properties_tab'%ip_id
        else:
            unique_parent_id = '#i_tp__%s__incend'%ip_id;
        
        loader_selector = '%s .initializer'%unique_parent_id
        select_head_html = '<select onchange="i_tp_get_properties(\'%s\', \'%s\', \'%s\', \'%s\')" class="targets_list" >\
                            <option value="null">Select One..</option>\
                            '%(unique_parent_id, ip_id, self.ip, loader_selector)
        select_html = '%s%s</select>'
        option_html = '<option value="%s" title = "%s" >%s</option>'
        
        html_list = []
        for i in range(0,len(self.boosttarlistobj)):
            if self.boosttargetlistobj.get(self.boosttarlistobj,i).TargetName.strip() != '':
                html_list.append(option_html%( i+1, self.boosttargetlistobj.get(self.boosttarlistobj,i).CurrentState, self.boosttargetlistobj.get(self.boosttarlistobj,i).TargetName))
        #html_list = [  option_html%( i+1, self.boosttargetlistobj.get(self.boosttarlistobj,i).CurrentState, self.boosttargetlistobj.get(self.boosttarlistobj,i).TargetName ) for i in range(0,len(self.boosttarlistobj)) ] 
        html = ''.join(html_list)
        select_html = select_html%(select_head_html, html)
        return select_html
    
    
    def get_properties(self, index, ostype, type):
        self.type = type
        logging.info('iSCSI Target Properties Get Properties List: Sid : %s, Ip : %s, NodeIndex : %s, ostype : %s, ashin'%( self.sid, self.ip, index, ostype))
        self.boostplistobj = PList()
        self.boosttargetpropsobj = PropsList()
        status = self.boosttargetpropsobj.getiSCSITargetProperties( self.boostplistobj, self.sid, self.ip, int(index), int(ostype))
        logging.info('iSCSI Target Properties Get Properties List status - ashin: %s'%status)

        if status == 0:
            self.return_data = {}
            self.return_data['properties'] = self.generate_properties_html()
            return simplejson.dumps(self.return_data)
        elif status == -2:
            return -2
        else:
            return -1
    
    def get_properties_obj(self):
        for i in range(0,len(self.boostplistobj)):
            yield self.boosttargetpropsobj.get(self.boostplistobj,i)    
        
        '''
    CELL TYPES
    NONE = 0,
    TEXT_EDITOR=1,
    BOOL_EDITOR=2,
    NUMBER_EDITOR=3,
    CHOICE_EDITOR=4,
    RANGE_EDITOR=5
    '''
    def generate_properties_html(self):
        
        height = 50
        if self.type == 'desktop':
            head_html = '<ul class="horizontal head_ul">\
                     <li class="desc"><h2>Property</h2></li>\
                     <li class="value"><h2 class="bg_none" >Value</h2></li>\
                     </ul>'
        else:
            head_html = '<div class="ui-grid-a heading" data-theme="b" >\
                        <div class="ui-block-a ui-bar-b center desc">Description</div>\
                        <div class="ui-block-b ui-bar-b center value">Value</div>\
                        </div>'
        
        
        html_list = []
        for i in self.get_properties_obj():
            
            height += 32
            if self.type == 'desktop':
                html_list.append('<ul class="horizontal content_tbl clear from_server">\
                        <li class="desc">%s</li>'%i.propDesc)
            else:
                html_list.append('<div class=" ui-grid-a grid from_server">\
                    <div class="ui-block-a iter desc">%s</div>'%i.propDesc)
            
            if not i.isEditable:
                if self.type == 'desktop':    
                    html_list.append('<li class="bg_none value" >%s</li></ul>'%i.value)
                else:
                    html_list.append('<div class="ui-block-b value iter" >%s</div></div>'%i.value)
            else:
                if self.type == 'desktop': 
                    html_list.append('<li class="bg_none value" >')
                else:
                    html_list.append('<div class="ui-block-b value iter" >')
                if int(i.cellType) == 1:
                    html_list.append('<input autocomplete="off" type = "text" class="text text_editor" name=\'value_%s\' title="%s" value=\'%s\' >'%(i.value,i.propName,i.value))
                elif int(i.cellType) == 2:
                    if i.value == 'Yes':
                        html_list.append('<select autocomplete="off" class="value_1" title="%s" >'%(i.propName))
                        html_list.append('<option value="1" selected="selected">Yes</option>\
                                     <option value="0">No</option></select>')
                    else:
                        html_list.append('<select autocomplete="off" class="value_0" title="%s" >'%(i.propName))
                        html_list.append('<option value="1" >Yes</option>\
                                     <option value="0" selected="selected">No</option></select>')
                elif int(i.cellType) == 3:
                    if self.type == 'desktop': 
                        html_list.append('<div class="number_editor">\
                                            <div class="fl_left input_wr">')
                        
                        min = i.range.split('#')[0]
                        max = i.range.split('#')[1]
                        inc = i.stepby
    
                        html_list.append('<input type = "text" name=\'value_%s\' title="%s" value=\'%s\' class="text xsml" onblur="number_editor($(this),%s,%s,%s,\'blur\')" onkeyup="number_editor($(this),%s,%s,%s,\'validate\')"  />\
                                        </div>'%(i.value,i.propName,i.value,max,min,inc,max,min,inc))
                        html_list.append('<div class="controls"><div class="up_arrow_wr">\
                                        <img src="/images/black/up_arrow_hover.png" onclick = "number_editor($(this),%s,%s,%s,\'inc\')"  />\
                                        </div><div class= "down_arrow_wr">\
                                        <img src="/images/black/down_arrow_hover.png" onclick = "number_editor($(this),%s,%s,%s,\'dec\')" />\
                                        </div></div></div>'%(max,min,inc,max,min,inc))
                    else:
                        min = i.range.split('#')[0]
                        max = i.range.split('#')[1]
                        html_list.append('<input autocomplete="off" type = "text" class="text text_editor" name=\'value_%s\' title="%s" value=\'%s\'\
                                         onchange="number_editor($(this), %s, %s)" >'%(i.value,i.propName,i.value, min, max))
                elif int(i.cellType) == 4:
                    html_list.append('<select autocomplete="off" class=\'value_%s\' title="%s" >'%(i.value,i.propName))
                    choices = i.range.split('#')
                    for j in choices:
                        if i.value == j:
                            html_list.append('<option value="%s" selected="selected">%s</option>'%(j, j))
                        else:
                            html_list.append('<option value="%s" >%s</option>'%(j, j))
                    html_list.append('</select>')
                else:
                    html_list.append(i.value)
                
                if self.type == 'desktop': 
                    html_list.append('</li></ul>')
                else:
                    html_list.append('</div></div>')
    
        self.return_data['height'] = height
        html = ''.join(html_list)
        return head_html + html

    def update_target_status(self, index, action):
        logging.info('iSCSI Target Properties %s Target: Sid : %s, Ip : %s, NodeIndex : %s'%( action, self.sid, self.ip, index))
        boostupdatestatusobj = iscsiTarInfo()

        if action == 'start':
            status = boostupdatestatusobj.StartTarget( self.sid, self.ip, int(index))
            logging.info('iSCSI Target Properties start Target status: %s'%(status))
        elif action == 'stop':
            status = boostupdatestatusobj.StopTarget( self.sid, self.ip, int(index))
            logging.info('iSCSI Target Properties stop Target status: %s'%(status))
        elif action == 'delete':
            status = boostupdatestatusobj.DeleteTarget( self.sid, self.ip, int(index))
            logging.info('iSCSI Target Properties delete Target status: %s'%(status))
        else:
            status = -1
            logging.info('iSCSI Target Properties Target Updates: Invalid "action"')
        
        if status == 0:
            return status
        elif status == -2:
            return -2
        else:
            return -1
    

    def set_target_props(self, kwargs):
        
        boostSetPropertyObj = KList()
        success = True
        
        logging.debug('iSCSI Initiator TP Umkey - stack :25 ')
        stack = UmBoostLib.UMKey('stack', '25')
        boostSetPropertyObj.append(stack)
        
        logging.debug('iSCSI Initiator TP Umkey - Node Index :%s '%( kwargs['index'] ))
        index = UmBoostLib.UMKey('nodeindex', kwargs['index'])
        boostSetPropertyObj.append(index)
        
        if int(kwargs['properties_count']) > 1:
            for i in range(int(kwargs['properties_count'])):
                logging.debug('iSCSI TP Umkey - propname :%s , value : %s :'%( kwargs['propname'][i], kwargs['value'][i] ))
                prop_key = UmBoostLib.UMKey(kwargs['propname'][i],kwargs['value'][i])
                boostSetPropertyObj.append(prop_key)
        else:
            logging.debug('iSCSI TP Umkey - propname :%s , value : %s :'%( kwargs['propname'], kwargs['value'] ))
            prop_key = UmBoostLib.UMKey(kwargs['propname'],kwargs['value'])
            boostSetPropertyObj.append(prop_key)
        
        logging.info('iSCSI TP Set Property - Waiting for Boost - sid :%s , ip: %s, ostype : %s \
                     '%(self.sid, self.ip, kwargs['ostype']))
        status = boostSetPropertyObj.setProperty(self.sid, self.ip, 4, int(kwargs['ostype']))
        logging.info('iSCSI TP Set Property Status : %s'%status)
        
        if status == 0:
            return 0
        elif status == -2:
            return -2
        else:
            return -1
        