from UmBoostLib import targetList, tarList, TPGList, PGList, PGInfo
import simplejson, UmBoostLib

import logging
import settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)


class IscsiTargetPgUpdate:
    
    def __init__(self, sid, ip):
         self.sid = sid
         self.ip = ip

    def get_targets(self, data):
        self.req_type = data['req_type']
        logging.info('iSCSI Target PG Update Get Targets List: Sid : %s, Ip : %s'%( self.sid, self.ip ))
        self.boosttarlistobj = tarList()
        self.boosttargetlistobj = targetList()
        status = self.boosttargetlistobj.getiSCSITargetInformation( self.boosttarlistobj, self.sid, self.ip )
        logging.info('iSCSI Target PG Update Get Targets List status: %s'%status)

        if status == 0:
            return self.generate_tagetlist_html()
        elif status == -2 or status == 67:
            return status
        else:
            return -1
        
    def generate_tagetlist_html(self):
        
        ip_id = self.ip.replace('.','_')
        if self.req_type == 'desktop':
            unique_parent_id = '#pg_content__incend__%s .pg_content_update_tp_tab'%ip_id
        else:
            unique_parent_id = '#pg_update__%s__incend'%ip_id
            
        loader_selector = '%s .initializer'%unique_parent_id
        select_head_html = '<select onchange="i_pu_get_portals(\'%s\', \'%s\', \'%s\', \'%s\')" class="targets_list" >\
                            <option value="null">Select One..</option>\
                            '%(unique_parent_id, ip_id, self.ip, loader_selector)
        select_html = '%s%s</select>'
        option_html = '<option value="%s" title = "%s" >%s</option>'
        html_list = [  option_html%( i+1, self.boosttargetlistobj.get(self.boosttarlistobj,i).CurrentState, self.boosttargetlistobj.get(self.boosttarlistobj,i).TargetName ) for i in range(0,len(self.boosttarlistobj)) ] 
        html = ''.join(html_list)
        select_html = select_html%(select_head_html, html)
        return select_html    
    
    def get_pg_list(self, index, ostype, req_type):
        self.req_type = req_type
    
        logging.info('iSCSI Target PG Update Get Portal List: Sid : %s, Ip : %s, Index : %s, ostype : %s'%( self.sid, self.ip, index, ostype))
        self.boost_pglist_obj = PGList()
        self.boost_tpglist_obj = TPGList()
        status = self.boost_tpglist_obj.getiSCSITargetPGs( self.boost_pglist_obj, self.sid, self.ip, int(index), int(ostype) )
        logging.info('iSCSI Target PG Update Get Portal List status: %s'%status)

        if status == 0:
            return self.generate_portals_html()
        elif status == -2:
            return -2
        else:
            return -1
    
    def generate_portals_html(self):
        
        ip_id = self.ip.replace('.','_')
        
        if self.req_type == 'desktop':
            unique_parent_id = '#pg_content__incend__%s .pg_content_update_tp_tab'%ip_id
        else:
            unique_parent_id = '#pg_update__%s__incend'%ip_id
        
        loader_selector = '%s .initializer'%unique_parent_id
        pg_event_fn = 'i_pu_pg_select($(this), \'%s\', \'%s\', \'%s\', \'%s\')'%(unique_parent_id, ip_id, self.ip, loader_selector)
        
        pg_ul_html = '<ul class="hover_ul select_ul">%s</ul>'
        pg_li_html = '<li class="pg hover_li position_%s" onclick="%s" name="position_%s" >%s%s%s%s%s%s%s</li>'
        pg_ip_html = '<input type="hidden" class = "ip" value="%s" />'        
        pg_time_html = '<input type="hidden" class = "time" value="%s" />'
        pg_redirecttag_html = '<input type="hidden" class = "redirecttag" value="%s" />'
        pg_tcp_str_html = '<input type="hidden" class = "tcp" value="%s" />'
        pg_string_html = '<input type="hidden" class = "pgstring" value="%s" />'
        pg_string_order_html = '<input type="hidden" class = "pgstring_order" value="%s" />'
        
        html_list = []
        for i in range(0, len(self.boost_pglist_obj)):
            tag = i+1
            ip = self.boost_tpglist_obj.get(self.boost_pglist_obj,i).IPAddress
            port = self.boost_tpglist_obj.get(self.boost_pglist_obj,i).Port
            pgstr = str(tag)+'@'+str(ip)+':'+str(port)
            pgstr_input = str(ip)+':'+str(port)
            html_list.append(pg_li_html%( str(i+1), pg_event_fn, str(i+1), pgstr,
                                    pg_ip_html %  ip,
                                    pg_time_html %  str(self.boost_tpglist_obj.get(self.boost_pglist_obj,i).TimeOut),
                                    pg_redirecttag_html %  str(i+1),
                                    str(pg_tcp_str_html %  port), 
                                    pg_string_html % pgstr_input,
                                    pg_string_order_html % pgstr,
                                   ))
        html = ''.join(html_list)
        pg_ul_html = pg_ul_html%(html)
        return pg_ul_html
    
    def set_pglist_order(self, index, pgnamestr):
        logging.info('iSCSI Target PG Update Set PGLIST List Order: Sid : %s, Ip : %s, index : %s, pgnamestr : %s'%( self.sid, self.ip, index, pgnamestr ))
        self.boost_pginfo_obj = PGInfo()
        status = self.boost_pginfo_obj.ReorderPortals( self.sid, self.ip, int(index), pgnamestr )
        logging.info('iSCSI Target PG Update Set PGLIST Order: %s'%status)

        if status == 0:
            return 0
        elif status == -2:
            return -2
        else:
            return -1
    
    def delete_pg(self, index, pgnamestr):
        logging.info('iSCSI Target PG Update Delete Portal : Sid : %s, Ip : %s, index : %s, lunnamestr : %s'%( self.sid, self.ip, index, pgnamestr ))
        self.boost_pginfo_obj = PGInfo()
        status = self.boost_pginfo_obj.DeletePG( self.sid, self.ip, int(index), pgnamestr )
        #status = 0
        logging.info('iSCSI Target PG Update Delete Portal: %s'%status)

        if status == 0:
            return 0
        elif status == -2:
            return -2
        else:
            return -1