from UmBoostLib import iscsiTarInfo
from DriverInfoFile import DriverDetails
import settings
logging = settings.get_logger()

class IscsiTargetCreation:
    
    def __init__(self, sid, ip):
         self.sid = sid
         self.ip = ip

    def create_iscsi_target(self, data):
        logging.info('iSCSI Target Create : Sid : %s, Ip : %s, TargetName: %s, Target alias: %s'%( self.sid, self.ip, data['targetname'], data['targetalias'] ))
        self.boost_tarinfo_obj = iscsiTarInfo()
        status = self.boost_tarinfo_obj.AddTargetNode( self.sid, self.ip, data['targetname'], data['targetalias'] )
        logging.info('iSCSI Target Create status: %s'%status)
        return status        
    
    def get_driver_status(self, data):
        
        dr_obj = DriverDetails( self.sid, self.ip, 'desktop')
        status_dict = dr_obj.is_driver_loaded(dr_name="chiscsi_base")
        status_dict1 = dr_obj.is_driver_loaded(dr_name="chiscsi_t4")

        if status_dict['status'] == -2 or status_dict1['status'] == -2:
            return -2
        elif status_dict['status'] == -1 or status_dict1['status'] == -1:
            return -1
        elif status_dict['loaded'] == -6 and status_dict1['loaded'] == -6:
            return 6
        elif status_dict['loaded'] == 0 or status_dict1['loaded'] == 0:
            return 0