from UmBoostLib import targetList, tarList, PGInfo

import logging
import settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)

class IscsiTargetAddPortal:
    
    def __init__(self, sid, ip):
         self.sid = sid
         self.ip = ip

    def get_targets(self,):
        logging.info('iSCSI Target Add Portal: Sid : %s, Ip : %s'%( self.sid, self.ip ))
        self.boosttarlistobj = tarList()
        self.boosttargetlistobj = targetList()
        status = self.boosttargetlistobj.getiSCSITargetInformation( self.boosttarlistobj, self.sid, self.ip )
        logging.info('iSCSI Target Add Portal: %s'%status)

        if status == 0:
            return self.generate_tagetlist_html()
        elif status == -2 or status == 67:
            return status
        else:
            return -1
        
    def generate_tagetlist_html(self):
        
        select_html = '<select class="targets_list" onchange="$(this).removeClass(\'error\')" >\
                            <option value="null">Select One..</option>%s\
                            </select>'
        option_html = '<option value="%s" >%s</option>'
        html_list = [ option_html%( i+1, self.boosttargetlistobj.get(self.boosttarlistobj,i).TargetName ) for i in range(0,len(self.boosttarlistobj)) ] 
        html = ''.join(html_list)
        select_html = select_html%( html )
        return select_html   
    
    def save_portal(self, index, portal_string):
        logging.info('iSCSI Target Add Portal : Sid : %s, Ip : %s, Index : %s, PGstring : %s'%( self.sid, self.ip, index, portal_string ))
        boost_pginfo_obj = PGInfo()
        status = boost_pginfo_obj.AddPG( self.sid, self.ip, int(index), portal_string )
        #status = 0
        logging.info('iSCSI Target Add New Portal status: %s'%status)

        if status == 0:
            return 0
        elif status == -2:
            return -2
        else:
            return -1
    