from UmBoostLib import targetList, tarList, TACLList, ACLList, ACLInfo
import settings
logging = settings.get_logger()

class IscsiTargetAclUpdate:
    
    def __init__(self, sid, ip):
         self.sid = sid
         self.ip = ip

    def get_targets(self, data):
        self.req_type = data['req_type']
        logging.info('iSCSI Target Acl Update Get Targets List: Sid : %s, Ip : %s'%( self.sid, self.ip ))
        self.boosttarlistobj = tarList()
        self.boosttargetlistobj = targetList()
        status = self.boosttargetlistobj.getiSCSITargetInformation( self.boosttarlistobj, self.sid, self.ip )
        logging.info('iSCSI Target Acl Update Get Targets List status: %s'%status)

        if status == 0:
            return self.generate_tagetlist_html()
        elif status == -2 or status == 67:
            return status
        else:
            return -1
        
    def generate_tagetlist_html(self):
        
        ip_id = self.ip.replace('.','_')
        if self.req_type == 'desktop':
            unique_parent_id = '#acl_content__incend__%s .acl_content_update_acl_tab'%ip_id
        else:
            unique_parent_id = '#acl_update__%s__incend'%ip_id
        
        loader_selector = '%s .initializer'%unique_parent_id
        select_head_html = '<select onchange="i_aclu_get_acl(\'%s\', \'%s\', \'%s\', \'%s\')" class="targets_list" >\
                            <option value="null">Select One..</option>\
                            '%(unique_parent_id, ip_id, self.ip, loader_selector)
        select_html = '%s%s</select>'
        option_html = '<option value="%s" title = "%s" >%s</option>'
        html_list = [  option_html%( i+1, self.boosttargetlistobj.get(self.boosttarlistobj,i).CurrentState, self.boosttargetlistobj.get(self.boosttarlistobj,i).TargetName ) for i in range(0,len(self.boosttarlistobj)) ] 
        html = ''.join(html_list)
        select_html = select_html%(select_head_html, html)
        return select_html    
    
    def get_acl_list(self, index, ostype, req_type):
        self.req_type = req_type
    
        logging.info('iSCSI Target ACL Update Get ACL List: Sid : %s, Ip : %s, Index : %s, ostype : %s'%( self.sid, self.ip, index, ostype))
        self.boost_acllist_obj = ACLList()
        self.boost_tacllist_obj = TACLList()
        status = self.boost_tacllist_obj.getiSCSITargetACL( self.boost_acllist_obj, self.sid, self.ip, int(index), int(ostype) )
        logging.info('iSCSI Target ACL Update Get ACL List status: %s, len : %s'%(status, len(self.boost_acllist_obj)))

        if status == 0:
            return self.generate_acl_html()
        elif status == -2:
            return -2
        else:
            return -1
    
    def generate_acl_html(self):
        
        ip_id = self.ip.replace('.','_')
        if self.req_type == 'desktop':
            unique_parent_id = '#acl_content__incend__%s .acl_content_update_acl_tab'%ip_id
        else:
            unique_parent_id = '#acl_update__%s__incend'%ip_id
        
        loader_selector = '%s .initializer'%unique_parent_id
        acl_event_fn = 'i_aclu_acl_select($(this), \'%s\', \'%s\', \'%s\', \'%s\')'%(unique_parent_id, ip_id, self.ip, loader_selector)
        
        acl_ul_html = '<ul class="hover_ul select_ul">%s</ul>'
        acl_li_html = '<li class="acl hover_li" onclick="%s" >%s%s%s%s%s%s</li>'
        acl_iqn_html = '<input type="hidden" class = "iqn" value="%s" />'        
        acl_sip_html = '<input type="hidden" class = "sip" value="%s" />'
        acl_dip_html = '<input type="hidden" class = "dip" value="%s" />'
        acl_lunp_html = '<input type="hidden" class = "lunp" value="%s" />'
        acl_string_html = '<input type="hidden" class = "acltring" value="%s" />'
        
        html_list = [ acl_li_html%( acl_event_fn, self.boost_tacllist_obj.get(self.boost_acllist_obj,i).ACLStr,
                                    acl_iqn_html %  self.boost_tacllist_obj.get(self.boost_acllist_obj,i).IQN_Name,
                                    acl_sip_html %  self.boost_tacllist_obj.get(self.boost_acllist_obj,i).S_IPAddr_List,
                                    acl_dip_html %  self.boost_tacllist_obj.get(self.boost_acllist_obj,i).D_IPAddr_List,
                                    acl_lunp_html %  self.boost_tacllist_obj.get(self.boost_acllist_obj,i).LunList, 
                                    acl_string_html % self.boost_tacllist_obj.get(self.boost_acllist_obj,i).ACLStr,
                                   ) for i in range(0, len(self.boost_acllist_obj)) ]
        
        '''
        acl_ul_html = '<ul class="hover_ul">%s</ul>'
        acl_li_html = '<li class="acl hover_li" onclick="%s" >%s%s%s%s%s%s</li>'
        acl_iqn_html = '<input type="hidden" class = "iqn" value="%s" />'        
        acl_sip_html = '<input type="hidden" class = "sip" value="%s" />'
        acl_dip_html = '<input type="hidden" class = "dip" value="%s" />'
        acl_lunp_html = '<input type="hidden" class = "lunp" value="%s" />'
        acl_string_html = '<input type="hidden" class = "acltring" value="%s" />'
        
        html_list = [ acl_li_html%( acl_event_fn, 'acl...',
                                    acl_iqn_html %  'iqn name',
                                    acl_sip_html %  '10.192.12 sip',
                                    acl_dip_html %  '10.3929 dip',
                                    acl_lunp_html %  'lun', 
                                    acl_string_html % 'acl string',
                                   ) for i in range(5) ]
                                   '''
        
        html = ''.join(html_list)
        acl_ul_html = acl_ul_html%(html)
        return acl_ul_html
    
    def delete_acl(self, index, aclnamestr):
        logging.info('iSCSI Target ACL Update Delete ACL: Sid : %s, Ip : %s, index : %s, aclnamestr : %s'%( self.sid, self.ip, index, aclnamestr ))
        self.boost_aclinfo_obj = ACLInfo()
        status = self.boost_aclinfo_obj.DeleteACL( self.sid, self.ip, int(index), aclnamestr )
        #status = 0
        logging.info('iSCSI Target ACL Update Delete ACL: %s'%status)

        if status == 0:
            return 0
        elif status == -2:
            return -2
        else:
            return -1