#From Project
from UmBoostLib import initiatorList, iniList, iSCSIInitiatorInfo, PList, PropsList, KList
import UmBoostLib
import settings
logging = settings.get_logger()

#From Python
import simplejson

class IscsiInitiatorNodes:
    
    def __init__(self, sid, ip):
         self.sid = sid
         self.ip = ip
    
    def get_initiators(self, ostype, type):
       self.type = type.strip() 
       self.boostIniListobj = iniList()
       self.boostInitiatorListobj = initiatorList()
       
       if ostype.strip() == '1':
           '''stack = 23'''
           logging.info('iSCSI Initiator - Get Initiator : waiting for response from UMboost sid : %s , UmServerIP : %s , Stack : 23\
                       '%( self.sid, self.ip ))
           status = self.boostInitiatorListobj.getiSCSIInitiatorInfo(self.boostIniListobj, self.sid, self.ip, 23)
           logging.info('iSCSI Initiator - Get Initiator Status : %s'%( status ))
           html = ''

           if status == 0:
                html += self.generate_initiator_html('23')
           elif status == -2:
               return status
           
           '''stack = 24'''
           self.boostIniListobj = iniList()
           self.boostInitiatorListobj = initiatorList()
           
           logging.info('iSCSI Initiator - Get Initiator : waiting for response from UMboost sid : %s , UmServerIP : %s , Stack : 24\
                       '%( self.sid, self.ip ))
           status = self.boostInitiatorListobj.getiSCSIInitiatorInfo(self.boostIniListobj, self.sid, self.ip, 24)
           logging.info('iSCSI Initiator - Get Initiator Status : %s'%( status ))
           
           if status == 0:
                html += self.generate_initiator_html('24')
           elif status == -2:
                return status
            
           '''stack = 27'''
           self.boostIniListobj = iniList()
           self.boostInitiatorListobj = initiatorList()
           
           logging.info('iSCSI Initiator - Get Initiator : waiting for response from UMboost sid : %s , UmServerIP : %s , Stack : 27\
                       '%( self.sid, self.ip ))
           status = self.boostInitiatorListobj.getiSCSIInitiatorInfo(self.boostIniListobj, self.sid, self.ip, 27)
           logging.info('iSCSI Initiator - Get Initiator Status : %s'%( status ))
           
           if status == 0:
                html += self.generate_initiator_html('27')
                return html
           elif status == -2 or status == 67:
               return status
           else:
                return html
       
       elif ostype.strip() == '2':
           '''stack = 22'''
           logging.info('iSCSI Initiator - Get Initiator : waiting for response from UMboost sid : %s , UmServerIP : %s , Stack : 22\
                       '%( self.sid, self.ip ))
           status = self.boostInitiatorListobj.getiSCSIInitiatorInfo(self.boostIniListobj, self.sid, self.ip, 22)
           logging.info('iSCSI Initiator - Get Initiator Status : %s'%( status ))

           if status == 0:
                return self.generate_initiator_html('22')
           elif status == -2 or status == 1 or status == 67:
                return status
           elif status == 19:
                return 1
       elif ostype.strip() == '3':
           '''stack = 26'''
           logging.info('iSCSI Initiator - Get Initiator : waiting for response from UMboost sid : %s , UmServerIP : %s , Stack : 26\
                       '%( self.sid, self.ip ))
           status = self.boostInitiatorListobj.getiSCSIInitiatorInfo(self.boostIniListobj, self.sid, self.ip, 26)
           logging.info('iSCSI Initiator - Get Initiator Status : %s'%( status ))

           if status == 0:
                return self.generate_initiator_html('26')
           elif status == -2 or status == 1 or status == 67:
                return status
           elif status == 19:
                return 1
       
       
    def generate_initiator_html(self, stack):
        
        ip_id = self.ip.replace('.','_')
        
        if self.type == 'desktop':
            unique_parent_id = '#iscsi_initiator_content__incend__%s .iscsi_initiator_nodes_tab'%ip_id
        else:
            unique_parent_id = '#i_nodes__%s__incend'%ip_id;
        html = ''
        
        ''' For Mobile '''
        head_html = '<select onchange="i_nd_initiator_select( \'%s\', $(this), \'%s\', \'%s\' )">\
                    <option value="">Select One..</option>'%(unique_parent_id, ip_id, self.ip)
        select_html = head_html+'%s</select>'
        
        for i in range(0, len(self.boostIniListobj)):
            
            if stack == '22':
                initiator_name = 'Open iSCSI'
            elif stack == '23':
                initiator_name = 'Microsoft iSCSI'
            elif stack == '24':
                initiator_name = 'Chelsio iSCSI'
            elif stack == '26':
                initiator_name = 'Solaris iSCSI'
            elif stack == '27':
                initiator_name = 'Chelsio Windows T4 iSCSI'
                
            if stack == '24' or stack == '27':
                initiator_desc = "%s: %s [ %s ]"%( initiator_name, self.boostInitiatorListobj.get(self.boostIniListobj,i).desc,
                        self.boostInitiatorListobj.get(self.boostIniListobj,i).mac )
            else:
                initiator_desc = "%s: %s"%( initiator_name, self.boostInitiatorListobj.get(self.boostIniListobj,i).InitiatorName )
            
            if self.type == 'desktop':
                html += '<li onclick = "i_nd_initiator_select( \'%s\', $(this), \'%s\', \'%s\' )" class="initiators" >%s\
                        <input type="hidden" value="%s" class="status" />\
                        <input type="hidden" value="%s" class="stack" />\
                        <input type="hidden" value="%s" class="index" /></li>\
                        '%( unique_parent_id, ip_id, self.ip, initiator_desc,
                            self.boostInitiatorListobj.get(self.boostIniListobj,i).CurrentState, stack, i+1 )
            else:
                html += '<option class="initiators" value="%s__%s__%s" >%s</option>\
                        '%( self.boostInitiatorListobj.get(self.boostIniListobj,i).CurrentState, stack, i+1, initiator_desc )
        
        if self.type == 'mobile':
            return select_html%html
        else:
            return html
    
    def update_initiator(self, stack, index, action):
        
       boostObj = iSCSIInitiatorInfo()
       logging.info('iSCSI Initiator %s - : waiting for response from UMboost sid : %s , UmServerIP : %s , Stack : %s, Index : %s\
                   '%( action, self.sid, self.ip, stack, index))
       if action == 'enable':
           status = boostObj.StartIniNode(self.sid, self.ip, int(stack), int(index))
       elif action == 'disable':
           status = boostObj.StopIniNode(self.sid, self.ip, int(stack), int(index))
       elif action == 'delete':
           status = boostObj.DeleteIniNode(self.sid, self.ip, int(stack), int(index))
       logging.info('iSCSI Initiator %s Status : %s'%( action, status ))
       
       if status == 0:
            return status
       elif status == -2:
           return -2
       else:
           return -1
       
    def get_initiator_properties(self, stack, index, ostype, type):
        self.type = type.strip()
        logging.info('iSCSI Initiator Get Properties: waiting for response from UMboost Sid : %s , Ip : %s , Stack : %s, Index : %s, ostype : %s\
                     '%(self.sid, self.ip, stack, index, ostype))
        self.boostPlistObj = PList()
        self.boostPropslistObj = PropsList()
        status = self.boostPropslistObj.getiSCSIInitiatorProperties(self.boostPlistObj, self.sid, self.ip, int(stack), int(index), int(ostype))
        logging.info('iSCSI Initiator Get Properties status: %s'%status)
        
        if status == 0:
            return self.generate_properties_html()
        elif status == -2:
            return -2
        else:
            return -1

    def get_obj(self):
        for i in range(0,len(self.boostPlistObj)):
            yield self.boostPropslistObj.get(self.boostPlistObj,i)
             
    def generate_properties_html(self):
        
        if self.type == 'desktop':
            head_html = '<ul class="horizontal head_ul">\
                     <li class="desc"><h2>Description</h2></li>\
                     <li class="value"><h2 class="bg_none" >Value</h2></li>\
                     </ul>'
        else:
            head_html = '<div class="ui-grid-a heading" data-theme="b" >\
                            <div class="ui-block-a ui-bar-b center">Property</div>\
                            <div class="ui-block-b ui-bar-b center">Value</div>\
                        </div>'
        
        html_list = []
        height = 93
        for i in self.get_obj():
            
            height += 33
            if self.type == 'desktop':
                html_list.append('<ul class="horizontal content_tbl clear from_server">\
                            <li class="desc">%s</li>'%i.propDesc)
            else:
                html_list.append('<div class=" ui-grid-a grid from_server">\
                    <div class="ui-block-a iter desc">%s</div>'%i.propDesc)
                        
            if not i.isEditable:
                if self.type == 'desktop':    
                    html_list.append('<li class="bg_none value" >%s</li></ul>'%i.value)
                else:
                    html_list.append('<div class="ui-block-b value iter" >%s</div></div>'%i.value)
            else:
                if self.type == 'desktop': 
                    html_list.append('<li class="bg_none value" >')
                else:
                    html_list.append('<div class="ui-block-b value iter" >')
                
                if int(i.cellType) == 1:
                    html_list.append('<input autocomplete="off" type = "text" class="text text_editor" name="value_%s" title="%s" value="%s" >'%(i.value,i.propName,i.value))
                elif int(i.cellType) == 2:
                    html_list.append('<select autocomplete="off" class="value_%s" title="%s" name="bool" >'%(i.value,i.propName))
                    if i.value == 1 or i.value == 'Yes':
                        html_list.append('<option value="1" selected="selected">Yes</option>\
                                     <option value="0">No</option></select>')
                    else:
                        html_list.append('<option value="1" >Yes</option>\
                                     <option value="0" selected="selected">No</option></select>')
                elif int(i.cellType) == 3:
                    if self.type == 'desktop': 
                        html_list.append('<div class="number_editor">\
                                            <div class="fl_left input_wr">')
                        
                        min = i.range.split('#')[0]
                        max = i.range.split('#')[1]
                        inc = i.stepby
    
                        html_list.append('<input type = "text" name="value_%s" title="%s" value="%s" class="text xsml" onblur="number_editor($(this),%s,%s,%s,\'blur\')" onkeyup="number_editor($(this),%s,%s,%s,\'validate\')"  />\
                                        </div>'%(i.value,i.propName,i.value,max,min,inc,max,min,inc))
                        html_list.append('<div class="controls"><div class="up_arrow_wr">\
                                        <img src="/images/black/up_arrow_hover.png" onclick = "number_editor($(this),%s,%s,%s,\'inc\')"  />\
                                        </div><div class= "down_arrow_wr">\
                                        <img src="/images/black/down_arrow_hover.png" onclick = "number_editor($(this),%s,%s,%s,\'dec\')" />\
                                        </div></div></div>'%(max,min,inc,max,min,inc))
                    else:
                        min = i.range.split('#')[0]
                        max = i.range.split('#')[1]
                        html_list.append('<input autocomplete="off" type = "text" class="text text_editor" name="value_%s" title="%s" value="%s"\
                                         onchange="number_editor($(this), %s, %s)" >'%(i.value,i.propName,i.value, min, max))
                elif int(i.cellType) == 4:
                    html_list.append('<select autocomplete="off" class="value_%s" title="%s" name="choice" >'%(i.value,i.propName))
                    choices = i.range.split('#')
                    for j in choices:
                        if i.value == j:
                            html_list.append('<option value="%s" selected="selected">%s</option>'%(j, j))
                        else:
                            html_list.append('<option value="%s" >%s</option>'%(j, j))
                    html_list.append('</select>')
                else:
                    html_list.append(i.value)
                
                if self.type == 'desktop': 
                    html_list.append('</li></ul>')
                else:
                    html_list.append('</div></div>')
    
        html = ''.join(html_list)
        
        data = {}
        data['height'] = height
        data['html'] = head_html + html
        return simplejson.dumps(data)
    
    def set_initiator_properties(self,kwargs):
        
        boostSetPropertyObj = KList()
        success = True
        
        logging.info('iSCSI Initiator nodes Umkey - stack :%s '%( kwargs['stack'] ))
        stack = UmBoostLib.UMKey('stack', kwargs['stack'])
        boostSetPropertyObj.append(stack)
        
        logging.info('iSCSI Initiator nodes Umkey - Node Index :%s '%( kwargs['index'] ))
        index = UmBoostLib.UMKey('nodeindex', kwargs['index'])
        boostSetPropertyObj.append(index)
        
        if int(kwargs['properties_count']) > 1:
            for i in range(int(kwargs['properties_count'])):
                logging.info('iSCSI Initiator nodes Umkey - propname :%s , value : %s :'%( kwargs['propname'][i], kwargs['value'][i] ))
                prop_key = UmBoostLib.UMKey(kwargs['propname'][i],kwargs['value'][i])
                boostSetPropertyObj.append(prop_key)
        else:
            logging.info('iSCSI Initiator nodes umkey - propname :%s , value : %s :'%( kwargs['propname'], kwargs['value']))
            prop_key = UmBoostLib.UMKey(kwargs['propname'],kwargs['value'])
            boostSetPropertyObj.append(prop_key)
        
        logging.info('iSCSI Initiator nodes Set Properties - Waiting for Boost - sid :%s , ip: %s, ostype : %s \
                     '%(self.sid, self.ip, kwargs['ostype']))
        status = boostSetPropertyObj.setProperty(self.sid, self.ip, 5, int(kwargs['ostype']))
        logging.info('iSCSI Initiator nodes  Set Properties Status : %s'%status)
        
        if status == 0:
            return 0
        elif status == -2:
            return -2
        else:
            return -1
    
    def add_iqn(self, stack, nodename):
        
       boostObj = iSCSIInitiatorInfo()
       logging.info('iSCSI Initiator Add IQN - : waiting for response from UMboost sid : %s , UmServerIP : %s , Stack : %s, nodename : %s\
                   '%( self.sid, self.ip, stack, nodename))
       status = boostObj.AddIniNode(self.sid, self.ip, int(stack), nodename)
       #status = 0
       logging.info('iSCSI Initiator Add IQN : %s'%( status ))
       
       if status == 0:
            return status
       elif status == -2:
           return -2
       else:
           return -1
    