from UmBoostLib import TDiscList, tarDiscList, TPGList, PGList, TarInformation, iniList, initiatorList, PropsList, PList, ipList, iniIPList
import settings, simplejson, utils
logging = settings.get_logger()

class IscsiInitiatorDiscoverTargets:
    
    def __init__(self, sid, ip, req_type):
         self.sid = sid
         self.ip = ip
         self.req_type = req_type
    
    def get_targets(self, stack, ostype):
       self.ostype = ostype
    
       #Windows - looping through each node for stack 24 - chelsio since it may also contain targets. 
       if stack == '24' or stack == '27':
           nodes_status = self.get_nodes(stack, True)
           logging.info('Win specific Returned Node Value : %s'%nodes_status)
           if nodes_status == -2 or nodes_status == -1:
               if nodes_status == -6:
                    return 1
               return nodes_status
           else:
               targets_html = ''
               portals_html = ''
               for i in range(1,nodes_status+1):
                   self.boostTDiscListobj = TDiscList()
                   self.boosttDiscListobj = tarDiscList()
                   status = self.boostTDiscListobj.getTargets( self.boosttDiscListobj, self.sid, self.ip, int(stack), i, int(self.ostype) )
                   logging.info('Win getTargets Status : %s , for node index : %s, len : %s'%(status, i, len(self.boosttDiscListobj) ))
                   if status == 0: 
                       self.portal_index = i
                       targets_dict = self.generate_targets_html(stack)
                       targets_html += targets_dict['targets_html']
                       portals_html += targets_dict['portals_html']
                   elif status == -2:
                       return -2
                   else:
                       continue
               data = {}
               data['targets_html'] = ''.join(targets_html)
               data['portals_html'] = ''.join(portals_html)
               return data 
       else:
           logging.info('iSCSI Initiator Targets - Get Targets : waiting for response from UMboost sid : %s , UmServerIP : %s , Stack : %s, nodeIdx : 1\
                   '%( self.sid, self.ip, stack ))
           self.boostTDiscListobj = TDiscList()
           self.boosttDiscListobj = tarDiscList()
           status = self.boostTDiscListobj.getTargets( self.boosttDiscListobj, self.sid, self.ip, int(stack), 1, int(self.ostype) )
           logging.info('iSCSI Initiator Targets - Get Targets Status : %s, len : %s'%( status, len(self.boosttDiscListobj) ))

           if status == 0: 
               return self.generate_targets_html(stack)
           #179 = No targets
           elif status == 179:
               return 1
           elif status == -2 or status == 1 or status == 67:
               return status
           else:
               return -1
       
    def generate_targets_html(self, stack):

        targets_html = []
        portals_html = []                
        for i in range(0, len(self.boosttDiscListobj)):
            target_name = self.boostTDiscListobj.get(self.boosttDiscListobj,i).TargetName 
            target_class = target_name.replace('.','_')+'_'+stack
            targets_html.append( '<li class="targets %s">%s</li>\
                                  '%(target_class, target_name))
            portals_html.append(self.get_portal_html(stack, target_name, target_class))
            
        data = {}
        data['targets_html'] = ''.join(targets_html)
        data['portals_html'] = ''.join(portals_html)
        return data 
    
    
    def get_portal_html(self, stack, target_name, target_class):
       
       self.boostTPGListobj = TPGList()
       self.boostPGListobj = PGList()
       ip_id = self.ip.replace('.','_')
       
       if stack == '24' or stack == '27':
           node_idx = self.portal_index
       else:
           node_idx = 1
       
       if self.req_type == 'desktop':
           unique_parent_id = '#iscsi_initiator_content__incend__%s .iscsi_initiator_dt_tab'%(ip_id)
       else:
           unique_parent_id = '#i_dt__%s__incend'%ip_id
            
       logging.info('iSCSI Initiator Targets - Get Portals : waiting for response from UMboost sid : %s , UmServerIP : %s ,\
                     Stack : %s, nodeIdx : %s, tarName : %s, discFlag : 1, ostype : %s\
                     '%( self.sid, self.ip, stack, node_idx, target_name, self.ostype ))
       status = self.boostTPGListobj.getiSCSIDiscoveredTargetPGs( self.boostPGListobj, self.sid, self.ip, int(stack), int(node_idx), target_name, 1, int(self.ostype) )
       logging.info('iSCSI Initiator Targets - Get Portals Status : %s'%( status ))
       
       portals_html = []
       for i in range(0, len(self.boostPGListobj)):
           p_ip = self.boostTPGListobj.get(self.boostPGListobj,i).IPAddress
           p_port = self.boostTPGListobj.get(self.boostPGListobj,i).Port
           portals_html.append('<li class="portals" onclick="i_dt_show_target(\'%s\', \'%s\', \'%s\', $(this) )" >Target - %s : %s\
                               <input type="hidden" value="%s" class="stack" />\
                               <input type="hidden" value="%s:%s" class="portal" />\
                               <input type="hidden" value="%s" class="index" /></li>\
                               '%( target_class, unique_parent_id, self.ip, p_ip, p_port, stack, p_ip, p_port, node_idx) )
       
       return ''.join(portals_html)
           
    
    def discover_targets(self, stack, portal, initIp, initiator_index, ostype):
        
        validate_ip = portal.split(':')[0]
        logging.info('IP Validate : %s'%validate_ip)
        ip_validate = utils.validate_ip(validate_ip, 1)
        logging.info('IP Validate status %s'%ip_validate)
        if ip_validate == -1:
            return -6
        
        self.boostTDiscListobj = TDiscList()
        self.boosttDiscListobj = tarDiscList()
        logging.info('iSCSI Initiator Targets - Discover Targets : waiting for response from UMboost sid : %s , UmServerIP : %s , Stack : %s, Portal: %s,\
                    nodeIdx : %s, initIp : %s, ostype : %s\
                   '%( self.sid, self.ip, stack, portal, initiator_index, initIp, ostype ))
        status = self.boostTDiscListobj.discoverTargets(self.boosttDiscListobj, self.sid, self.ip, int(stack), int(initiator_index), portal, '', int(ostype))
        logging.info('iSCSI Initiator Targets - Discover Targets Status : %s'%( status ))
        if status == 0: 
           return status
        elif status == 16 or status == -2:
           return status
        else:
           return -1
       
    def delete_targets(self, stack, portal, index):
       
       boostTargetDeleteobj = TarInformation()
       logging.info('iSCSI Initiator Targets - Delete Target : waiting for response from UMboost sid : %s , UmServerIP : %s , Stack : %s, Index : %s, Portal: %s\
                   '%( self.sid, self.ip, stack, index, portal ))
       status = boostTargetDeleteobj.DeleteTarget( self.sid, self.ip, int(stack), int(index), portal )
       logging.info('iSCSI Initiator Targets - Delete Target : %s'%( status ))
       
       if status == 0: 
           return status
       elif status == -2:
           return status
       else:
           return -1   
       
    #shared by IscsiInitiatorTargetsFile and This current discovered file
    def get_nodes(self, stack, is_direct):
        
       self.boostIniListobj = iniList()
       self.boostInitiatorListobj = initiatorList()
       logging.info('iSCSI Initiator Targets - Get Nodes for windows : waiting for response from UMboost sid : %s , UmServerIP : %s , Stack : %s\
                   '%( self.sid, self.ip, stack ))
       status = self.boostInitiatorListobj.getiSCSIInitiatorInfo(self.boostIniListobj, self.sid, self.ip, int(stack))
       logging.info('iSCSI Initiator Targets - Get Nodes for windows : %s, len : %s'%( status, len(self.boostIniListobj) ))
       
       if status == 1 or status == -2:
           if is_direct and status == 1:
               return -6
           return status
       elif status == 0:
           if is_direct:
               return len(self.boostIniListobj)
           else:
               return self.generate_nodes_html(stack)
       elif status == 19:
	   return status
       else:
           return -1
       
    def generate_nodes_html(self, stack):
        
        ip_id = self.ip.replace('.', '_')
        
        if self.req_type == 'desktop':
           unique_parent_id = '#iscsi_initiator_content__incend__%s .iscsi_initiator_dt_tab'%ip_id
        else:
           unique_parent_id = '#i_dt__%s__incend'%ip_id
        
        loader_selector = unique_parent_id + ' .initializer'
        
        if self.req_type == 'desktop':
            html = '<select onchange="i_dt_get_ip(\'%s\', \'%s\', \'%s\', false, $(this))" >'%( unique_parent_id, loader_selector, ip_id )
        else:
            html = '<select onchange="i_dt_get_ip(\'%s\', \'%s\', $(this))" >'%( unique_parent_id, ip_id )
            
        html += '<option value="" >Select One..</option>'
        
        if stack == '22':
            initiator_name = 'Open iSCSI'
        elif stack == '23':
            initiator_name = 'Microsoft iSCSI'
        elif stack == '24':
            initiator_name = 'Chelsio iSCSI'
        elif stack == '26':
            initiator_name = 'Solaris iSCSI'
        elif stack == '27':
            initiator_name = 'Chelsio T4 iSCSI'
            
        for i in range(0, len(self.boostIniListobj)):
            
            if stack == '24' or stack == '27':
                initiator_desc = "%s: %s [ %s ]"%( initiator_name, self.boostInitiatorListobj.get(self.boostIniListobj,i).desc,
                        self.boostInitiatorListobj.get(self.boostIniListobj,i).mac )
            else:
                initiator_desc = "%s: %s"%( initiator_name, self.boostInitiatorListobj.get(self.boostIniListobj,i).InitiatorName )
            
            html += '<option value="%s" >%s</option>'%( i+1, initiator_desc )
            
        html += '</select>'
        return html 
    
    def get_iplist(self, stack, index):
        
       self.boostiniIPListobj = iniIPList()
       self.boostipListobj = ipList()
       logging.info('iSCSI Initiator Targets - Get Ip list for windows : waiting for response from UMboost sid : %s , UmServerIP : %s , Stack : %s, Index : %s\
                   '%( self.sid, self.ip, stack, index ))
       status = self.boostiniIPListobj.getiSCSIIniIPInformation(self.boostipListobj, self.sid, self.ip, int(stack), int(index))
       logging.info('iSCSI Initiator Targets - Get Ip list for windows : %s'%( status ))
       
       if status == -2:
           return status
       elif status == 0:
            return self.generate_iplist_html()
       else:
           return -1
      
    def generate_iplist_html(self):
        
        html = '<select class="i_dt_iplist" onchange="$(this).removeClass(\'error\')">'
        for i in range(0, len(self.boostipListobj)):
            value = self.boostiniIPListobj.get(self.boostipListobj,i).Address
            html += '<option value="%s" >%s</option>'%( value, value )
        
        html += '</select>'
        return html
