from UmBoostLib import CnList, ConnList
import simplejson
import logging
import settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)

class GetConnections:
    
    def __init__(self, sid, host_ip, req_type):
        self.sid = sid
        self.host_ip = host_ip
        self.req_type = req_type
        self.CnBoostObj = CnList()
        self.ConListBoostObj = ConnList()


    def get_connections(self):

        logging.debug('Network TroubleShooting: Get Connections waiting for response from UMboost sid : %s, HostIp :%s'%( self.sid, self.host_ip ))
        status = self.ConListBoostObj.getConnList( self.CnBoostObj, self.sid,  self.host_ip )
        logging.debug('Network TroubleShooting: Get Connections status: %s'%status)
        
        if status == 0:
            return  self.generate_html()
        elif status == -2:
            return -2
        else:
            return -1

    def get_obj(self):
        for i in range(0,len(self.CnBoostObj)):
            yield self.ConListBoostObj.get(self.CnBoostObj,i)

    def generate_html(self):
        
        if self.req_type == 'desktop': 
            grid_head_html = '<ul class="horizontal head_ul">\
                                <li class="sml protocol"><h2>Protocol</h2></li>\
                                <li class="sml localaddress"><h2>Local Address</h2></li>\
                                <li class="sml remoteaddress"><h2>Remote Address</h2></li>\
                                <li class="sml state"><h2>State</h2></li>\
                                <li class="large offload"><h2 class="bg_none" >Offload</h2></li>\
                             </ul>'
            protocol_html = '<ul class="horizontal content_tbl clear_left from_server"><li class="sml protocol">%s </li>'
            localaddr_html = '<li class="sml localaddress">%s </li>'
            remoteaddr_html = '<li class="sml remoteaddress">%s </li>'
            state_html = '<li class="sml state">%s </li>'
            offload_html = '<li class="sml offload">%s </li></ul>'
        else:
            grid_head_html = '<div class="ui-grid-d heading" data-theme="b" >\
                                <div class="ui-block-a ui-bar-b center sno">Protocol</div>\
                                <div class="ui-block-b ui-bar-b center log">Local Address</div>\
                                <div class="ui-block-c ui-bar-b center log">Remote Address</div>\
                                <div class="ui-block-d ui-bar-b center log">State</div>\
                                <div class="ui-block-e ui-bar-b center log">Offload</div>\
                             </div>'
            logs_html = '<div class=" ui-grid-d grid ui-body-d">\
                            <div class="ui-block-a center proto">%s</div>\
                            <div class="ui-block-b center la">%s</div>\
                            <div class="ui-block-c center ra">%s</div>\
                            <div class="ui-block-d center st">%s</div>\
                            <div class="ui-block-e center off">%s</div>\
                        </div>'
        
        whole_html = '%s%s%s%s%s'
        height = 485
        html_list = []
        for i in self.get_obj():
            if self.req_type == 'desktop': 
               html_list.append(whole_html%( protocol_html %  i.protocol , localaddr_html %  i.localAddr, remoteaddr_html %  i.remoteAddr,
               state_html %  i.state , offload_html %  i.offload
                ))
               height += 32
            else:
                html_list.append(logs_html%( i.protocol , i.localAddr, i.remoteAddr, i.state , i.offload )) 
        
        html = ''.join(html_list)
        
        json_data = {}
        json_data['html'] = grid_head_html + html
        json_data['height'] = height
        return simplejson.dumps(json_data)
