#from UmBoostLib import foiscsi_ini_boost, foiscsi_boost_session, foiscsi_boost_discovery_db
from UmBoostLib import foiscsi_ini_boost, foiscsi_boost_session
from Constants import BOOST_END_OF_DATA, FOISCSI_CONSTANTS
import settings, simplejson
logging = settings.get_logger()

class FoiscsiInitiatorSession:
    
    def __init__(self, **kwargs):
        self.sid = kwargs['sid']
        self.ip = kwargs['ip']
        self.req_type = kwargs['req_type']

    def get_session_ids(self, data):
        
        logging.info('Foiscsi Session issue session: sid : %s, ip : %s, cmd : session devno=%s op=show '%(self.sid, self.ip, data['devno']))
        self.mainObj = foiscsi_ini_boost()
        status = self.mainObj.foiscsi_execute_command(self.sid, self.ip, "session devno=%s op=show"%( data['devno'] ))
        logging.info('Foiscsi Session issue session cmd status : %s'%(status))
        
        return_data = {}
        if status == 0:
            logging.info('Foiscsi get Session Params')
            self.SessionObj = foiscsi_boost_session()
            status = self.mainObj.foiscsi_get_session(self.SessionObj)
            logging.info('Foiscsi get Session Params status : %s'%(status))
            
            unique_parent_id = '#foiscsi_initiator_content__incend__%s .foiscsi_initiator_sessions_tab'%( self.ip.replace('.','_') )
            getdata = 'sid=%s&ip=%s&req_type=desktop'%( self.sid, self.ip )
            if status == 0:
                more_data = True
                sess_id_html = '<select class="sessid" onchange="fo_get_sid_values(\'%s\',\'%s\', $(this))">\
                                <option value="">Select One..</option>'%(unique_parent_id, getdata)
                option_html = '<option value="%s">%s</option>'
                
                while more_data:
                    logging.info('while loop begin')
                    logging.info('while loop begin sess_idx : %s'%self.SessionObj.sess_idx)
                    sess_id_html += option_html%( self.SessionObj.sess_idx, self.SessionObj.sess_idx)
                    status = self.mainObj.foiscsi_get_session(self.SessionObj)
                    logging.info('while loop begin staus : %s'%status)
                    if status == BOOST_END_OF_DATA:
                        more_data = False
                sess_id_html += '</select>'
                return_data['status'] = 0
                return_data['html'] = sess_id_html
                return simplejson.dumps(return_data)
            elif status == -2:
                return_data['status'] = -2
                return simplejson.dumps(return_data)
            elif FOISCSI_CONSTANTS.has_key(status):
                return_data['status'] = 6
                return_data['msg'] = FOISCSI_CONSTANTS[status]
                return simplejson.dumps(return_data)
            else:
                return_data['status'] = -1
                return simplejson.dumps(return_data)
        elif status == -2:
            return_data['status'] = -2
            return simplejson.dumps(return_data)
        elif FOISCSI_CONSTANTS.has_key(status):
            return_data['status'] = 6
            return_data['msg'] = FOISCSI_CONSTANTS[status]
            return simplejson.dumps(return_data)
        else:
            return_data['status'] = -1
            return simplejson.dumps(return_data)
        
    def get_sessid_values(self, data):
        
        return_data = {}
        logging.info('Foiscsi Session issue session: sid : %s, ip : %s, cmd : session devno=%s op=show'%(self.sid, self.ip, data['devno']))
        self.mainObj = foiscsi_ini_boost()
        status = self.mainObj.foiscsi_execute_command(self.sid, self.ip, "session devno=%s op=show"%( data['devno']))
        logging.info('Foiscsi Session issue session cmd status : %s'%(status))
        
        if status == 0:
            logging.info('Foiscsi get Session Params')
            self.SessionObj = foiscsi_boost_session()
            status = self.mainObj.foiscsi_get_session(self.SessionObj)
            logging.info('Foiscsi get Session Params status : %s'%(status))
            
            if status == 0:
                loop = True
            
                while loop:
                    if str(self.SessionObj.sess_idx).strip() == data['sess_id'].strip():
                        return_data['status'] = '0'
                        return_data['sess_idx'] = self.SessionObj.sess_idx
                        return_data['inode_idx'] = self.SessionObj.inode_idx
                        return_data['init_ip'] = self.SessionObj.init_ip
                        return_data['targ_ip'] = self.SessionObj.targ_ip
                        return_data['targ_port'] = self.SessionObj.targ_port
                        return_data['tpgt'] = self.SessionObj.tpgt
                        return_data['port'] = self.SessionObj.port
                        return_data['state'] = self.SessionObj.state
                        return_data['targ_name'] = self.SessionObj.targ_name
                        return_data['targ_alias'] = self.SessionObj.targ_alias
                        return simplejson.dumps(return_data)
                    else:
                        logging.info('Foiscsi get Session Params')
                        status = self.mainObj.foiscsi_get_session(self.SessionObj)
                        if status == 0:
                            loop = True
                        elif status == 100:
                            loop = False
                        else:
                            loop = False
                        logging.info('Foiscsi get Session Params status : %s'%(status))
            
            if FOISCSI_CONSTANTS.has_key(status):
                return_data['status'] = 6
                return_data['msg'] = FOISCSI_CONSTANTS[status]
                return simplejson.dumps(return_data)
            elif status == -2:
                return_data['status'] = '-2'
                return simplejson.dumps(return_data)
            else:
                return_data['status'] = '-1'
                return simplejson.dumps(return_data)
        elif status == -2:
            return_data['status'] = '-2'
            return simplejson.dumps(return_data)
        elif FOISCSI_CONSTANTS.has_key(status):
            return_data['status'] = 6
            return_data['msg'] = FOISCSI_CONSTANTS[status]
            return simplejson.dumps(return_data)
        else:
            return_data['status'] = '-1'
            return simplejson.dumps(return_data)
        
    def sess_login(self, data):
    
        cmd = 'session devno=%s op=login nodeid=%s targetname=%s sip=%s dip=%s dport=%s'%( data['devno'], data['nodeid'], data['targetname'], data['sip'], data['dip'], data['dport'] )
        if data['authm'].strip() != '':
            cmd += ' authm=%s'%data['authm'].strip()
            
        if data['policy'].strip() != '':
            cmd += ' policy=%s'%data['policy'].strip()
            
        if data['tusername'].strip() != '':
            cmd += ' tusername=%s'%data['tusername'].strip()
            
        if data['tsec'].strip() != '':
            cmd += ' tsec=%s'%data['tsec'].strip()
        
        logging.info('Foiscsi Session issue login: sid : %s, ip : %s, cmd : %s'%(self.sid, self.ip, cmd))
        self.mainObj = foiscsi_ini_boost()
        status = self.mainObj.foiscsi_execute_command(self.sid, self.ip, cmd)
        logging.info('Foiscsi Session issue login cmd status : %s'%(status))
        
        return_data = {}
        if status == 0 or status == -2:
            return_data['status'] = status
            return simplejson.dumps(return_data)
        elif FOISCSI_CONSTANTS.has_key(status):
            return_data['status'] = 6
            return_data['msg'] = FOISCSI_CONSTANTS[status]
            return simplejson.dumps(return_data)
        else:
            return_data['status'] = -1
            return simplejson.dumps(return_data)

    def sess_logout(self, data):

        logging.info('Foiscsi Session logout: sid : %s, ip : %s, cmd : session devno=%s op=logout nodeid=%s sid=%s '
                     %(self.sid, self.ip,data['devno'], data['nodeid'], data['sess_id']))
        self.mainObj = foiscsi_ini_boost()
        status = self.mainObj.foiscsi_execute_command(self.sid, self.ip, "session devno=%s op=logout nodeid=%s sid=%s"
                                                      %( data['devno'], data['nodeid'], data['sess_id'] ))
        logging.info('Foiscsi Session logout cmd status : %s'%(status))
        
        return_data = {}
        if status == 0 or status == -2:
            return_data['status'] = status
            return simplejson.dumps(return_data)
        elif FOISCSI_CONSTANTS.has_key(status):
            return_data['status'] = 6
            return_data['msg'] = FOISCSI_CONSTANTS[status]
            return simplejson.dumps(return_data)
        else:
            return_data['status'] = -1
            return simplejson.dumps(return_data)
'''        
    def get_discover_data(self, data):
        
        logging.info('Foiscsi Session get discover data: sid : %s, ip : %s, cmd : discoverydb op=show'%(self.sid, self.ip))
        disc_db = foiscsi_boost_discovery_db()
        self.mainObj = foiscsi_ini_boost()
        status = self.mainObj.foiscsi_execute_command(self.sid,self.ip,"discoverydb op=show")
        logging.info('Foiscsi Session get discover data : %s'%(status))
        
        return_data = {}
        if status == 0:
            
            logging.info('Foiscsi Session retrieve discovered data : %s'%(disc_db.discovery_db))
            status = self.mainObj.foiscsi_get_discovery_db(disc_db)
            disc_data = disc_db.discovery_db
            logging.info('Foiscsi Session retrieve discovered data : %s'%(disc_data))
            
            if status == 0:
                return_data['status'] = status
                return_data['disc_str'] = self.get_disc_str(disc_data, data)
                return simplejson.dumps(return_data)
            else:
                return_data['status'] = 7
                return simplejson.dumps(return_data)
        elif status == -2:
            return_data['status'] = status
            return simplejson.dumps(return_data)
        elif FOISCSI_CONSTANTS.has_key(status):
            return_data['status'] = 6
            return_data['msg'] = FOISCSI_CONSTANTS[status]
            return simplejson.dumps(return_data)
        else:
            return_data['status'] = -1
            return simplejson.dumps(return_data)
        
    def get_disc_str(self, disc_data, data):
        #dev,daddr,saddr,nodeid,port
        temp_list = disc_data.split('\n')
        for i in temp_list:
            if len(i.split(',')) == 5:
                if data['devno'].strip() == i.split(',')[0].strip() and data['nodeid'].strip() == i.split(',')[3].strip():
                    #"daddr:saddr:port"
                    return "%s:%s:%s"%(i.split(',')[1], i.split(',')[2], i.split(',')[4])
        return 'empty'
'''
    
