from fcoeutils import FCoEAdapInfoLst, FCoEAdapUtils, FCoEPortUtils, FCoEPortInfoLst
from fcoeutils import FCoELunUtils, FCoELunInfoLst, FCoEStatUtils, FCoEStats, FCoEControl
import simplejson, UmBoostLib, settings

logging = settings.get_logger()

class Fcoe:
    
    def __init__(self, sid , ip):
        self.sid = sid
        self.ip = ip

    def list_adapters(self):
        
        fcoeAgmObj = FCoEAdapInfoLst(self.sid, self.ip)
        fcoeObj = FCoEAdapUtils()
        logging.info('Fcoe List Adapters: waiting for response from UMboost sid : %s , IP : %s'%(self.sid,self.ip))
        status = fcoeObj.FcoeListAdapters( fcoeAgmObj )
        logging.info('Fcoe List Adapters: result %s'%(status))
        
        if status == 0:
            return fcoeAgmObj
        elif status == -2:
            return status
        else:
            return -1
        
    def list_local_ports(self, adapName):
        
        fcoeAgmObj = FCoEPortInfoLst(self.sid, self.ip)
        fcoeObj = FCoEPortUtils()
        logging.info('Fcoe List Local Ports: waiting for response from UMboost adapName : %s '%( adapName ))
        status = fcoeObj.FcoeListLPorts( fcoeAgmObj, adapName )
        logging.info('Fcoe List Local Ports: result %s'%(status))
        
        if status == 0:
            return fcoeAgmObj
        elif status == -2:
            return status
        else:
            return 1
            
    def list_remote_ports(self, adapName, lportindex):
        
        fcoeAgmObj = FCoEPortInfoLst(self.sid, self.ip)
        fcoeObj = FCoEPortUtils()
        logging.info('Fcoe List Remote Ports: waiting for response from UMboost adapName : %s, lportindex : %s'%( adapName, lportindex ))
        status = fcoeObj.FcoeListRPorts( fcoeAgmObj, adapName, str(lportindex))
        logging.info('Fcoe List Remote Ports: result %s'%(status))
        
        if status == 0:
            return fcoeAgmObj
        elif status == -2:
            return status
        else:
            return 1
        
    def list_luns(self, adapName, lPortId, rPortId, ostype):
        
        fcoeAgmObj = FCoELunInfoLst(self.sid, self.ip)
        fcoeObj = FCoELunUtils()
        logging.info('Fcoe List Luns: waiting for response from UMboost adapName : %s, lPortId : %s, rPortId : %s, ostype : %s'%( adapName, lPortId, rPortId, ostype ))
        status = fcoeObj.FcoeListLuns( fcoeAgmObj, adapName, str(lPortId), str(rPortId), int(ostype))
        logging.info('Fcoe List Luns: result %s'%(status))
        
        if status == 0:
            return fcoeAgmObj
        elif status == -2:
            return status
        else:
            return 1
        
    def list_vports(self, adapName, lPortId):
        
        fcoeAgmObj = FCoEPortInfoLst(self.sid, self.ip)
        fcoeObj = FCoEPortUtils()
        logging.info('Fcoe Virtual Ports: waiting for response from UMboost adapName : %s, lPortId : %s'%( adapName, lPortId ))
        status = fcoeObj.FcoeListVPorts( fcoeAgmObj, adapName, str(lPortId))
        logging.info('Fcoe Virtual Ports: result %s'%(status))
        
        if status == 0:
            return fcoeAgmObj
        elif status == -2:
            return status
        else:
            return 1
        
    def list_vrports(self, adapName, lPortId, vPortId):
        
        fcoeAgmObj = FCoEPortInfoLst(self.sid, self.ip)
        fcoeObj = FCoEPortUtils()
        logging.info('Fcoe Virtual R Ports: waiting for response from UMboost adapName : %s, lPortId : %s, vPortId : %s'%( adapName, lPortId, vPortId ))
        status = fcoeObj.FcoeListVPortRPorts( fcoeAgmObj, adapName, str(lPortId), str(vPortId))
        logging.info('Fcoe Virtual R Ports: result %s'%(status))
        
        if status == 0:
            return fcoeAgmObj
        elif status == -2:
            return status
        else:
            return 1
        
    def list_vluns(self, adapName, lPortId, vPortId, rPortId, ostype):
        
        fcoeAgmObj = FCoELunInfoLst(self.sid, self.ip)
        fcoeObj = FCoELunUtils()
    	logging.info('Fcoe List VLuns: waiting for response from UMboost adapName : %s, lPortId : %s, vPortId : %s, rPortId : %s, osType : %s'%( adapName, lPortId, vPortId, rPortId, ostype ))
        status = fcoeObj.FcoeListVPortLuns( fcoeAgmObj, adapName, str(lPortId), str(vPortId), str(rPortId), int(ostype))
        logging.info('Fcoe List VLuns: result %s'%(status))
        
        if status == 0:
            return fcoeAgmObj
        elif status == -2:
            return status
        else:
            return 1
        
    def get_fport_statistics(self,adapname,fportindex):
        logging.info('FPort Statistics:  waiting for response from UMboost sid : %s , IP : %s , adapname : %s , Index : %s'%(self.sid, self.ip, adapname, fportindex))
        self.boostStatsAgmtObj = FCoEStats(self.sid, self.ip)
        self.boostStatsObj = FCoEStatUtils()
        status = self.boostStatsObj.FcoeLPortStats(self.boostStatsAgmtObj, adapname, fportindex)
        logging.info('FPort Statistics status: %s'%status)
        
        if status == 0:
            return self.generate_stats_html()
        elif status == -2:
            return -2
        else:
            return -1
        
    def generate_stats_html(self):
        
        height = 41
        head_html = '<ul class="horizontal head_ul">\
                        <li><h2>Property</h2></li>\
                        <li><h2 class="bg_none" >Value</h2></li>\
                     </ul>'
        
        top_html = '<ul class="horizontal content_tbl clear from_server">\
                    <li class="label">%s</li>'
        bottom_html = '<li class="bg_none port_stats_rec" >%s</li></ul>'
    
        whole_html = '%s%s'
        html_list = []
        for i in range(1,len(self.boostStatsAgmtObj)):
            html_list.append(whole_html%( top_html %  self.boostStatsAgmtObj[i].propName , bottom_html %  self.boostStatsAgmtObj[i].value ))
            height += 32
    
        html = ''.join(html_list)
        data = {}
        data['html'] = head_html + html
        data['height'] = height 
        return simplejson.dumps(data)
        
    def create_npiv(self, data):
        logging.info('FCOE Create NPIV: waiting for response from UMboost sid : %s , IP : %s , adapname : %s , parentWWPN : %s, \
                    parentWWNN : %s, npiVmode : %s, vPortWWPN : %s, vPortWWNN : %s\
                    '%(self.sid, self.ip, data['adapname'], data['parentWWPN'], data['parentWWNN'], data['npiVmode'], data['vPortWWPN'], data['vPortWWNN']))
        self.boostNpivObj = FCoEControl(self.sid, self.ip)
        status = self.boostNpivObj.FcoeCreateNPIV(self.sid, self.ip, data['adapname'], data['parentWWPN'], data['parentWWNN'], data['npiVmode'], data['vPortWWPN'], data['vPortWWNN'])
        logging.info('FCOE Create NPIV status: %s'%status)
        
        if status == 0 or status == -2:
            return status
        else:
            return -1
        
    def get_frport_attributes(self,data):
        self.remote_ports_obj = self.list_remote_ports(data['adapname'], data['flportindex'])
        
        if self.remote_ports_obj == -2 or self.remote_ports_obj == -1:
            return self.remote_ports_obj
        else:
            return self.generate_rport_attr_html(int(data['frport_index']))
        
    def get_fvrport_attributes(self,data):
        self.remote_ports_obj = self.list_vrports(data['adapname'], data['flportindex'], data['fvport_index'])
        
        if self.remote_ports_obj == -2 or self.remote_ports_obj == -1:
            return self.remote_ports_obj
        else:
            return self.generate_rport_attr_html(int(data['fvrport_index']))
        
    def generate_rport_attr_html(self, frport_index):
        
        html = '<ul class="horizontal head_ul">\
                    <li><h2>Property</h2></li>\
                    <li><h2 class="bg_none" >Value</h2></li>\
                 </ul>'
       
        html += '<ul class="horizontal content_tbl clear">\
                    <li class="label">FC ID</li>\
                    <li class="bg_none nport" >%s</li>\
                 </ul>'%self.remote_ports_obj[frport_index].PortAttr.PortFcId 
                 #PortFcId
                 
        html += '<ul class="horizontal content_tbl clear">\
                    <li class="label">State</li>\
                    <li class="bg_none state" >%s</li>\
                 </ul>'%self.remote_ports_obj[frport_index].PortAttr.PortState 
        
        html += '<ul class="horizontal content_tbl clear">\
                    <li class="label">NodeWWN</li>\
                    <li class="bg_none nodewwn" >%s</li>\
                 </ul>'%self.remote_ports_obj[frport_index].PortAttr.NodeWWN
                 
        html += '<ul class="horizontal content_tbl clear">\
                    <li class="label">PortWWN</li>\
                    <li class="bg_none portwwn" >%s</li>\
                 </ul>'%self.remote_ports_obj[frport_index].PortAttr.PortWWN
       
        return html
    
    def get_frport_statistics(self,adapname,frportindex, flportindex):
        logging.info('FRPort Statistics:  waiting for response from UMboost sid : %s , IP : %s , adapname : %s , Index : %s'%(self.sid, self.ip, adapname, frportindex))
        self.boostStatsAgmtObj = FCoEStats(self.sid, self.ip)
        self.boostStatsObj = FCoEStatUtils()
        status = self.boostStatsObj.FcoeRPortStats(self.boostStatsAgmtObj, adapname, flportindex, frportindex )
        logging.info('FRPort Statistics status: %s'%status)
        
        if status == 0:
            return self.generate_stats_html()
        elif status == -2:
            return -2
        else:
            return -1
        
    def get_fvrport_statistics(self,adapname,flportindex, fvport_index, fvrport_index):
        logging.info('FVRPort Statistics:  waiting for response from UMboost sid : %s , IP : %s , adapname : %s , LPortIndex : %s\
                      , VPortIndex : %s, VRPortIndex : %s'%(self.sid, self.ip, adapname, flportindex, fvport_index, fvrport_index))
        self.boostStatsAgmtObj = FCoEStats(self.sid, self.ip)
        self.boostStatsObj = FCoEStatUtils()
        status = self.boostStatsObj.FcoeListVPortRPortStats(self.boostStatsAgmtObj, adapname, flportindex, fvport_index, fvrport_index)
        logging.info('FVRPort Statistics status: %s'%status)
        
        if status == 0:
            return self.generate_stats_html()
        elif status == -2:
            return -2
        else:
            return -1
        
    def get_fvport_sum(self, data):
        self.vport_obj = self.list_vports(data['adapname'], data['flportindex'])
        
        if self.vport_obj == -2 or self.vport_obj == -1:
            return self.vport_obj
        else:
            return self.generate_vport_sum_html(int(data['fvport_index']))
        
    def generate_vport_sum_html(self, fvport_index):
        
        html = '<ul class="horizontal head_ul">\
                    <li><h2>Property</h2></li>\
                    <li><h2 class="bg_none" >Value</h2></li>\
                 </ul>'
       
        html += '<ul class="horizontal content_tbl clear">\
                    <li class="label">Adapter Name</li>\
                    <li class="bg_none state" >%s</li>\
                 </ul>'%self.vport_obj[fvport_index].adapName 
                 
        html += '<ul class="horizontal content_tbl clear">\
                    <li class="label">ENode MAC</li>\
                    <li class="bg_none enode_mac" >%s</li>\
                 </ul>'%self.vport_obj[fvport_index].enode_mac 
        
        return html
        
    def get_vport_attributes(self,data):
        self.virtual_ports_obj = self.list_vports(data['adapname'], data['flportindex'])
        
        if self.virtual_ports_obj == -2 or self.virtual_ports_obj == -1:
            return self.virtual_ports_obj
        else:
            return self.generate_vport_attr_html(int(data['fvport_index']))
        
    def generate_vport_attr_html(self, fvport_index):
        
        html = '<ul class="horizontal head_ul">\
                    <li><h2>Property</h2></li>\
                    <li><h2 class="bg_none" >Value</h2></li>\
                 </ul>'
       
        html += '<ul class="horizontal content_tbl clear">\
                    <li class="label">State</li>\
                    <li class="bg_none nport" >%s &nbsp;</li>\
                 </ul>'%self.virtual_ports_obj[fvport_index].PortAttr.PortState 
                 
        html += '<ul class="horizontal content_tbl clear">\
                    <li class="label">NodeWWN</li>\
                    <li class="bg_none state" >%s&nbsp;</li>\
                 </ul>'%self.virtual_ports_obj[fvport_index].PortAttr.NodeWWN 
        
        html += '<ul class="horizontal content_tbl clear">\
                    <li class="label">PortWWN</li>\
                    <li class="bg_none nodewwn" >%s&nbsp;</li>\
                 </ul>'%self.virtual_ports_obj[fvport_index].PortAttr.PortWWN
                 
        html += '<ul class="horizontal content_tbl clear">\
                    <li class="label">NPort MAC Address</li>\
                    <li class="bg_none portwwn" >%s&nbsp;</li>\
                 </ul>'%self.virtual_ports_obj[fvport_index].mac
                 
        html += '<ul class="horizontal content_tbl clear">\
                    <li class="label">Vlan Id</li>\
                    <li class="bg_none portwwn" >%s&nbsp;</li>\
                 </ul>'%self.virtual_ports_obj[fvport_index].vlan_id
                 
        html += '<ul class="horizontal content_tbl clear">\
                    <li class="label">Fabric Name</li>\
                    <li class="bg_none portwwn" >%s&nbsp;</li>\
                 </ul>'%self.virtual_ports_obj[fvport_index].PortAttr.FabricName
                 
        html += '<ul class="horizontal content_tbl clear">\
                    <li class="label">FC ID</li>\
                    <li class="bg_none portwwn" >%s&nbsp;</li>\
                 </ul>'%self.virtual_ports_obj[fvport_index].PortAttr.PortFcId
                 
        html += '<ul class="horizontal content_tbl clear">\
                    <li class="label">Type</li>\
                    <li class="bg_none portwwn" >VN_Port</li>\
                 </ul>'
                 
        html += '<ul class="horizontal content_tbl clear">\
                    <li class="label">Supported Class Of Service</li>\
                    <li class="bg_none portwwn" >%s&nbsp;</li>\
                 </ul>'%self.virtual_ports_obj[fvport_index].PortAttr.PortSupportedClassofService
                 
                 
        html += '<ul class="horizontal content_tbl clear">\
                    <li class="label">OS Device Name</li>\
                    <li class="bg_none portwwn" >%s&nbsp;</li>\
                 </ul>'%self.virtual_ports_obj[fvport_index].PortAttr.OSDeviceName
                 
        html += '<ul class="horizontal content_tbl clear">\
                    <li class="label">Speed</li>\
                    <li class="bg_none portwwn" >%s&nbsp;</li>\
                 </ul>'%self.virtual_ports_obj[fvport_index].PortAttr.PortSpeed
                 
        html += '<ul class="horizontal content_tbl clear">\
                    <li class="label">Maximum Frame Size</li>\
                    <li class="bg_none portwwn" >%s&nbsp;</li>\
                 </ul>'%self.virtual_ports_obj[fvport_index].PortAttr.PortMaxFrameSize
                 
        html += '<ul class="horizontal content_tbl clear">\
                    <li class="label">No. of SCSI Targets</li>\
                    <li class="bg_none portwwn" >%s&nbsp;</li>\
                 </ul>'%self.virtual_ports_obj[fvport_index].PortAttr.NumberofDiscoveredPorts
                 
        return html
    
    def get_vport_statistics(self,adapname, fvportindex, flportindex):
        logging.info('FVPort Statistics:  waiting for response from UMboost sid : %s , IP : %s , adapname : %s , VportIndex : %s , LportIndex : %s'%(self.sid, self.ip, adapname, fvportindex, flportindex))
        self.boostStatsAgmtObj = FCoEStats(self.sid, self.ip)
        self.boostStatsObj = FCoEStatUtils()
        status = self.boostStatsObj.FcoeListVPortStats(self.boostStatsAgmtObj, adapname, flportindex, fvportindex)
        logging.info('FVPort Statistics status: %s'%status)
        
        if status == 0:
            return self.generate_stats_html()
        elif status == -2:
            return -2
        else:
            return -1
        
    def get_flun_summary(self,data):
        self.luns_obj = self.list_luns(data['adapname'], data['flportindex'], data['frport_index'], data['ostype'] )
          
        if self.luns_obj == -2 or self.luns_obj == -1:
            return self.luns_obj
        else:
            return self.generate_flun_sum_tml(int(data['flun_index']))
        
    def get_fvlun_summary(self, data):
        self.luns_obj = self.list_vluns(data['adapname'], data['flportindex'], data['fvport_index'], data['fvrport_index'], data['ostype'] )
        if self.luns_obj == -2 or self.luns_obj == -1:
            return self.luns_obj
        else:
            return self.generate_flun_sum_tml(int(data['fvlun_index']))
        
    def generate_flun_sum_tml(self, flun_index):
        
        html = '<ul class="horizontal head_ul">\
                    <li><h2>Property</h2></li>\
                    <li><h2 class="bg_none" >Value</h2></li>\
                 </ul>'
       
        html += '<ul class="horizontal content_tbl clear">\
                    <li class="label">Capacity</li>\
                    <li class="bg_none nport" >%s &nbsp;</li>\
                 </ul>'%self.luns_obj[flun_index].capacity 
                 
        html += '<ul class="horizontal content_tbl clear">\
                    <li class="label">SCSI Address</li>\
                    <li class="bg_none state" >%s &nbsp;</li>\
                 </ul>'%self.luns_obj[flun_index].btl 
                 
        html += '<ul class="horizontal content_tbl clear">\
                    <li class="label">Lun ID</li>\
                    <li class="bg_none state" >%s&nbsp;</li>\
                 </ul>'%self.luns_obj[flun_index].getLunId()
        
        return html

    def delete_npiv(self, data):
        logging.info('FCOE Delete NPIV: waiting for response from UMboost sid : %s , IP : %s , adapname : %s , parentWWPN : %s, \
                    parentWWNN : %s, vPortWWPN : %s, vPortWWNN : %s\
                    '%(self.sid, self.ip, data['adapname'], data['parentWWPN'], data['parentWWNN'], data['vportWWPN'], data['vportWWNN']))
        self.boostNpivObj = FCoEControl(self.sid, self.ip)
        status = self.boostNpivObj.FcoeDeleteNPIV(self.sid, self.ip, data['adapname'], data['parentWWPN'], data['parentWWNN'], data['vportWWPN'], data['vportWWNN'])
        logging.info('FCOE Delete NPIV status: %s'%status)
        
        if status == 0 or status == -2:
            return status
        else:
            return -1
        
    def get_fcard_sum(self, index, req_type):
        obj = self.list_adapters()
        if obj == -2 or obj == -1:
            return obj
       
        if req_type == 'desktop': 
            html = '\
            <ul class="horizontal content_tbl clear">\
                <li class="label">Manufacturer</li>\
                <li class="bg_none manu" >%s</li>\
             </ul>\
             <ul class="horizontal content_tbl clear">\
                <li class="label">Model</li>\
                <li class="bg_none model" >%s</li>\
             </ul>\
             <ul class="horizontal content_tbl clear">\
                <li class="label">Hardware Version</li>\
                <li class="bg_none hwv" >%s</li>\
             </ul>'
        else:
            html = '\
            <div class=" ui-grid-a grid content_tbl">\
                <div class="ui-block-a ">Manufacturer</div>\
                <div class="ui-block-b manu">%s</div>\
            </div>\
            <div class=" ui-grid-a grid content_tbl">\
                <div class="ui-block-a ">Model</div>\
                <div class="ui-block-b model" >%s</div>\
            </div>\
            <div class=" ui-grid-a grid content_tbl">\
                <div class="ui-block-a ">Hardware Version</div>\
                <div class="ui-block-b hwv" >%s</div>\
            </div>'
        return html%( obj[index].addInfo.Manufacturer, obj[index].addInfo.Model, obj[index].addInfo.HardwareVersion ) 
