from UmBoostLib import DrList , DriverList
from UmBoostLib import DriverData

import simplejson, settings
logging = settings.get_logger()

class DriverDetails:

    def __init__(self,sessionId,hostIP,type):
         self.type = type
         self.sessionId = sessionId
         self.hostIP = hostIP

    def get_driver_summary(self, ostype):
        
        self.ostype = ostype 
        logging.info('Driver Details:  waiting for response from UMboost sid : %s , IP : %s'%(self.sessionId,self.hostIP))
        self.boostDriverDataObj=DrList()
        self.boostDrListobj = DriverList()
        status = self.boostDrListobj.getDriverInfo(self.boostDriverDataObj,self.sessionId,self.hostIP)
        logging.info('Driver Details status: %s'%status)
        
        if status == 0:
            return self.generateHTML()
        elif status == -2:
            return -2
        else:
            return -1
         
    def getItems(self):

        for i in range (0,len(self.boostDriverDataObj)):
          yield self.boostDrListobj.get(self.boostDriverDataObj,i)

    def generate_control(self,flag, drivername):
        ip_id = self.hostIP.replace('.','_');
        if self.type == 'desktop':
            unique_parent_id = '#system_content__incend__'+ ip_id+' .system_driver_details_tab'
        else:
            unique_parent_id = '#system_dt__'+ ip_id+'__incend'
            
        if flag:
            select_attr = ''
            if drivername == 't3_tom' or drivername == 't4_tom':
                select_attr = 'disabled="disabled"'
            if self.type == 'desktop':
                if self.ostype == '1':
                    html = '<div class="cmn ui-block-a ui-blocks loaded">\
                                <select data-native-menu="false" name="%s" class="loaded_0" onchange="driver_change(\'%s\',\'%s\', $(this))" autocomplete="off" %s>\
                                    <option selected="selected" value="0">Yes</option>\
                                    <option value="1" >No</option>\
                                </select>\
                            </div>'%(drivername, unique_parent_id, ip_id, select_attr)
                else:
                    html = '<div class="cmn ui-block-a ui-blocks loaded">\
                                <select data-native-menu="false" name="%s" class="loaded_0" onchange="driver_change(\'%s\',\'%s\', $(this))" autocomplete="off" %s>\
                                    <option selected="selected" value="0">Yes</option>\
                                    <option value="1" >No</option>\
                                    <option value="2" >Reload</option>\
                                </select>\
                            </div>'%(drivername, unique_parent_id, ip_id, select_attr)
            else:
                if self.ostype == '1':
                   html = '<div class="ui-block-b loaded iter" >\
                            <select data-native-menu="false" onchange="driver_change(\'%s\',\'%s\', $(this))" class="loaded_0" name="%s" autocomplete="off" %s>\
                                <option selected="selected" value="0">Yes</option>\
                                <option value="1" >No</option>\
                            </select>\
                        </div>'%(unique_parent_id, ip_id, drivername, select_attr)
                else:
                    html = '<div class="ui-block-b loaded iter" >\
                            <select data-native-menu="false" onchange="driver_change(\'%s\',\'%s\', $(this))" class="loaded_0" name="%s" autocomplete="off" %s>\
                                <option selected="selected" value="0">Yes</option>\
                                <option value="1" >No</option>\
                                 <option value="2" >Reload</option>\
                            </select>\
                        </div>'%(unique_parent_id, ip_id, drivername, select_attr)
                
            return html
        else:
            if self.type == 'desktop':
                if self.ostype == '1':
                    html = '<div class="cmn ui-block-a ui-blocks loaded"><select name="%s" data-native-menu="false" onchange="driver_change(\'%s\',\'%s\', $(this))" class="loaded_1" autocomplete="off"><option value="0" >Yes</option><option selected="selected" value="1" >No</option></select></div>'%(drivername, unique_parent_id, ip_id)
                else:
                    html = '<div class="cmn ui-block-a ui-blocks loaded"><select name="%s" data-native-menu="false" onchange="driver_change(\'%s\',\'%s\', $(this))" class="loaded_1" autocomplete="off"><option value="0" >Yes</option><option selected="selected" value="1" >No</option><option value="2" >Reload</option></select></div>'%(drivername, unique_parent_id, ip_id)
            else:
                if self.ostype == '1':
                    html = '<div class="ui-block-b loaded iter"><select data-native-menu="false" onchange="driver_change(\'%s\',\'%s\', $(this))" class="loaded_1" name="%s"  autocomplete="off"><option value="0" >Yes</option><option selected="selected" value="1" >No</option></select></div>'%(unique_parent_id, ip_id,drivername)
                else:
                    html = '<div class="ui-block-b loaded iter"><select data-native-menu="false" onchange="driver_change(\'%s\',\'%s\', $(this))" class="loaded_1" name="%s"  autocomplete="off"><option value="0" >Yes</option><option selected="selected" value="1" >No</option><option value="2" >Reload</option></select></div>'%(unique_parent_id, ip_id,drivername)
            return html

    def generateHTML(self):
        
        if self.type == 'desktop':
            
            head_html = '<div class="horizontal head_ul grid-a">\
                            <div class="cmn ui-block-a ui-blocks"><h2>Driver</h2></div>\
                            <div class="cmn ui-block-a ui-blocks"><h2>Loaded</h2></div>\
                            <div class="cmn ui-block-a ui-blocks"><h2>Version</h2></div>\
                            <div class="cmn ui-block-a ui-blocks"><h2>Date</h2></div>\
                            <div class="large ui-block-b ui-blocks"><h2 class="bg_none">Description</h2></div>\
                         </div>'
            
            top_html = '<div class="horizontal child_div clear grid-a from_server center">'
            driver_name_html = '<div class="cmn ui-block-a ui-blocks driver f_bold">%s</div>'
            version_html = '<div class="cmn ui-block-a ui-blocks version">%s</div>'
            date_html = '<div class="cmn ui-block-a ui-blocks date">%s</div>'
            desc_html = '<div class="large ui-block-a ui-blocks desc">%s</div>'
            bottom_html = '</div>'
        else:
            head_html = '<div class="ui-grid-d heading" data-theme="b" >\
                         <div class="ui-block-a ui-bar-b center driver">Driver</div>\
                         <div class="ui-block-b ui-bar-b center loaded">Loaded</div>\
                         <div class="ui-block-c ui-bar-b center version">Version</div>\
                         <div class="ui-block-d ui-bar-b center date">Date</div>\
                         <div class="ui-block-e ui-bar-b center desc">Description</div></div>'
            
            top_html = '<div class="ui-grid-d grid from_server">'
                    
            driver_name_html = '<div class="ui-block-a driver iter">%s</div>'
            version_html = '<div class="ui-block-c version iter">%s</div>'
            date_html = '<div class="ui-block-d date iter">%s</div>'
            desc_html = '<div class="ui-block-e desc iter" >%s</div>'
            
            bottom_html = '</div>'
        whole_html = '%s%s%s%s%s%s%s'
        height = 90
        html_list = []
        j = 0
        for i in self.getItems():
            j += 1
            height += 35
            if i.driverName.strip() == '':
                temp_driver_name_html = driver_name_html % 'N/A'
            else:
                temp_driver_name_html  =  driver_name_html % i.driverName
                
            if i.driverVersion.strip() == '':
                temp_version_html = version_html % 'N/A'
            else:
                temp_version_html = version_html % i.driverVersion
                
            if i.driverDate.strip() == '':
                temp_date_html = date_html % 'N/A'
            else:
                temp_date_html = date_html % i.driverDate
                
            if i.driverDesc.strip() == '':
                temp_desc_html = desc_html % 'N/A'
            else:
                temp_desc_html = desc_html % i.driverDesc
            
            if i.driverName.strip() == 't3_tom':
                loaded = 1
            else:
                loaded = i.isDrLoaded
            
            html_list.append(whole_html%( top_html ,
                                          temp_driver_name_html,
                                          self.generate_control(loaded, i.driverName) ,
                                          temp_version_html,
                                          temp_date_html,
                                          temp_desc_html,
                                          bottom_html))
        html = ''.join(html_list)
        data = {}
        data['html'] = head_html + html
        data['height'] = height 
        return simplejson.dumps(data)
    
    #is_fcoe_loaded function is being shared by py_menu.py and boot.py
    def is_fcoe_loaded(self, ostype):
        
        logging.info('Fcoe Driver Details:  waiting for response from UMboost sid : %s , IP : %s'%(self.sessionId,self.hostIP))
        self.boostDriverDataObj=DrList()
        self.boostDrListobj = DriverList()
        status=self.boostDrListobj.getDriverInfo(self.boostDriverDataObj,self.sessionId,self.hostIP)
        logging.info('Fcoe Driver Details status: %s'%status)
        
        if status == -2 or status == -1:
            return status
        
        if ostype == 1:
            fcoe_driver_name = 'csiofcoe'
        elif ostype == 2 or ostype == 8:
            fcoe_driver_name = 'csiostor'
        else:
            return -6
        
        data = {}
        data['loaded'] = -6        
        for i in self.getItems():
            if fcoe_driver_name == i.driverName and i.isDrLoaded:
                data['loaded'] = 0
                if i.driverVersion.strip() == '':
                    data['version'] = 'N/A'
                else:
                    data['version'] = i.driverVersion
                return simplejson.dumps(data)
        
        return simplejson.dumps(data)
                
    #Load Unload Driver
    def update_driver(self,data):
        
        self.boostUpdateDriverObj.setDrName(data['drivername'])

        if data['flag'] == '2':
            logging.info('Reload Driver - Waiting for Boost - sid :%s , ip: %s , flag : 1 , Drivername : %s, vf_port : %s\
                     '%(self.sessionId,self.hostIP,data['drivername'] ,data['vf_port']))
            status = self.boostUpdateDriverObj.LoadUnloadDriver(self.sessionId, self.hostIP, 1, data['vf_port'])
            logging.info('Reload Driver Status : %s'%status)
            
            logging.info('Reload Driver - Waiting for Boost - sid :%s , ip: %s , flag : 0 , Drivername : %s, vf_port : %s\
                     '%(self.sessionId,self.hostIP,data['drivername'] ,data['vf_port']))
            status = self.boostUpdateDriverObj.LoadUnloadDriver(self.sessionId, self.hostIP, 0, data['vf_port'])
            logging.info('Reload Driver Status : %s'%status)
        else:
            logging.info('LoadUnload Driver - Waiting for Boost - sid :%s , ip: %s , flag : %s , Drivername : %s, vf_port : %s\
                     '%(self.sessionId, self.hostIP, data['flag'], data['drivername'] ,data['vf_port']))
            status = self.boostUpdateDriverObj.LoadUnloadDriver(self.sessionId, self.hostIP, int(data['flag']), data['vf_port'])
            logging.info('LoadUnload Driver Status : %s'%status)
        
        return status
        
    def load_unload_driver(self,kwargs):
        self.boostUpdateDriverObj = DriverData()
        
        success = True
        data = {}
        data['vf_port'] = kwargs['vf_port']
        if int(kwargs['driver_count']) > 1:
            for i in range(int(kwargs['driver_count'])):
                data['drivername'] = kwargs['drivername'][i]
                data['flag'] = kwargs['flag'][i]
                status = self.update_driver(data)
                
                if status == -2:
                    return -2
                elif status != 0:
                    success = False
        else:
            data['drivername'] = kwargs['drivername']
            data['flag'] = kwargs['flag']
            status = self.update_driver(data)
            
            if status == -2:
                return -2
            elif status != 0:
                success = False
            
        if success:
            return 0
        else:
            return -1
        
    #is_iwarp_driver_loaded function is being used by IwarpFile
    def is_iwarp_driver_loaded(self, ostype):
        
        logging.info('iWarp Driver Details:  waiting for response from UMboost sid : %s , IP : %s'%(self.sessionId,self.hostIP))
        self.boostDriverDataObj=DrList()
        self.boostDrListobj = DriverList()
        status=self.boostDrListobj.getDriverInfo(self.boostDriverDataObj,self.sessionId,self.hostIP)
        logging.info('iWarp Driver Details status: %s'%status)
        
        if status == -2 or status == -1:
            return status
        
        data = {}
        if ostype == 1:
            data['chiwarp'] = 'no'
        if ostype == 4:
            data['iw_cxgbe'] = 'no'
        elif ostype == 2:
            data['iw_cxgb3'] = 'no'
            data['iw_cxgb4'] = 'no'
        else:
            return -6
        
        for i in self.getItems():
            if ostype == 2:    
                if i.driverName.strip() == 'iw_cxgb3' and i.isDrLoaded:
                    data['iw_cxgb3'] = 'yes'
                elif i.driverName.strip() == 'iw_cxgb4' and i.isDrLoaded:
                    data['iw_cxgb4'] = 'yes'
            elif ostype == 1:
                if i.driverName.strip() == 'chiwarp' and i.isDrLoaded:
                    data['chiwarp'] = 'yes'
            elif ostype == 4:
                if i.driverName.strip() == 'iw_cxgbe' and i.isDrLoaded:
                    data['iw_cxgbe'] = 'yes'
                    
        return data
    
    #Verify if the specified driver is loaded or not
    def is_driver_loaded(self, **data):
        
        logging.info('%s Driver Details:  waiting for response from UMboost sid : %s , IP : %s'%(data['dr_name'], self.sessionId, self.hostIP))
        self.boostDriverDataObj=DrList()
        self.boostDrListobj = DriverList()
        status=self.boostDrListobj.getDriverInfo(self.boostDriverDataObj,self.sessionId,self.hostIP)
        logging.info('%s Driver Details status: %s'%(data['dr_name'], status))
        
        return_data = {}
        return_data['loaded'] = -6   
        if status == 0:
            return_data['status'] = 0
            for i in self.getItems():
                if data['dr_name'] == i.driverName and i.isDrLoaded:
                    return_data['loaded'] = 0
                    logging.info('Is %s Driver loaded : %s'%(data['dr_name'], return_data['loaded']))
                    return return_data
            logging.info('Is %s Driver loaded : %s'%(data['dr_name'], return_data['loaded']))
            return return_data
        elif status == -2:
            return_data['status'] = -2
        else:
            return_data['status'] = -1
        
        logging.info('Is %s Driver loaded : %s'%(data['dr_name'], return_data['loaded']))
        return return_data