from UmBoostLib import UMServerDriverInfoList as DriverInfo
from xml.dom.minidom import Document as XML

# The instance of the DriverInfoList class
class DriverInfoList:
    ## Constructor for the class DriverInfoList
    ##@param sessionId
    # The session identifier.
    ##@param hostIP
    # The Host IP.
    def __init__(self,sessionId,hostIP):
        self.hostIP = hostIP
        self.sessionId = sessionId
        self.drvInfo = DriverInfo()

    ##Gets all the Driver Information running UmServer.        
    def getDrvInfo(self):
        xmlContent = ""
        status = self.drvInfo.GetDriverInfo(self.sessionId,self.hostIP)
        if status != 0 :
            return "Unknown Error"
        else :
            xmlContent = self.generateXML()
            return xmlContent

    ##Generator function for all the DeviceInfo objects
    ##@return
    # Returns an iter element of the type UmServerDriverInfo from the boost library
    def getItems(self):
        for i in range(0,len(self.drvInfo)):
            yield self.drvInfo.getitem(i)

    ##Generates the XML data-set for rendering the data.
    ##@return
    # Returns the XML data-set
    def generateXML(self):
        doc = XML()
        wml = doc.createElement("DriverInfo")
        doc.appendChild(wml)
        # ipText = doc.createTextNode(self.hostIP)
        # wml.appendChild(ipText)
        for i in self.getItems() :
            IP = doc.createElement("IP")
            wml.appendChild(host)
            # set attr here
            drvName = doc.createElement("DriverName")
            IP.appendChild(drvName)
            drvNameText = doc.createTextNode(i.DriverName)
            drvName.appendChild(drvNameText)
            drvDate = doc.createElement("DriverDate")
            IP.appendChild(drvDate)
            hostnameText = doc.createTextNode(i.DriverDate)
            drvDate.appendChild(hostnameText)
            drvVersion = doc.createElement("DriverVersion")
            IP.appendChild(drvVersion)
            drvVersionText = doc.createTextNode(i.DriverVersion)
            drvVersion.appendChild(drvVersionText)
            drvDesc = doc.createElement("DriverDesc")
            IP.appendChild(drvDesc)
            drvDescText = doc.createTextNode(i.DriverDesc)
            drvDesc.appendChild(drvDescText)
            loaded = doc.createElement("Loaded")
            IP.appendChild(loaded)
            loadedText = doc.createTextNode(i.isLoaded)
            loaded.appendChild(loadedText)
        strn = doc.toprettyxml(indent="  ", encoding = "UTF-8")
        return strn
