from UmBoostLib import DiscoveryList as Discovery
from UmBoostLib import NodeDiscovery
from xml.dom.minidom import Document
import utils

import settings
logging = settings.get_logger()

class DiscoverNode:
    def __init__(self,sid,ostype,hostip):
        self.sessionId = sid
        self.ostype = ostype
        self.hostip = hostip
        self.Disc = Discovery()
        self.NodeDisc = NodeDiscovery()

    def getNodes(self, data):
        
        if data['ipvalidate']:
            logging.info('Server Discovery IP validate: %s, Validate : 1 '%self.hostip)
            ip_validate = utils.validate_ip(self.hostip, 1)
            logging.info('Server Discovery IP Validate status %s'%ip_validate)
            if ip_validate == -1:
                return  'Invalid IP'
        
        if data['discover_through_agent'] == 'yes':
            logging.info('Server Discovery through agents subnet sid : %s , agent_ip : %s, dta_search_hostname : %s, dta_search_ip : %s, ostype : %s'
                         %(self.sessionId, data['agent_ip'], data['dta_search_hostname'], data['dta_search_ip'], data['ostype']))
            status = self.NodeDisc.DiscoverMoreUMAgents(self.Disc, self.sessionId, data['agent_ip'], data['dta_search_hostname'], data['dta_search_ip'], data['ostype'])
            logging.info('Server Discovery status: %s'%status)
        else:
            logging.info('Server Discovery waiting for response from UMboost sid : %s , ostype : %s , hostname : %s, hostip : %s'%(self.sessionId,self.ostype,data['dta_search_hostname'],self.hostip))
            status = self.NodeDisc.discoverServers(self.Disc,self.sessionId,self.ostype,data['dta_search_hostname'],self.hostip)
            logging.info('Server Discovery status: %s'%status)
        
        if status == 0:
            return self.generateXML()
        elif status == -2:
            return -2
        else:
            return -1
        
    def getItems(self):
        for i in range(0,len(self.Disc)):
            yield self.NodeDisc.getitem(self.Disc,i)

    def generateXML(self):
        # Create the minidom document
        doc = Document()
        
        # Create the <discover> base element
        discover = doc.createElement("discover")
        doc.appendChild(discover)
        
        for i in self.getItems():
            
            # Create the main <host> element
            host = doc.createElement("host")
            discover.appendChild(host)
            
            # Create the main <ip> element
            ip = doc.createElement("ip")
            host.appendChild(ip)
            
            # Assign <ip> element with IP address
            ipaddrr = doc.createTextNode(i.hostip)
            ip.appendChild(ipaddrr)
            
            # Create the main <port> element
            port = doc.createElement("port")
            host.appendChild(port)
            
            # Assign <port> element with IP address
            port_value = doc.createTextNode(str(i.port))
            port.appendChild(port_value)
            
            # Create the main <hostname> element
            hostname = doc.createElement("hostname")
            host.appendChild(hostname)
            
            # Assign <hostname> element with hostname
            hostname_value = doc.createTextNode(i.hostName)
            hostname.appendChild(hostname_value)
            
            # Create the main <ostype> element
            ostype = doc.createElement("ostype")
            host.appendChild(ostype)
            
            # Assign <ostype> element with ostype
            ostype_value = doc.createTextNode(i.OsType)
            ostype.appendChild(ostype_value)

        return doc.toprettyxml()
