from mod_python import Cookie
import datetime,time

import logging
import settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)

## The Cookie Management class
class CookieMgmt:
    ## Constructor for the Cookie Management class
    ##@param req
    # The request object.
    def __init__(self, req):
        self.req = req

    ## Gets the cookie from the request object.
    ##@return
    # Returns the session identifier.
    def getSessionId(self):
        try:
            cookie = Cookie.get_cookies(self.req)['sid']
            sessionId = str(cookie).split("=")[1]
            return sessionId
        except KeyError:
            return -1
    
    def getCookie(self,cookie_name):
        # Retrieve a dictionary like object containing all cookies
        all_cookies = Cookie.get_cookies(self.req)
        # Get the last_visit cookie
        retrvd_cookie = all_cookies.get(cookie_name, None)
        if retrvd_cookie:
            return str(retrvd_cookie).split("=")[1]
        return None

    ## Adds or sets the cookie on the client side.
    ##@param sessionId
    # The session identifier to be set as the cookie.
    def addCookie(self,cookie_name,cookie_value):
        cookie = Cookie.Cookie(cookie_name,cookie_value)
        cookie.expires = time.time()+60 * 2
        Cookie.add_cookie(self.req,cookie)
        
    def deleteCookie(self,cookie_name):
        cookie = Cookie.Cookie(cookie_name,'')
        cookie.expires = time.time()-1
        Cookie.add_cookie(self.req,cookie)
        return '1'
        
    '''def addSessionIdCookie(self,sessionId):
        cookie = Cookie.Cookie("sid",sessionId)
        cookie.expires = time.time()+300
        Cookie.add_cookie(self.req,cookie)'''    