from fcoeutils import BootUtils, T4BootProperties

from xml.dom.minidom import Document
import logging
import settings
logging.basicConfig(filename=settings.log_path, level=settings.log_level)

class ConfigFlash:
    def __init__(self, sid, ip, req_type) :
         self.sid = sid
         self.ip = ip
         self.req_type = req_type

    def flashConfig(self, data):
        mainObj = BootUtils( self.sid, self.ip )
        logging.info('Card Flash Config file - waiting for response from UMboost sid : %s , IP : %s, username : %s, cardindex : %s, fname : %s'%(
                                                                                            self.sid, self.ip, data['username'], data['cardindex'], data['fname'] ))
        status = mainObj.flashConfig( data['username'], data['cardindex'], data['fname'] )
        logging.info('Card Flash Config file Status: result %s'%(status))
        return self.generate_status(status)
    
    def generate_status(self, status):        
        
        doc = Document()
        uploadConfKey = doc.createElement("uploadconfigfile")
        doc.appendChild(uploadConfKey)
        
        status_node = doc.createElement("status")
        uploadConfKey.appendChild(status_node)
        
        status_val = doc.createTextNode('%s'%str(status))
        status_node.appendChild(status_val)
        return doc.toprettyxml()
    
    def getconfig_file_type(self, index):
        
        logging.info('Card Flash Config get config file type - sid : %s, ip : %s, index : %s'%( self.sid, self.ip, index ))
        self.boost_agmt_obj = T4BootProperties()
        self.boot_boost_obj = BootUtils( self.sid, self.ip )
        status = self.boot_boost_obj.getT4BootProperties(index, self.boost_agmt_obj)
        logging.info('Card Flash Config get config file type status : %s'%status)
        
        if status == 0:
            return self.boost_agmt_obj.configType.val
        elif status == -2:
            return status
        else:
            return -1