from UmBoostLib import AdapList,CardList
from xml.dom.minidom import Document
import utils

import simplejson
import logging
import settings
logging.basicConfig(filename=settings.log_path,level=logging.DEBUG)

class CardSummary:
    def __init__(self,sessionId,hostIP,ostype):
        self.sessionId = sessionId
        self.hostIP = hostIP
        self.ostype = int(ostype)
        self.cards = AdapList()
        self.cardList = CardList()

    def getCardSummary(self,index, pciloc):
        logging.info('Card Summary waiting for response from UMboost sid : %s , IP : %s , Index : %s, ostype : %s'%(self.sessionId,self.hostIP,index, self.ostype))
        status = self.cardList.getCardInformation(self.cards,self.sessionId,self.hostIP,int(index),self.ostype, pciloc)
        logging.info('Card Summary status: %s'%status)
        
        if status == 0 or status == 62:
            return self.generateSummaryXML()
        elif status == -2:
            return -2
        else:
            return -1
        
    def get_pciloc(self,index):
        logging.info('PCILOC waiting for response from UMboost sid : %s , IP : %s , Index : %s, ostype : %s'%(self.sessionId,self.hostIP,index, self.ostype))
        status = self.cardList.getCardInformation(self.cards,self.sessionId,self.hostIP,int(index),self.ostype, "")
        logging.info('PCILOC status: %s'%status)
        
        if status == 0  or status == 62:
            return self.cardList.getitem(self.cards, 0).PCIBusLocation
        elif status == -2:
            return -2
        else:
            return -1
        
    def getAdditionalCardSummary(self,index, pciloc):
        #pciloc = self.get_pciloc(index)
        if pciloc == -2 or pciloc == -1:
            return pciloc
        
        logging.info('Card Additional Summary waiting for response from UMboost sid : %s , IP : %s , pciloc : %s'%(self.sessionId,self.hostIP,pciloc))
        self.cards = AdapList()
        self.cardList = CardList()
        status = self.cardList.getAddCardInformation(self.cards, self.sessionId, self.hostIP, pciloc, self.ostype)
        logging.info('Card Additional Summary status: %s'%status)
        
        if status == 0:
            return self.generateAddSummaryXML()
        elif status == -2:
            return -2
        else:
            return -1
        
    def getMenuCardInfo(self, index):
        
        logging.info('Card Info for Menu waiting for response from UMboost: %s , IP : %s , Index : %s, ostype : %s'%(self.sessionId,self.hostIP,index, self.ostype))
        cinfo_status = self.cardList.getCardInformation(self.cards,self.sessionId,self.hostIP,int(index), self.ostype, "")
        logging.info('Card Info for Menu status: %s'%cinfo_status)
        
        menu_card_info = {}
        
        if cinfo_status == 0 or cinfo_status == 62:
            menu_card_info['ports_count'] = self.cardList.getitem(self.cards,0).PortCount
            menu_card_info['chiptype'] = self.cardList.getitem(self.cards,0).chipType
            menu_card_info['pciloc'] = self.cardList.getitem(self.cards, 0).PCIBusLocation
            menu_card_info['firmwareVersion'] = self.cardList.getitem(self.cards, 0).firmwareVersion
            #menu_card_info['index'] = self.cardList.getitem(self.cards, 0).index
        elif cinfo_status == -2:
            return -2
        else:
            return -1
        
        pciloc = self.cardList.getitem(self.cards, 0).PCIBusLocation
        if pciloc == -2 or pciloc == -1:
            return pciloc
        
        cards = AdapList()
        cardList = CardList()
        logging.info('Card Additional Info for Menu waiting for response from UMboost: %s , IP : %s , pciloc : %s, ostype : %s'%(self.sessionId,self.hostIP,pciloc,self.ostype))
        add_cinfo_status = cardList.getAddCardInformation(cards, self.sessionId, self.hostIP, pciloc, self.ostype)
        logging.info('Card Additional Info for Menu status: %s'%add_cinfo_status)
        
        card_obj = cardList.getitem(cards, 0)
        if add_cinfo_status == 0:
            menu_card_info['cardname'] =  card_obj.model
            menu_card_info['connector'] =  card_obj.connector
            menu_card_info['phy_idx'] =  card_obj.phy_idx
            menu_card_info['product_serial'] =  card_obj.product_serial
        elif add_cinfo_status == -2:
            return -2
        else:
            return -1
        
        logging.debug(menu_card_info)
        return menu_card_info
    
    
    def getItems(self):
        for i in range(0,len(self.cards)):
            yield self.cardList.getitem(self.cards,i)
            
    def getNLMenuCardInfo(self, index):
        
        logging.info('Card Info for not licensed system for Menu - waiting for response from UMboost: %s , IP : %s , Index : %s'%(self.sessionId, self.hostIP, index))
        cinfo_status = self.cardList.getLicenseCardInfo(self.cards, self.sessionId, self.hostIP, int(index), self.ostype, "")
        logging.info('Card Info for not licensed system for Menu status: %s'%cinfo_status)
        
        card_obj = self.cardList.getitem(self.cards, 0)
        card_name = {}
        if cinfo_status == 0:
            card_name['cardname'] = card_obj.model 
            return card_name
        elif add_cinfo_status == -2:
            return -2
        else:
            return -1
        
    def getNLCardSummary(self, index, pciloc):
        
        logging.info('Card Info for not licensed system - waiting for response from UMboost: %s , IP : %s , Index : %s'%(self.sessionId, self.hostIP, index))
        cinfo_status = self.cardList.getLicenseCardInfo(self.cards, self.sessionId, self.hostIP, int(index), self.ostype, pciloc)
        logging.info('Card Info for not licensed system status: %s'%cinfo_status)
        
        if cinfo_status == 0:
            data = {}
            for i in self.getItems():
                data['vendorid'] = i.vendorid
                data['deviceid'] = i.deviceid
                data['PCIBusLocation'] = i.PCIBusLocation
                data['productserial'] = i.product_serial
            return simplejson.dumps(data)
        elif cinfo_status == -2:
            return -2
        else:
            return -1
        
    def generateSummaryXML(self):
        # Create the minidom document
        doc = Document()
        
        cardsummary = doc.createElement("cardsummary")
        doc.appendChild(cardsummary)
        
        for i in self.getItems():
            
            PCIBusLocation = doc.createElement("PCIBusLocation")
            cardsummary.appendChild(PCIBusLocation)
            
            PCIBusLocation_value = doc.createTextNode(i.PCIBusLocation)
            PCIBusLocation.appendChild(PCIBusLocation_value)
            
            vendorid = doc.createElement("vendorid")
            cardsummary.appendChild(vendorid)
            
            vendorid_value = doc.createTextNode(i.vendorid)
            vendorid.appendChild(vendorid_value)
            
            deviceid = doc.createElement("deviceid")
            cardsummary.appendChild(deviceid)
            
            deviceid_value = doc.createTextNode('%s'%i.deviceid)
            deviceid.appendChild(deviceid_value)
            
            PortCount = doc.createElement("PortCount")
            cardsummary.appendChild(PortCount)
            
            PortCount_value = doc.createTextNode('%s'%i.PortCount)
            PortCount.appendChild(PortCount_value)
            
            firmwareVersion = doc.createElement("firmwareVersion")
            cardsummary.appendChild(firmwareVersion)
            
            firmwareVersion_value = doc.createTextNode(i.firmwareVersion)
            firmwareVersion.appendChild(firmwareVersion_value)
            
            '''irq = doc.createElement("irq")
            cardsummary.appendChild(irq)
            
            irq_value = doc.createTextNode('%s'%i.irq)
            irq.appendChild(irq_value)'''
            
            if self.ostype == 1:
                osdevice_desc = i.Description
                
                chimney = doc.createElement("chimney")
                cardsummary.appendChild(chimney)
                
                chimney_value = doc.createTextNode('%s'%i.IsChimneyEnable)
                chimney.appendChild(chimney_value)
                
                maintenance = doc.createElement("maintenance")
                cardsummary.appendChild(maintenance)
                
                maintenance_value = doc.createTextNode('%s'%i.AdapterUpdateMode)
                maintenance.appendChild(maintenance_value)
            else:
                osdevice_desc = i.cardName
                
            osdevice = doc.createElement("osdevice")
            cardsummary.appendChild(osdevice)
            
            osdevice_value = doc.createTextNode('%s'%osdevice_desc)
            osdevice.appendChild(osdevice_value)
            
            chiptype = doc.createElement("chiptype")
            cardsummary.appendChild(chiptype)
            
            chiptype_value = doc.createTextNode('%s'%i.chipType)
            chiptype.appendChild(chiptype_value)
            
            #Since it has been accessed via card index. It should always return only the first set. Refer Bug #18366
            break
            
            
        return doc.toprettyxml()
    
    
    def generateAddSummaryXML(self):
        
        # Create the minidom document
        doc = Document()
        
        cardaddsummary = doc.createElement("cardaddsummary")
        doc.appendChild(cardaddsummary)
        
        for i in self.getItems():
            
            productserial = doc.createElement("productserial")
            cardaddsummary.appendChild(productserial)
            
            productserial_value = doc.createTextNode('%s'%i.product_serial)
            productserial.appendChild(productserial_value)
            
            factorymac = doc.createElement("factory_mac")
            cardaddsummary.appendChild(factorymac)
            
            factory_mac_value = doc.createTextNode('%s'%i.factory_mac)
            factorymac.appendChild(factory_mac_value)
            
            connector = doc.createElement("connector")
            cardaddsummary.appendChild(connector)
            
            connector_value = doc.createTextNode('%s'%i.connector)
            connector.appendChild(connector_value)

        return doc.toprettyxml()
    
        
    def generateSpecificCardSummary(self,index):
        
        # Create the minidom document
        doc = Document()
        
        cardsummary = doc.createElement("cardsummary")
        doc.appendChild(cardsummary)
        
        for i in self.cardList.getitem(self.cards,0):
            
            PCIBusLocation = doc.createElement("PCIBusLocation")
            cardsummary.appendChild(PCIBusLocation)
            
            PCIBusLocation_value = doc.createTextNode(i.PCIBusLocation)
            PCIBusLocation.appendChild(PCIBusLocation_value)
            
            vendorid = doc.createElement("vendorid")
            cardsummary.appendChild(vendorid)
            
            vendorid_value = doc.createTextNode(i.vendorid)
            vendorid.appendChild(vendorid_value)
            
            deviceid = doc.createElement("deviceid")
            cardsummary.appendChild(deviceid)
            
            deviceid_value = doc.createTextNode('%s'%i.deviceid)
            deviceid.appendChild(deviceid_value)
            
            PortCount = doc.createElement("PortCount")
            cardsummary.appendChild(PortCount)
            
            PortCount_value = doc.createTextNode('%s'%i.PortCount)
            PortCount.appendChild(PortCount_value)
            
            firmwareVersion = doc.createElement("firmwareVersion")
            cardsummary.appendChild(firmwareVersion)
            
            firmwareVersion_value = doc.createTextNode(i.firmwareVersion)
            firmwareVersion.appendChild(firmwareVersion_value)
            
            '''irq = doc.createElement("irq")
            cardsummary.appendChild(irq)
            
            irq_value = doc.createTextNode('%s'%i.irq)
            irq.appendChild(irq_value)'''
            
            if self.ostype == 1:
                osdevice_desc = i.Description
                
                chimney = doc.createElement("chimney")
                cardsummary.appendChild(chimney)
                
                chimney_value = doc.createTextNode('%s'%i.IsChimneyEnable)
                chimney.appendChild(chimney_value)
                
                maintenance = doc.createElement("maintenance")
                cardsummary.appendChild(maintenance)
                
                maintenance_value = doc.createTextNode('%s'%i.AdapterUpdateMode)
                maintenance.appendChild(maintenance_value)
            else:
                osdevice_desc = i.cardName
                
            osdevice = doc.createElement("osdevice")
            cardsummary.appendChild(osdevice)
            
            osdevice_value = doc.createTextNode('%s'%osdevice_desc)
            osdevice.appendChild(osdevice_value)
            
        return doc.toprettyxml()
            
            
