from UmBoostLib import PList , PropsList
from xml.dom.minidom import Document
import simplejson
from DriverInfoFile import DriverDetails

import settings
logging = settings.get_logger()

class CardStatistics:
    
    def __init__(self, session_id , ip, pciloc, chiptype, card_name, type, ostype ):
        self.session_id = session_id
        self.ip = ip
        self.pciloc = pciloc
        self.chiptype = chiptype
        self.card_name = card_name
        self.type = type
        self.ostype = ostype
        self.boostPlistObj = PList() 
        self.boostPropslistObj = PropsList()

    def get_card_statistics(self):
        obj = DriverDetails(self.session_id, self.ip,  'desktop')
        
        '''if self.ostype != '1':
            if self.chiptype.lower() == 't4':
                dr_name_val = 't4_tom'
            elif self.chiptype.lower() == 't3':
                dr_name_val = 't3_tom'
            driver_data = obj.is_driver_loaded( dr_name = dr_name_val )
            if driver_data['status'] == -2 or driver_data['status'] == -1:
                return driver_data['status']
            elif driver_data['loaded'] == -6:
                return -6'''
        
        logging.info('Card Statistics:  waiting for response from UMboost sid : %s , IP : %s , PCILOC : %s, Chiptype: %s, card_name: %s, ostype : %s \
                      '%(self.session_id,self.ip,self.pciloc, self.chiptype, self.card_name, self.ostype))
        status = self.boostPropslistObj.getCardStatistics(self.boostPlistObj,self.session_id,self.ip,self.pciloc, self.chiptype, self.card_name, int(self.ostype))
        logging.info('Card Statistics status: %s'%status)
        if status == 0:
            return self.generateHTML()
        elif status == -2 or status == -9:
            return status
        elif len(self.boostPlistObj) == 0:
            return -6
        else:
            return -1
        
    def getItems(self):
        for i in range(0,len(self.boostPlistObj)):
            yield self.boostPropslistObj.get(self.boostPlistObj,i)

    def generateHTML(self):
        height = 42
        if self.type == 'desktop':
            head_html = '<ul class="horizontal head_ul">\
                            <li><h2>Statistic</h2></li>\
                            <li><h2 class="bg_none" >Value</h2></li>\
                         </ul>'
            
            top_html = '<ul class="horizontal content_tbl clear from_server">\
                        <li class="label">%s</li>'
            bottom_html = '<li class="bg_none card_stats_rec" >%s</li></ul>'
        else:
            head_html = '<div class="ui-grid-a heading" data-theme="b" >\
                            <div class="ui-block-a ui-bar-b center">Property</div>\
                            <div class="ui-block-b ui-bar-b center">Value</div>\
                         </div>'
            top_html = '<div class=" ui-grid-a grid ">\
                        <div class="ui-block-a ">%s</div>'
            bottom_html = '<div class="ui-block-b " >%s</div></div>'
    
        whole_html = '%s%s'
        html_list = []
        for i in self.getItems():
            height += 32
            html_list.append(whole_html%( top_html %  i.propName , bottom_html %  i.value ))
    
        html = ''.join(html_list)
        data = {}
        data['html'] = head_html + html
        data['height'] = height
        return simplejson.dumps(data)
