from UmBoostLib import bc_string, bulk_config_boost
from Constants import CONSTANTS_DICT

import settings, simplejson
logging = settings.get_logger()

class BulkNetworkConf:
    def __init__(self, sid, req_type) :
         self.sid = sid
         self.req_type = req_type
         
    def get_initial_data(self, data):
        
        self.agmtObj = bc_string()
        MainObj = bulk_config_boost()
        
        logging.info('BulkNwConf - List Group : sid : %s , int : 2'%( self.sid ))
        status = MainObj.execute_bc_command(self.sid, 2, "", self.agmtObj);
        logging.info('BulkNwConf - FList Group : status %s'%(status))
        logging.info('Full String : %s'%self.agmtObj.str)
        
        self.return_data = {}
        if status == 0:
            self.return_data['status'] = 0
            self.return_data['html'] = self.generateGroupHtml()
            return simplejson.dumps(self.return_data)
        elif status == -2:
            self.return_data['status'] = -2
            return simplejson.dumps(self.return_data)
        elif CONSTANTS_DICT.has_key(status):
            self.return_data['status'] = 6
            self.return_data['msg'] = CONSTANTS_DICT[status]
            return simplejson.dumps(self.return_data)
        else:
            self.return_data['status'] = -1
            return simplejson.dumps(self.return_data)
    
    def generateGroupHtml(self):
        
        temp_groups = self.agmtObj.str.split('\n')
        groups = temp_groups[:len(temp_groups)-1]
        logging.info("Groups List :%s"%groups)
        
        group_names = []
        is_gp = False
        is_memeber = 1
        for i in groups:
            if i.split(' ')[2].strip().lower() == 'network':
                if i.split(' ')[3].strip() == '':
                   is_memeber = 0
                group_names.append('%s__%s'%(i.split(' ')[0], is_memeber))
                is_gp = True
        logging.info("group_names :%s"%group_names)
        
        if not is_gp:
            self.return_data['status'] = 6
            self.return_data['msg'] = 'No groups available of type "network"'
            return None
        
        html_head = "<select onchange='$(this).removeClass(\"error\")' ><option value=''>Select One..</option>%s</select>"
        option_html = "<option value='%s' name='%s'>%s</option>"
        html_list = [option_html%(i.split('__')[0], i.split('__')[1], i.split('__')[0]) for i in group_names]
        return html_head%''.join(html_list)
    
    def save_nw_conf(self, data):
        
        agmtObj = bc_string()
        MainObj = bulk_config_boost()
        
        if data['action_type'] == 'set_mtu':
            cli_cmd = "net mtu set ifname=BULKIFNAME mtu=%s -B %s"%( data['mtu'], data['group_name'] )
            logging.info('BulkNwConf set mtu: sid : %s , int : 3, cli_cmd : %s'%( self.sid, cli_cmd ))
            status = MainObj.execute_bc_command(self.sid, 3, cli_cmd, agmtObj)
            logging.info('BulkNwConf set mtu: result %s'%(status))
            
        elif data['action_type'] == 'set_vlan':
            cli_cmd = "net vlan set ifname=BULKIFNAME vlan=%s -B %s"%( data['vlan'], data['group_name'] )
            logging.info('BulkNwConf set vlan: sid : %s , int : 3, cli_cmd : %s'%( self.sid, cli_cmd ))
            status = MainObj.execute_bc_command(self.sid, 3, cli_cmd, agmtObj)
            logging.info('BulkNwConf set vlan: result %s'%(status))
            
        elif data['action_type'] == 'set_dhcp':
            cli_cmd = "net Ip set ifname=BULKIFNAME Dhcp=yes -B %s"%( data['group_name'] )
            logging.info('BulkNwConf set dhcp: sid : %s , int : 3, cli_cmd : %s'%( self.sid, cli_cmd ))
            status = MainObj.execute_bc_command(self.sid, 3, cli_cmd, agmtObj)
            logging.info('BulkNwConf set dhcp: result %s'%(status))
        
        return_data = {}
        if status == -2 or status == 100:
            return_data['status'] = status
            return simplejson.dumps(return_data)
        elif CONSTANTS_DICT.has_key(status):
            return_data['status'] = -6
            return_data['error_msg'] = CONSTANTS_DICT[status]
            return simplejson.dumps(return_data)
        else:
            return_data['status'] = -1
            return simplejson.dumps(return_data)