from UmBoostLib import bc_string, bulk_config_boost, SD_system, SD_adapter, SD_port, SD_network
from Constants import CONSTANTS_DICT
import settings, simplejson, os

logging = settings.get_logger()

class BulkManageMachineGroups:
    def __init__(self, sid, req_type) :
         self.sid = sid
         self.req_type = req_type
         
    def create_group(self, data):

        agmtObj = bc_string()
        MainObj = bulk_config_boost()
        
        cli_cmd = "chelsio_uwcli -m  creategroup grpname=%s OSType=%s GroupType=%s"%( data['group_name'], data['gpostype'], data['grouptype'] )
        logging.info('BulkManageMachineGroupsFile - Create Group : sid : %s , int : 1, cli_cmd : %s'%( self.sid, cli_cmd ))
        status = MainObj.execute_bc_command(self.sid, 1, cli_cmd, agmtObj)
        logging.info('BulkManageMachineGroupsFile - Create Group: result %s'%(status))
        
        if status == 0 or status == -2:
            return status
        elif CONSTANTS_DICT.has_key(status):
            return CONSTANTS_DICT[status]
        else:
            return -1
        
    def delete_group(self, data):

        agmtObj = bc_string()
        MainObj = bulk_config_boost()
        cli_cmd = "chelsio_uwcli -m deletegroup grpname=%s"%( data['group_name'] )
        
        logging.info('BulkManageMachineGroupsFile - Delete Group : sid : %s , int : 1, cli_cmd : %s'%( self.sid, cli_cmd ))
        status = MainObj.execute_bc_command(self.sid, 1, cli_cmd, agmtObj)
        logging.info('BulkManageMachineGroupsFile - Delete Group: result %s'%(status))
        
        if status == 0 or status == -2:
            return status
        elif CONSTANTS_DICT.has_key(status):
            return CONSTANTS_DICT[status]
        else:
            return -1
        
    def delete_sys(self, data):

        agmtObj = bc_string()
        MainObj = bulk_config_boost()

        cli_cmd_exec = "chelsio_uwcli -m deletemember grpname=%s index=%s"%(data['group_name'], data['index'])
        logging.info('BulkManageMachineGroupsFile - Delete system : sid : %s , int : 1, cli_cmd : %s'%( self.sid, cli_cmd_exec ))
        status = MainObj.execute_bc_command(self.sid, 1, cli_cmd_exec, agmtObj)
        logging.info('BulkManageMachineGroupsFile - Delete system: result %s'%(status))
        
        if status == -2:
            return status
        else:
            #Always return zero ,since the group machine details gets refreshed with which the user can know about the status        
            return 0
        
    def save_sys(self, data):
        agmtObj = bc_string()
        MainObj = bulk_config_boost()
        
        sys_str = '%s;%s;%s'%( data['sys_ip'], data['username'], data['pwd'] )
        data  = self.assign_optional_char(data)
        desc = data['desc'].replace('&nbsp;','__').replace(' ','__').replace(';','-')
        temp_sys_str = ';%s;%s;%s;%s;%s'%( data['pciid'].strip(), data['ifname'].strip(), data['port_instance'].strip(), data['adpater'].strip(), desc )
        
        cli_cmd_exec = 'chelsio_uwcli -m addmember grpname=%s details=%s%s'%( data['group_name'], sys_str,  temp_sys_str)
        logging.info('BulkManageMachineGroupsFile - Save system : sid : %s , int : 1, cli_cmd : %s'%( self.sid, cli_cmd_exec ))
        status = MainObj.execute_bc_command(self.sid, 1, cli_cmd_exec, agmtObj)
        logging.info('BulkManageMachineGroupsFile - Save system: result %s'%(status))
    
        if status == -2 or status == 0:
            return status
        elif CONSTANTS_DICT.has_key(status):
            return CONSTANTS_DICT[status]
        else:
            return -1
        
    def get_initial_data(self):
        
        self.agmtObj = bc_string()
        MainObj = bulk_config_boost()
        
        logging.info('BulkManageMachineGroupsFile - List Group : sid : %s , int : 2'%( self.sid ))
        status = MainObj.execute_bc_command(self.sid, 2, "", self.agmtObj)
        logging.info('BulkManageMachineGroupsFile - FList Group : status %s'%(status))
        logging.info('Full String : %s'%self.agmtObj.str)
        
        self.return_data = {}
        if status == 0:
            self.return_data['status'] = 0
            if self.agmtObj.str.strip() == '':
                self.return_data['status'] = 6
                self.return_data['error_code'] = -3
                self.return_data['msg'] = CONSTANTS_DICT[-3]
                return simplejson.dumps(self.return_data)
            else: 
                self.return_data['html'] = self.generateGroupHtml()
                return simplejson.dumps(self.return_data)
        elif status == -2:
            self.return_data['status'] = -2
            return simplejson.dumps(self.return_data)
        elif CONSTANTS_DICT.has_key(status):
            self.return_data['status'] = 6
            self.return_data['msg'] = CONSTANTS_DICT[status]
            return simplejson.dumps(self.return_data)
        else:
            self.return_data['status'] = -1
            return simplejson.dumps(self.return_data)
    
    def generateGroupHtml(self):
        
        temp_groups = self.agmtObj.str.split('\n')
        groups = temp_groups[:len(temp_groups)-1]
        #logging.info("Groups List :%s"%groups)
        
        html_head = "<select class='group_sel' onchange='$(this).removeClass(\"error\");blk_mmg_toggle_btn($(this));blk_mmg_gp_change($(this))' ><option value=''>Select One..</option>%s</select>"
        option_html = "<option value='%s' ostype='%s' grouptype='%s'>%s</option>"
        html_list = [option_html%(i.split(' ')[0],i.split(' ')[1], i.split(' ')[2], i.split(' ')[0]) for i in groups]
        return html_head%''.join(html_list)
    
    def get_sys(self, data):

        self.agmtObj = bc_string()
        MainObj = bulk_config_boost()
        self.group_name = data['group_name']
        
        logging.info('BulkManageMachineGroupsFile - List Group : sid : %s , int : 2'%( self.sid ))
        status = MainObj.execute_bc_command(self.sid, 2, "", self.agmtObj);
        logging.info('BulkManageMachineGroupsFile - FList Group : status %s'%(status))
        logging.info('Full String : %s'%self.agmtObj.str)
        
        self.return_data = {}
        if status == 0:
            self.return_data['status'] = 0
            if self.agmtObj.str.strip() == '':
                self.return_data['status'] = -3
                return simplejson.dumps(self.return_data)
            else: 
                self.return_data['html'] = self.generateGroupMachineListHtml()
                logging.info(self.return_data['html'])
                return simplejson.dumps(self.return_data)
        elif status == -2:
            self.return_data['status'] = -2
            return simplejson.dumps(self.return_data)
        elif CONSTANTS_DICT.has_key(status):
            self.return_data['status'] = 6
            self.return_data['msg'] = CONSTANTS_DICT[status]
            return simplejson.dumps(self.return_data)
        else:
            self.return_data['status'] = -1
            return simplejson.dumps(self.return_data)
        
    def generateGroupMachineListHtml(self):
        groups = self.agmtObj.str.split('\n')
        sys_list = ''
        sys_str = ''
        for i in groups:
            if i.split(' ')[0] == self.group_name:
                sys_str = i.split(' ')[3]
        
        sys_list = sys_str.split(',')
        if not len(sys_list):
            return -4
        
        html_list = []
        height = 485+37+50
        html_list.append('<ul class="horizontal head_ul">\
                            <li class="sno"><h2>SNO</h2></li>\
                            <li class="host_ip"><h2>Hostname / IP</h2></li>\
                            <li class="user_name"><h2>Username</h2></li>\
                            <li class="pwd"><h2>Password</h2></li>\
                            <li class="details"><h2>Details</h2></li>\
                        </ul>')
        j = 0
        atleast_one_sys = False
        for i in sys_list:
            j += 1
            height += 33
            temp_sys_dict = { 'ip' : '-', 'username' : '-' , 'pwd' : '-' , 'detail' : '-'  }
            curr_sys_list = i.split(';')
            if len(curr_sys_list) >=3:
                temp_sys_dict['ip'] = curr_sys_list[0]
                temp_sys_dict['username'] = curr_sys_list[1]
                #temp_sys_dict['pwd'] = curr_sys_list[2]
                current_sys_len = len(curr_sys_list)
            else:
                continue
            
            if len(curr_sys_list) == 8:
                details = curr_sys_list[7].replace('__','&nbsp;').replace('-',';')
                logging.info(details)
                #details = ''
            else:
                details = '-'
            
            atleast_one_sys = True
            html_list.append('<ul class="horizontal clear_left content_tbl rules_ul">\
                                <li class="sno">\
                                    <input class="sno_chk" type="radio" name="gp_system" value="%s" onclick="blk_mmg_toggle_btn($(this))" />%s\
                                </li>\
                                <li class="host_ip">%s</li>\
                                <li class="user_name">%s</li>\
                                <li class="pwd">%s</li>\
                                <li class="details">%s</li>\
                            </ul>'%( j-1, j, self.return_hyphen(temp_sys_dict['ip']),self.return_hyphen(temp_sys_dict['username']), 
                                     "***********", details))
                        
        if not atleast_one_sys:
            return -4
        
        html_list.append('<div class="clear_left"></div>')
        self.return_data['height'] = height
        return ''.join(html_list)
    
    def return_hyphen(self, value_str):
        if value_str.strip() == '*':
            return '-'
        else:
            return value_str
        
    def assign_optional_char(self, data):
        for key, val in data.items():
            if val.strip() == '':
                data[key] = '*'
        return data

    def fetch_data(self, data):

        logging.info('BulkManageMachineGroupsFile fetch_data -  : sid : %s, sys_ip : %s, username : %s, pwd : *****'%(  self.sid, data['sys_ip'] ,data['username']))
        sd_obj = SD_system()
        status = sd_obj.fetch_data(self.sid, data['sys_ip'] ,data['username'], data['pwd'])
        logging.info('BulkManageMachineGroupsFile fetch_data: %s'%status)
        
        self.return_data = {}
        if status == -2:
            self.return_data['status'] = status
            return simplejson.dumps(self.return_data) 
        elif status == 0:
            self.return_data['status'] = 0
            self.generateFetchDataHtml(sd_obj, data)
            return simplejson.dumps(self.return_data)
        elif CONSTANTS_DICT.has_key(status):
            self.return_data['status'] = -6
            self.return_data['error_msg'] = CONSTANTS_DICT[status]
            return simplejson.dumps(self.return_data)
        else:
            self.return_data['status'] = -1
            return simplejson.dumps(self.return_data)
        
    def generateFetchDataHtml(self, sd_obj, get_data):
        
        detail_html = '<select class="details">'

	if get_data['group_type'] == 't5port':
            is_t5_card = False
            is_t5_port = False
            adapter_count = sd_obj.adapter_count
            adap_obj = SD_adapter()
            logging.info('adapter_count : %s'%adapter_count)
            for i in range(adapter_count):
                sd_obj.get_adapter(i, adap_obj)
                logging.info('adap_obj.adapter_type : %s'%adap_obj.adapter_type)
                if adap_obj.adapter_type == 5:
                    is_t5_card = True
                    port_count = adap_obj.port_count
                    logging.info('port_count : %s'%port_count)
                    pt_obj = SD_port()
                    for j in range(port_count):
                        is_t5_port = True
                        sd_obj.get_port(i, j, pt_obj)
                        info_str = '[&nbsp;&nbsp;%s ; PCI Location :%s&nbsp;&nbsp;]'%( adap_obj.model_str, adap_obj.pci_location )
                        detail_html += '<option value="%s#%s" >Port #%s &nbsp;%s</option>'%( adap_obj.pci_location, pt_obj.instance_no, pt_obj.instance_no, info_str )

            if not is_t5_card:
                self.return_data['status'] = -6
                self.return_data['error_msg'] = 'No T5 adpater found'
                return None
            elif not is_t5_port:
                self.return_data['status'] = -6
                self.return_data['error_msg'] = 'No Ports found'
                return None
            else:
                detail_html += '</select>'
                self.return_data['html'] = detail_html

        
        elif get_data['group_type'] == 't4port':
            is_t4_card = False
            is_t4_port = False
            adapter_count = sd_obj.adapter_count
            adap_obj = SD_adapter()
            logging.info('adapter_count : %s'%adapter_count)
            for i in range(adapter_count):
                sd_obj.get_adapter(i, adap_obj)
                logging.info('adap_obj.adapter_type : %s'%adap_obj.adapter_type)
                if adap_obj.adapter_type == 4:
                    is_t4_card = True
                    port_count = adap_obj.port_count
                    logging.info('port_count : %s'%port_count)
                    pt_obj = SD_port()
                    for j in range(port_count):
                        is_t4_port = True
                        sd_obj.get_port(i, j, pt_obj)
                        info_str = '[&nbsp;&nbsp;%s ; PCI Location :%s&nbsp;&nbsp;]'%( adap_obj.model_str, adap_obj.pci_location )
                        detail_html += '<option value="%s#%s" >Port #%s &nbsp;%s</option>'%( adap_obj.pci_location, pt_obj.instance_no, pt_obj.instance_no, info_str )
            
            if not is_t4_card:
                self.return_data['status'] = -6
                self.return_data['error_msg'] = 'No T4 adpater found'
                return None
            elif not is_t4_port:
                self.return_data['status'] = -6
                self.return_data['error_msg'] = 'No Ports found'
                return None
            else:
                detail_html += '</select>'
                self.return_data['html'] = detail_html
                
        elif get_data['group_type'] == 't3port':
            is_t3_card = False
            is_t3_port = False
            adapter_count = sd_obj.adapter_count
            adap_obj = SD_adapter()
            for i in range(adapter_count):
                sd_obj.get_adapter(i, adap_obj)
                if adap_obj.adapter_type == 3:
                    is_t3_card = True
                    port_count = adap_obj.port_count
                    pt_obj = SD_port()
                    for j in range(port_count):
                        is_t3_port = True
                        sd_obj.get_port(i, j, pt_obj)
                        info_str = '[&nbsp;&nbsp;%s ; PCI Location :%s&nbsp;&nbsp;]'%( adap_obj.model_str, adap_obj.pci_location )
                        detail_html += '<option value="%s#%s" >Port #%s &nbsp;%s</option>'%( adap_obj.pci_location, pt_obj.instance_no, pt_obj.instance_no, info_str )
            
            if not is_t3_card:
                self.return_data['status'] = -6
                self.return_data['error_msg'] = 'No T3 adpater found'
                return None
            elif not is_t3_port:
                self.return_data['status'] = -6
                self.return_data['error_msg'] = 'No Ports found'
                return None
            else:
                detail_html += '</select>'
                self.return_data['html'] = detail_html
        
        elif get_data['group_type'] == 'network':
            ip_type = { 1 : 'static', 2 : 'dhcp' }
            is_nw = False
            nw_count = sd_obj.network_count
            logging.info('nw_count :%s'%nw_count)
            nt_obj = SD_network()
            for i in range(nw_count):
                logging.info('---loop :%s'%i)
                is_nw = True
                sd_obj.get_network(i, nt_obj)
                is_bypass = '' 
                if nt_obj.desc.count('bypass'):
                    is_bypass = '; Bypass Interface'
                    
                logging.info('nt_obj.mac_address :%s'%nt_obj.mac_address)
                logging.info('nt_obj.ip_addr :%s'%nt_obj.ip_addr)
                logging.info('nt_obj.ip_type :%s'%nt_obj.ip_type)
                logging.info('nt_obj.iface_name :%s'%nt_obj.iface_name)
                info_str = '&nbsp;&nbsp;[&nbsp;&nbsp;MAC:%s ; IP:%s/%s&nbsp;&nbsp;%s]'%( nt_obj.mac_address, nt_obj.ip_addr , ip_type[nt_obj.ip_type], is_bypass)
                detail_html += '<option value="%s" >%s %s</option>'%( nt_obj.iface_name, nt_obj.iface_name, info_str )
                logging.info('\n')
            
            if not is_nw:
                self.return_data['status'] = -6
                self.return_data['error_msg'] = 'No networks found'
                return None
            else:
                detail_html += '</select>'
                self.return_data['html'] = detail_html
                return None
            
        elif get_data['group_type'] == 't4adapter':
            is_t4_adap = False
            adap_count = sd_obj.adapter_count
            adap_obj = SD_adapter()
            for i in range(adap_count):
                t4adap_obj = sd_obj.get_adapter(i, adap_obj)
                if adap_obj.adapter_type == 4:
                    is_t4_adap = True
                    info_str = '&nbsp;&nbsp;[&nbsp;&nbsp;%s ; PCI Location: %s&nbsp;&nbsp;]'%( adap_obj.model_str, adap_obj.pci_location)
                    detail_html += '<option value="%s" >Adpater Idx&nbsp;:&nbsp;%s %s</option>'%( adap_obj.adapter_instance_no, adap_obj.adapter_instance_no, info_str )
            
            if not is_t4_adap:
                self.return_data['status'] = -6
                self.return_data['error_msg'] = 'No T4 Adapter found'
                return None
            else:
                detail_html += '</select>'
                self.return_data['html'] = detail_html
                return None
        elif get_data['group_type'] == 't5adapter':
            is_t5_adap = False
            adap_count = sd_obj.adapter_count
            adap_obj = SD_adapter()
            for i in range(adap_count):
                t4adap_obj = sd_obj.get_adapter(i, adap_obj)
                if adap_obj.adapter_type == 5:
                    is_t5_adap = True
                    info_str = '&nbsp;&nbsp;[&nbsp;&nbsp;%s ; PCI Location: %s&nbsp;&nbsp;]'\
				                     %( adap_obj.model_str, adap_obj.pci_location)
                    detail_html += '<option value="%s" >Adpater Idx&nbsp;:&nbsp;%s %s</option>'\
				%( adap_obj.adapter_instance_no, adap_obj.adapter_instance_no, info_str )

            if not is_t5_adap:
                self.return_data['status'] = -6
                self.return_data['error_msg'] = 'No T5 Adapter found'
                return None
            else:
                detail_html += '</select>'
                self.return_data['html'] = detail_html
                return None
            
        elif get_data['group_type'] == 't3adapter':
            is_t3_adap = False
            adap_count = sd_obj.adapter_count
            adap_obj = SD_adapter()
            for i in range(adap_count):
                t4adap_obj = sd_obj.get_adapter(i, adap_obj)
                if adap_obj.adapter_type == 3:
                    is_t3_adap = True
                    info_str = '&nbsp;&nbsp;[&nbsp;&nbsp;%s ; PCI Location: %s&nbsp;&nbsp;]'%( adap_obj.model_str, adap_obj.pci_location)
                    detail_html += '<option value="%s" >Adpater Idx&nbsp;:&nbsp;%s %s</option>'%( adap_obj.adapter_instance_no, adap_obj.adapter_instance_no, info_str )
            
            if not is_t3_adap:
                self.return_data['status'] = -6
                self.return_data['error_msg'] = 'No T3 Adapter found'
                return None
            else:
                detail_html += '</select>'
                self.return_data['html'] = detail_html
                return None
        return None
