from UmBoostLib import bc_string, bulk_config_boost
from Constants import CONSTANTS_DICT
import settings, simplejson, time
logging = settings.get_logger()

class BulkConfigStatus:
    
    def __init__(self, sid, req_type) :
         self.sid = sid
         self.req_type = req_type
         
    def bulk_poll(self):

        return_data = {}
        agmtObj = bc_string()
        MainObj = bulk_config_boost()

        logging.info('Bulk Config status Poll : sid : %s , int : 4'%( self.sid ))
        status = MainObj.execute_bc_command(self.sid, 4, "", agmtObj)
        logging.info('Bulk Config status: result %s, str : %s'%(status, agmtObj.str))
        
        if status != 0:
            return_data['status'] = -1
            if CONSTANTS_DICT.has_key(status):
                return_data['err_msg'] = CONSTANTS_DICT[status]
                return simplejson.dumps(return_data)
            else:
                return_data['err_msg'] = 'Failed'
                return simplejson.dumps(return_data)
        else:
            bulk_status = agmtObj.str.split(' ')[0].strip()
            status_str = agmtObj.str[2:]
            if bulk_status == '2':
                logging.info('Bulk Config status Destroy Poll : sid : %s , int : 5'%( self.sid ))
                status = MainObj.execute_bc_command(self.sid, 5, "", agmtObj)
                logging.info('Bulk Config status Destroy Poll: result %s'%(status))
                
                return_data['status'] = 2
                return_data['html'] = self.generateStatusHtml(status_str)
                return simplejson.dumps(return_data)
            elif bulk_status == '1':
                #Still some machines are in progress, then sleep for a while
                return_data['status'] = 1
                return_data['html'] = self.generateStatusHtml(status_str)
                time.sleep(2)
                return simplejson.dumps(return_data)
        
    def generateStatusHtml(self, status_str):
        
        html = '<ul class="horizontal head_ul">\
                    <li><h2>Ip</h2></li>\
                    <li><h2 class="bg_none" >Status</h2></li>\
                 </ul>'
                 
        status_list = status_str.split(' ')
        j = -2
        for i in range(len(status_list)/2):
            j = j + 2 
            result = ''
            status_code = int(status_list[j+1])
            status_class = ''
            curr_ip = status_list[j]
            if status_code == 0:
                result = 'Success'
                status_class = 'green_f'
            elif status_code == -100:
                result = '<img src="/images/black/bulk_loader.gif" />'
            else:
                status_class = 'red_f'
                if CONSTANTS_DICT.has_key(status_code):
                    result = CONSTANTS_DICT[status_code]
                else:
                    result = 'Failed'

            html += '<ul class="horizontal content_tbl clear_left">\
                        <li class="label bk_dr_r_ip">%s</li>\
                        <li class="label bk_dr_r_status %s">%s</li>\
                     </ul>'%( curr_ip, status_class, result )
        return html + '<div class="clear_left"></div>'
        
        
