from UmBoostLib import bc_string, bulk_config_boost
from xml.dom.minidom import Document
from Constants import CONSTANTS_DICT
import re

import settings, simplejson
logging = settings.get_logger()

class BulkBypass:
    def __init__(self, sid, ip) :
         self.sid = sid
         self.ip = ip
         
    def get_initial_data(self, data):
        
        self.agmtObj = bc_string()
        MainObj = bulk_config_boost()
        
        logging.info('BulkBypass - List Group : sid : %s , int : 2'%( self.sid ))
        status = MainObj.execute_bc_command(self.sid, 2, "", self.agmtObj);
        logging.info('BulkBypass - FList Group : status %s'%(status))
        logging.info('Full String : %s'%self.agmtObj.str)
        
        self.return_data = {}
        if status == 0:
            self.return_data['status'] = 0
            self.return_data['html'] = self.generateGroupHtml()
            return simplejson.dumps(self.return_data)
        elif status == -2:
            self.return_data['status'] = -2
            return simplejson.dumps(self.return_data)
        elif CONSTANTS_DICT.has_key(status):
            self.return_data['status'] = 6
            self.return_data['msg'] = self.generate_status(CONSTANTS_DICT[status])
            return simplejson.dumps(self.return_data)
        else:
            self.return_data['status'] = -1
            return simplejson.dumps(self.return_data)

    def start_stop_server(self, action, in_data):
        agmtObj = bc_string()
        MainObj = bulk_config_boost()
        exec_cmd = 'bypass %s iface=BULKIFNAME -B %s'%(action, in_data['group_name'])
        logging.info('Bypass starting or stopping server action sid : %s , cmd :%s'%( self.sid, exec_cmd ))
        status = MainObj.execute_bc_command(self.sid, 3, exec_cmd, agmtObj)
        logging.info('Bypass starting or stopping server status sid : %s ,cmd: %s, status: %s'%( self.sid, exec_cmd, status ))
        logging.info('Full String : %s'%agmtObj.str)

        if status >= 0:
            return self.generate_status(status)
        elif CONSTANTS_DICT.has_key(status):
            return self.generate_status(CONSTANTS_DICT[status])
        else:
            return self.generate_status('-1')
    
    def set_server_config(self, in_data):
        agmtObj = bc_string()
        MainObj = bulk_config_boost()
        exec_cmd = 'bypass cmd command="bypass BULKIFNAME set --%s %s" -B %s'%(in_data['propname'], in_data['value'], in_data['group_name'])
        logging.info('Bypass setting server config sid : %s , cmd :%s'%( self.sid, exec_cmd ))
        status = MainObj.execute_bc_command(self.sid, 3, exec_cmd, agmtObj)
        logging.info('Bypass setting server status sid : %s ,cmd: %s, status: %s'%( self.sid, exec_cmd, status ))
        logging.info('Full String : %s'%agmtObj.str)

        if status > 0:
		return self.generate_status(status)
        elif CONSTANTS_DICT.has_key(status):
		return self.generate_status(CONSTANTS_DICT[status])
        else:
		return self.generate_status('-1')

    def set_redirect_config(self, in_data):
        logging.info('-----------------1')
    	agmtObj = bc_string()
        logging.info('-----------------2')
    	MainObj = bulk_config_boost()
        logging.info('-----------------3')
    	file_path = in_data['drpath']
    	file = open(file_path)
    	cmd_list = []
    	for line in file:
    		line = line.rstrip()
    		comment_patt = re.compile('^#')
    		if comment_patt.match(line):
    			continue
    		elif line == '':
    			continue
    		else:
    			#replace ethX with BULKIFNAME
    			new_line = re.sub(r'eth\d+', "BULKIFNAME", line)
    			cmd_list.append(new_line)
    	
        logging.info('-----------------4')
        if (len(cmd_list) != 0):
            cmd_str = ';'.join(cmd_list)
            exec_cmd = 'bypass cmd command="%s" -B %s'%(cmd_str, in_data['group_name'])
            logging.info('-----------------5')
            logging.info(exec_cmd)
            status = MainObj.execute_bc_command(self.sid, 3, exec_cmd, agmtObj)
            logging.info('-----------------6')
            logging.info('Bypass set_redirect_config sid: %s cmd: %s  status: %s\n'%( self.sid, exec_cmd, status ))
            logging.info('Full String : %s'%agmtObj.str)
            if status > 0:
                return self.generate_status(status)
            elif CONSTANTS_DICT.has_key(status):
                return self.generate_status(CONSTANTS_DICT[status])
            else:
                return self.generate_status('-1')
    	else:
    		return -1

    def generateGroupHtml(self):
        
        temp_groups = self.agmtObj.str.split('\n')
        groups = temp_groups[:len(temp_groups)-1]
        logging.info("Groups List :%s"%groups)
        
        group_names = []
        is_gp = False
        is_memeber = 1
        for i in groups:
            if i.split(' ')[2].strip().lower() == 'network':
                if i.split(' ')[3].strip() == '':
                   is_memeber = 0
                group_names.append('%s__%s__%s__%s'%(i.split(' ')[0], is_memeber, i.split(' ')[1], i.split(' ')[2]))
                is_gp = True
        logging.info("group_names :%s"%group_names)
        
        if not is_gp:
            self.return_data['status'] = 6
            self.return_data['msg'] = 'No groups available of type "network"'
            return None
        
     
        html_head = "<select class='group_sel' onchange='$(this).removeClass(\"error\");check_os($(this));' ><option value=''>Select One..</option>%s</select>"
        option_html = "<option value='%s' ostype='%s' gptype='%s' name='%s'>%s</option>"
        html_list = [ option_html%( i.split('__')[0], i.split('__')[2], i.split('__')[3], i.split('__')[1], i.split('__')[0] ) for i in group_names ]

        return html_head%''.join(html_list)
        
    def generate_status(self, status):        
        
        doc = Document()
        uploadlickey = doc.createElement("bypass")
        doc.appendChild(uploadlickey)
        
        status_node = doc.createElement("status")
        uploadlickey.appendChild(status_node)
        
        status_val = doc.createTextNode(str(status))
        status_node.appendChild(status_val)
        return doc.toprettyxml()
